/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.rdfxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Map;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.atlas.web.ContentType;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.TypeMapper;
import org.apache.jena.datatypes.xsd.impl.XMLLiteralType;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.irix.IRIs;
import org.apache.jena.rdf.model.RDFErrorHandler;
import org.apache.jena.rdfxml.xmlinput1.ALiteral;
import org.apache.jena.rdfxml.xmlinput1.ARP;
import org.apache.jena.rdfxml.xmlinput1.ARPOptions;
import org.apache.jena.rdfxml.xmlinput1.AResource;
import org.apache.jena.rdfxml.xmlinput1.NamespaceHandler;
import org.apache.jena.rdfxml.xmlinput1.ParseException;
import org.apache.jena.rdfxml.xmlinput1.StatementHandler;
import org.apache.jena.rdfxml.xmlinput1.impl.ARPSaxErrorHandler;
import org.apache.jena.riot.RIOT;
import org.apache.jena.riot.ReaderRIOT;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotParseException;
import org.apache.jena.riot.SysRIOT;
import org.apache.jena.riot.lang.rdfxml.ReaderRDFXML_ARP0;
import org.apache.jena.riot.system.ErrorHandler;
import org.apache.jena.riot.system.FactoryRDF;
import org.apache.jena.riot.system.ParserProfile;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.sparql.util.Context;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class ReaderRDFXML_ARP1
implements ReaderRIOT {
    public static ReaderRIOTFactory factory = (language, parserProfile) -> new ReaderRDFXML_ARP1(parserProfile);
    private final ParserProfile parserProfile;
    private final ErrorHandler errorHandler;
    public static final boolean RiotUniformCompatibility = true;
    private static int[] additionalErrors = new int[]{115};
    private static boolean errorForSpaceInURI = true;

    public ReaderRDFXML_ARP1(ParserProfile parserProfile) {
        this.parserProfile = parserProfile;
        this.errorHandler = parserProfile.getErrorHandler();
    }

    @Override
    public void read(InputStream in, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        this.parse(in, null, baseURI, ct, output, context2);
    }

    @Override
    public void read(Reader reader, String baseURI, ContentType ct, StreamRDF output, Context context2) {
        this.parse(null, reader, baseURI, ct, output, context2);
    }

    private void oneProperty(ARPOptions options, String pName, Object value) {
        int val;
        int cond;
        block8: {
            block9: {
                block7: {
                    if (!(pName.startsWith("ERR_") || pName.startsWith("IGN_") || pName.startsWith("WARN_"))) {
                        return;
                    }
                    cond = ParseException.errorCode(pName);
                    if (cond == -1) {
                        throw new RiotException("No such ARP property: '" + pName + "'");
                    }
                    if (!(value instanceof String)) break block7;
                    if (!((String)value).startsWith("EM_")) {
                        throw new RiotException("Value for ARP property does not start EM_: '" + pName + "' = '" + value + "'");
                    }
                    val = ParseException.errorCode((String)value);
                    if (val == -1) {
                        throw new RiotException("Illegal value for ARP property: '" + pName + "' = '" + value + "'");
                    }
                    break block8;
                }
                if (!(value instanceof Integer)) break block9;
                val = (Integer)value;
                switch (val) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: {
                        break block8;
                    }
                    default: {
                        throw new RiotException("Illegal value for ARP property: '" + pName + "' = '" + value + "'");
                    }
                }
            }
            throw new RiotException("Property \"" + pName + "\" cannot have value: " + value.toString());
        }
        options.setErrorMode(cond, val);
    }

    private void parse(InputStream input, Reader reader, String xmlBase, ContentType ct, StreamRDF sink, Context context2) {
        boolean legacySwitch = context2.isTrue(RIOT.symRDFXML0);
        if (legacySwitch) {
            Log.warnOnce(SysRIOT.getLogger(), "Do not use rdfxml:rdfxml0 - use Lang RRX#RDFXML_ARP0 or \"--syntax arp0\"", ReaderRDFXML_ARP0.class);
            ReaderRDFXML_ARP0 other = new ReaderRDFXML_ARP0(this.parserProfile.getErrorHandler());
            other.parse(input, reader, xmlBase, ct, sink, context2);
            return;
        }
        sink.start();
        HandlerSink rslt = new HandlerSink(sink, this.parserProfile);
        ARP arp = new ARP();
        arp.getHandlers().setStatementHandler(rslt);
        arp.getHandlers().setErrorHandler(rslt);
        arp.getHandlers().setNamespaceHandler(rslt);
        ARPOptions arpOptions = arp.getOptions();
        for (int code : additionalErrors) {
            arpOptions.setErrorMode(code, 2);
        }
        if (context2 != null) {
            Map properties = null;
            try {
                Map p;
                properties = p = (Map)context2.get(SysRIOT.sysRdfReaderProperties);
            }
            catch (Throwable ex) {
                Log.warn(this, "Problem accessing the RDF/XML reader properties: properties ignored", ex);
            }
            if (properties != null) {
                properties.forEach((k, v) -> this.oneProperty(arpOptions, (String)k, v));
            }
        }
        arp.setOptionsWith(arpOptions);
        String filename = xmlBase;
        try {
            if (reader != null) {
                arp.load(reader, xmlBase);
            } else {
                arp.load(input, xmlBase);
            }
        }
        catch (IOException e2) {
            this.errorHandler.error(filename + ": " + ParseException.formatMessage(e2), -1L, -1L);
        }
        catch (SAXParseException e2) {
        }
        catch (SAXException sax) {
            this.errorHandler.error(filename + ": " + ParseException.formatMessage(sax), -1L, -1L);
        }
        sink.finish();
    }

    private static String baseURI_RDFXML(String baseIRI) {
        if (baseIRI == null) {
            return IRIs.getBaseStr();
        }
        return baseIRI;
    }

    private static class HandlerSink
    extends ARPSaxErrorHandler
    implements StatementHandler,
    NamespaceHandler {
        private final StreamRDF output;
        private final ParserProfile parserProfile;
        private final ErrorHandler riotErrorHandler;
        private final FactoryRDF termFactory;

        HandlerSink(StreamRDF output, ParserProfile parserProfile) {
            super(new ErrorHandlerBridge(parserProfile.getErrorHandler()));
            this.output = output;
            this.parserProfile = parserProfile;
            this.riotErrorHandler = parserProfile.getErrorHandler();
            this.termFactory = parserProfile.getFactorRDF();
        }

        @Override
        public void statement(AResource subj, AResource pred, AResource obj) {
            this.output.triple(this.convert(subj, pred, obj));
        }

        @Override
        public void statement(AResource subj, AResource pred, ALiteral lit) {
            this.output.triple(this.convert(subj, pred, lit));
        }

        private Node convert(ALiteral lit) {
            String dtURI = lit.getDatatypeURI();
            if (dtURI == null) {
                return this.parserProfile.createLangLiteral(lit.toString(), lit.getLang(), -1L, -1L);
            }
            if (lit.isWellFormedXML()) {
                return this.parserProfile.createTypedLiteral(lit.toString(), XMLLiteralType.rdfXMLLiteral, -1L, -1L);
            }
            RDFDatatype dt = TypeMapper.getInstance().getSafeTypeByName(dtURI);
            return this.parserProfile.createTypedLiteral(lit.toString(), dt, -1L, -1L);
        }

        private Node convert(AResource r) {
            if (!r.isAnonymous()) {
                String uriStr = r.getURI();
                if (errorForSpaceInURI && uriStr.contains(" ")) {
                    int i = uriStr.indexOf(32);
                    String s = uriStr.substring(0, i);
                    String msg = String.format("Bad character in IRI (space): <%s[space]...>", s);
                    this.riotErrorHandler.error(msg, -1L, -1L);
                    throw new RiotParseException(msg, -1L, -1L);
                }
                return this.termFactory.createURI(uriStr);
            }
            Node rr = (Node)r.getUserData();
            if (rr == null) {
                rr = this.termFactory.createBlankNode();
                r.setUserData(rr);
            }
            return rr;
        }

        private Triple convert(AResource s, AResource p, AResource o) {
            return Triple.create(this.convert(s), this.convert(p), this.convert(o));
        }

        private Triple convert(AResource s, AResource p, ALiteral o) {
            return Triple.create(this.convert(s), this.convert(p), this.convert(o));
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
            this.output.prefix(prefix, uri);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }
    }

    private static class ErrorHandlerBridge
    implements RDFErrorHandler {
        private ErrorHandler errorHandler;

        ErrorHandlerBridge(ErrorHandler hander) {
            this.errorHandler = hander;
        }

        @Override
        public void warning(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.warning(e2.getMessage(), p.getLeft().intValue(), p.getRight().intValue());
        }

        @Override
        public void error(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.error(e2.getMessage(), p.getLeft().intValue(), p.getRight().intValue());
        }

        @Override
        public void fatalError(Exception e2) {
            Pair<Integer, Integer> p = ErrorHandlerBridge.getLineCol(e2);
            this.errorHandler.fatal(e2.getMessage(), p.getLeft().intValue(), p.getRight().intValue());
        }

        private static Pair<Integer, Integer> getLineCol(Exception e2) {
            if (e2 instanceof SAXParseException) {
                SAXParseException esax = (SAXParseException)e2;
                return Pair.create(esax.getLineNumber(), esax.getColumnNumber());
            }
            return Pair.create(-1, -1);
        }
    }
}

