/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.validation.json;

import jakarta.servlet.http.HttpServletResponse;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.jena.fuseki.Fuseki;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.validation.json.ValidationAction;
import org.slf4j.Logger;

public abstract class ValidatorJsonLib {
    private static Logger vLog = Fuseki.validationLog;
    public static final String jErrors = "errors";
    public static final String jWarnings = "warning";
    public static final String jParseError = "parse-error";
    public static final String jParseErrorLine = "parse-error-line";
    public static final String jParseErrorCol = "parse-error-column";
    public static final String respService = "X-Service";
    protected static AtomicLong counter = new AtomicLong(0L);

    static void setHeaders(HttpServletResponse httpResponse) {
        httpResponse.setCharacterEncoding("utf-8");
        httpResponse.setContentType("application/json");
        httpResponse.setHeader(respService, "Jena Fuseki Validator : http://jena.apache.org/");
    }

    static String getArg(ValidationAction action, String paramName) {
        String arg = ValidatorJsonLib.getArgOrNull(action, paramName);
        if (arg == null) {
            ServletOps.error(400, "No parameter given: " + paramName);
            return null;
        }
        return arg;
    }

    static String getArgOrNull(ValidationAction action, String paramName) {
        String[] args = ValidatorJsonLib.getArgs(action, paramName);
        if (args == null || args.length == 0) {
            return null;
        }
        if (args.length > 1) {
            ServletOps.error(400, "Too many (" + args.length + ") parameter values: " + paramName);
            return null;
        }
        return args[0];
    }

    static String[] getArgs(ValidationAction action, String paramName) {
        String[] args = action.request.getParameterValues(paramName);
        if (args == null || args.length == 0) {
            return null;
        }
        return args;
    }
}

