/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.omnifaces.util.cache.CacheEntry;
import org.omnifaces.util.cache.TimeToLiveCache;
import org.omnifaces.util.concurrentlinkedhashmap.ConcurrentLinkedHashMap;

public class DefaultCache
extends TimeToLiveCache {
    private static final long serialVersionUID = 1L;

    public DefaultCache(Integer defaultTimeToLive, Integer maxCapacity) {
        super(defaultTimeToLive);
        this.setCacheStore(this.createCacheStore(maxCapacity));
    }

    private Map<String, CacheEntry> createCacheStore(Integer maxCapacity) {
        if (maxCapacity != null) {
            return new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(maxCapacity.intValue()).build();
        }
        return new ConcurrentHashMap<String, CacheEntry>();
    }
}

