/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.converter;

import java.util.AbstractMap;
import java.util.List;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.convert.FacesConverter;
import javax.faces.event.PhaseId;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Utils;
import org.omnifaces.util.selectitems.SelectItemsUtils;

@FacesConverter(value="omnifaces.SelectItemsIndexConverter")
public class SelectItemsIndexConverter
implements Converter<Object> {
    private static final String ATTRIBUTE_SELECT_ITEMS = "SelectItemsIndexConverter.%s";
    private static final String ERROR_SELECT_ITEMS_LIST_INDEX = "Could not determine index for value ''{0}'' in component {1}.";
    private static final String ERROR_GET_AS_OBJECT = "Could not convert value ''{0}'' for component {1}.";

    public Object getAsObject(FacesContext context2, UIComponent component, String submittedValue) {
        if (Utils.isEmpty(submittedValue)) {
            return null;
        }
        List<Object> selectItemValues = SelectItemsUtils.collectAllValuesFromSelectItems(context2, component);
        try {
            return selectItemValues.get(Integer.parseInt(submittedValue));
        }
        catch (NumberFormatException e2) {
            throw new ConverterException(Messages.createError(ERROR_SELECT_ITEMS_LIST_INDEX, submittedValue, component.getClientId(context2)), (Throwable)e2);
        }
        catch (Exception e3) {
            throw new ConverterException(Messages.createError(ERROR_GET_AS_OBJECT, submittedValue, component.getClientId(context2)), (Throwable)e3);
        }
    }

    public String getAsString(FacesContext context2, UIComponent component, Object modelValue) {
        List selectItemValues;
        String key = String.format(ATTRIBUTE_SELECT_ITEMS, component.getClientId(context2));
        AbstractMap.SimpleEntry<PhaseId, List> selectItemValuesByPhaseId = (AbstractMap.SimpleEntry<PhaseId, List>)Faces.getContextAttribute(key);
        if (selectItemValuesByPhaseId == null || selectItemValuesByPhaseId.getKey() != context2.getCurrentPhaseId()) {
            selectItemValues = SelectItemsUtils.collectAllValuesFromSelectItems(context2, component);
            selectItemValuesByPhaseId = new AbstractMap.SimpleEntry<PhaseId, List>(context2.getCurrentPhaseId(), selectItemValues);
            Faces.setContextAttribute(key, selectItemValuesByPhaseId);
        }
        selectItemValues = (List)selectItemValuesByPhaseId.getValue();
        for (int i = 0; i < selectItemValues.size(); ++i) {
            Object selectItemValue = selectItemValues.get(i);
            if (!(Utils.isEmpty(modelValue) ? Utils.isEmpty(selectItemValue) : modelValue.equals(selectItemValue))) continue;
            return Integer.toString(i);
        }
        return "";
    }
}

