/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.WriteListener;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritePendingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import org.eclipse.jetty.ee10.servlet.ServletChannel;
import org.eclipse.jetty.ee10.servlet.ServletChannelState;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.Blocker;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.eclipse.jetty.util.thread.ThreadIdPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpOutput
extends ServletOutputStream
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(HttpOutput.class);
    private static final ThreadIdPool<CharsetEncoder> _encoder = new ThreadIdPool();
    private final ServletChannel _servletChannel;
    private final ServletChannelState _channelState;
    private final Blocker.Shared _writeBlocker;
    private ApiState _apiState = ApiState.BLOCKING;
    private State _state = State.OPEN;
    private boolean _softClose = false;
    private long _written;
    private long _flushed;
    private long _firstByteNanoTime = -1L;
    private ByteBufferPool _pool;
    private RetainableByteBuffer _aggregate;
    private int _bufferSize;
    private int _commitSize;
    private WriteListener _writeListener;
    private volatile Throwable _onError;
    private Callback _closedCallback;

    public HttpOutput(ServletChannel channel) {
        this._servletChannel = channel;
        this._channelState = this._servletChannel.getServletRequestState();
        this._writeBlocker = new Blocker.Shared();
        HttpConfiguration config = this._servletChannel.getHttpConfiguration();
        this._bufferSize = config.getOutputBufferSize();
        this._commitSize = config.getOutputAggregationSize();
        if (this._commitSize > this._bufferSize) {
            LOG.warn("OutputAggregationSize {} exceeds bufferSize {}", (Object)this._commitSize, (Object)this._bufferSize);
            this._commitSize = this._bufferSize;
        }
    }

    public boolean isWritten() {
        return this._written > 0L;
    }

    public long getWritten() {
        return this._written;
    }

    public void reopen() {
        try (AutoLock l = this._channelState.lock();){
            this._softClose = false;
        }
    }

    private void channelWrite(ByteBuffer content, boolean complete) throws IOException {
        try (Blocker.Callback blocker = this._writeBlocker.callback();){
            this.channelWrite(content, complete, blocker);
            blocker.block();
        }
    }

    private void channelWrite(ByteBuffer content, boolean last, Callback callback) {
        if (this._firstByteNanoTime == -1L) {
            long minDataRate = this._servletChannel.getConnectionMetaData().getHttpConfiguration().getMinResponseDataRate();
            this._firstByteNanoTime = minDataRate > 0L ? NanoTime.now() : Long.MAX_VALUE;
        }
        this._servletChannel.getResponse().write(last, content, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onWriteComplete(boolean last, Throwable failure) {
        String state = null;
        boolean wake = false;
        Callback closedCallback = null;
        ByteBuffer closeContent = null;
        try (AutoLock l = this._channelState.lock();){
            if (LOG.isDebugEnabled()) {
                state = this.stateString();
            }
            if (last || failure != null) {
                this._state = State.CLOSED;
                closedCallback = this._closedCallback;
                this._closedCallback = null;
                this.lockedReleaseBuffer(failure != null);
                wake = this.updateApiState(failure);
            } else if (this._state == State.CLOSE) {
                this._state = State.CLOSING;
                closeContent = this._aggregate != null && this._aggregate.hasRemaining() ? this._aggregate.getByteBuffer() : BufferUtil.EMPTY_BUFFER;
            } else {
                wake = this.updateApiState(null);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("onWriteComplete({},{}) {}->{} c={} cb={} w={}", last, failure, state, this.stateString(), BufferUtil.toDetailString(closeContent), closedCallback, wake, failure);
        }
        try {
            if (closedCallback != null) {
                if (failure == null) {
                    closedCallback.succeeded();
                } else {
                    closedCallback.failed(failure);
                }
            } else if (closeContent != null) {
                this.channelWrite(closeContent, true, new WriteCompleteCB());
            }
        }
        finally {
            if (wake) {
                this._servletChannel.execute(this._servletChannel::handle);
            }
        }
    }

    private boolean updateApiState(Throwable failure) {
        boolean wake = false;
        switch (this._apiState.ordinal()) {
            case 1: {
                this._apiState = ApiState.BLOCKING;
                break;
            }
            case 4: {
                this._apiState = ApiState.ASYNC;
                if (failure == null) break;
                this._onError = failure;
                wake = this._channelState.onWritePossible();
                break;
            }
            case 5: {
                this._apiState = ApiState.READY;
                if (failure != null) {
                    this._onError = failure;
                }
                wake = this._channelState.onWritePossible();
                break;
            }
            default: {
                if (this._state == State.CLOSED) break;
                throw new IllegalStateException(this.stateString());
            }
        }
        return wake;
    }

    private int maximizeAggregateSpace() {
        if (this._aggregate == null) {
            return this.getBufferSize();
        }
        ByteBuffer byteBuffer = this._aggregate.getByteBuffer();
        BufferUtil.compact(byteBuffer);
        return BufferUtil.space(byteBuffer);
    }

    public void softClose() {
        try (AutoLock l = this._channelState.lock();){
            this._softClose = true;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void complete(Callback callback) {
        block27: {
            succeeded = false;
            error /* !! */  = null;
            content = null;
            l = this._channelState.lock();
            try {
                switch (this._apiState.ordinal()) {
                    case 5: {
                        error /* !! */  = new CancellationException("Completed whilst write unready");
                        break;
                    }
                    case 4: {
                        if (!this._servletChannel.getServletContextResponse().isContentIncomplete(this._written)) break;
                        error /* !! */  = new CancellationException("Completed whilst write pending");
                        break;
                    }
                    case 1: {
                        error /* !! */  = new CancellationException("Completed whilst write blocked");
                        break;
                    }
                }
                if (error /* !! */  != null) {
                    this._servletChannel.abort(error /* !! */ );
                    this._state = State.CLOSED;
                    break block27;
                }
                switch (this._state.ordinal()) {
                    case 3: {
                        succeeded = true;
                        ** break;
lbl25:
                        // 1 sources

                        break;
                    }
                    case 1: 
                    case 2: {
                        this._closedCallback = Callback.combine(this._closedCallback, callback);
                        ** break;
lbl29:
                        // 1 sources

                        break;
                    }
                    case 0: {
                        if (this._onError != null) {
                            error /* !! */  = this._onError;
                            ** break;
lbl34:
                            // 1 sources

                            break;
                        }
                        this._closedCallback = Callback.combine(this._closedCallback, callback);
                        switch (this._apiState.ordinal()) {
                            case 0: {
                                this._apiState = ApiState.BLOCKED;
                                this._state = State.CLOSING;
                                content = this._aggregate != null && this._aggregate.hasRemaining() != false ? this._aggregate.getByteBuffer() : BufferUtil.EMPTY_BUFFER;
                                ** break;
lbl42:
                                // 1 sources

                                break block27;
                            }
                            case 2: 
                            case 3: {
                                this._apiState = ApiState.PENDING;
                                this._state = State.CLOSING;
                                content = this._aggregate != null && this._aggregate.hasRemaining() != false ? this._aggregate.getByteBuffer() : BufferUtil.EMPTY_BUFFER;
                                ** break;
lbl48:
                                // 1 sources

                                break block27;
                            }
                            case 4: 
                            case 5: {
                                this._softClose = true;
                                this._state = State.CLOSE;
                                ** break;
lbl53:
                                // 1 sources

                                break block27;
                            }
                        }
                        throw new IllegalStateException();
                    }
                    ** default:
lbl56:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (l != null) {
                    l.close();
                }
            }
        }
        if (HttpOutput.LOG.isDebugEnabled()) {
            HttpOutput.LOG.debug("complete({}) {} s={} e={}, c={}", new Object[]{callback, this.stateString(), succeeded, error /* !! */ , BufferUtil.toDetailString(content)});
        }
        if (succeeded) {
            callback.succeeded();
            return;
        }
        if (error /* !! */  != null) {
            callback.failed(error /* !! */ );
            return;
        }
        if (content != null) {
            this.channelWrite(content, true, new WriteCompleteCB());
        }
    }

    public void completed(Throwable failure) {
        try (AutoLock l = this._channelState.lock();){
            this._state = State.CLOSED;
            this.lockedReleaseBuffer(failure != null);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void close() throws IOException {
        block45: {
            content = null;
            blocker = null;
            l = this._channelState.lock();
            try {
                if (this._softClose) {
                    return;
                }
                if (this._onError != null) {
                    if (this._onError instanceof IOException) {
                        throw (IOException)this._onError;
                    }
                    if (this._onError instanceof RuntimeException) {
                        throw (RuntimeException)this._onError;
                    }
                    if (this._onError instanceof Error) {
                        throw (Error)this._onError;
                    }
                    throw new IOException(this._onError);
                }
                switch (this._state.ordinal()) {
                    case 3: {
                        ** break;
lbl18:
                        // 1 sources

                        break;
                    }
                    case 1: 
                    case 2: {
                        switch (this._apiState.ordinal()) {
                            case 0: 
                            case 1: {
                                blocker = this._writeBlocker.callback();
                                this._closedCallback = Callback.combine(this._closedCallback, blocker);
                                ** break;
lbl25:
                                // 1 sources

                                break block45;
                            }
                        }
                        ** break;
lbl27:
                        // 1 sources

                        break;
                    }
                    case 0: {
                        switch (this._apiState.ordinal()) {
                            case 0: {
                                this._apiState = ApiState.BLOCKED;
                                this._state = State.CLOSING;
                                blocker = this._writeBlocker.callback();
                                content = this._aggregate != null && this._aggregate.hasRemaining() != false ? this._aggregate.getByteBuffer() : BufferUtil.EMPTY_BUFFER;
                                ** break;
                            }
                            case 1: {
                                this._softClose = true;
                                this._state = State.CLOSE;
                                blocker = this._writeBlocker.callback();
                                this._closedCallback = Callback.combine(this._closedCallback, blocker);
                                ** break;
                            }
                            case 2: 
                            case 3: {
                                this._apiState = ApiState.PENDING;
                                this._state = State.CLOSING;
                                content = this._aggregate != null && this._aggregate.hasRemaining() != false ? this._aggregate.getByteBuffer() : BufferUtil.EMPTY_BUFFER;
                                ** break;
                            }
                            case 4: 
                            case 5: {
                                this._softClose = true;
                                this._state = State.CLOSE;
                            }
lbl50:
                            // 5 sources

                            ** default:
lbl51:
                            // 1 sources

                            break block45;
                        }
                    }
                    ** default:
lbl53:
                    // 1 sources

                    break;
                }
            }
            finally {
                if (l != null) {
                    l.close();
                }
            }
        }
        if (HttpOutput.LOG.isDebugEnabled()) {
            HttpOutput.LOG.debug("close() {} c={} b={}", new Object[]{this.stateString(), BufferUtil.toDetailString(content), blocker});
        }
        if (content == null) {
            if (blocker == null) {
                return;
            }
            cb = blocker;
            try {
                cb.block();
            }
            finally {
                if (cb != null) {
                    cb.close();
                }
            }
        }
        if (blocker == null) {
            this.channelWrite(content, true, new WriteCompleteCB());
        } else {
            try {
                b = blocker;
                try {
                    this.channelWrite(content, true, blocker);
                    b.block();
                    this.onWriteComplete(true, null);
                }
                finally {
                    if (b != null) {
                        b.close();
                    }
                }
            }
            catch (Throwable t) {
                this.onWriteComplete(true, t);
                throw t;
            }
        }
    }

    public ByteBuffer getByteBuffer() {
        try (AutoLock l = this._channelState.lock();){
            ByteBuffer byteBuffer = this.lockedAcquireBuffer().getByteBuffer();
            return byteBuffer;
        }
    }

    private RetainableByteBuffer lockedAcquireBuffer() {
        assert (this._channelState.isLockHeldByCurrentThread());
        boolean useOutputDirectByteBuffers = this._servletChannel.getConnectionMetaData().getHttpConfiguration().isUseOutputDirectByteBuffers();
        if (this._aggregate == null) {
            this._pool = this._servletChannel.getRequest().getComponents().getByteBufferPool();
            this._aggregate = this._pool.acquire(this.getBufferSize(), useOutputDirectByteBuffers);
        }
        return this._aggregate;
    }

    private void lockedReleaseBuffer(boolean failure) {
        assert (this._channelState.isLockHeldByCurrentThread());
        if (this._aggregate != null) {
            if (failure && this._pool != null) {
                this._pool.removeAndRelease(this._aggregate);
            } else {
                this._aggregate.release();
            }
            this._aggregate = null;
            this._pool = null;
        }
    }

    public boolean isClosed() {
        try (AutoLock l = this._channelState.lock();){
            boolean bl = this._softClose || this._state != State.OPEN;
            return bl;
        }
    }

    public boolean isAsync() {
        try (AutoLock l = this._channelState.lock();){
            switch (this._apiState.ordinal()) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void flush() throws IOException {
        content = null;
        l = this._channelState.lock();
        try {
            switch (this._state.ordinal()) {
                case 2: 
                case 3: {
                    return;
                }
            }
            switch (this._apiState.ordinal()) {
                case 0: {
                    this._apiState = ApiState.BLOCKED;
                    content = this._aggregate != null && this._aggregate.hasRemaining() != false ? this._aggregate.getByteBuffer() : BufferUtil.EMPTY_BUFFER;
                    ** break;
lbl12:
                    // 1 sources

                    break;
                }
                case 2: 
                case 4: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case 3: {
                    this._apiState = ApiState.PENDING;
                    ** break;
lbl18:
                    // 1 sources

                    break;
                }
                case 5: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
        }
        finally {
            if (l != null) {
                l.close();
            }
        }
        if (content == null) {
            new AsyncFlush(false).iterate();
        } else {
            try {
                this.channelWrite(content, false);
                this.onWriteComplete(false, null);
            }
            catch (Throwable t) {
                this.onWriteComplete(false, t);
                if (t instanceof IOException) {
                    throw t;
                }
                throw new IOException(t);
            }
        }
    }

    private void checkWritable() throws EofException {
        if (this._softClose) {
            throw new EofException("Closed");
        }
        switch (this._state.ordinal()) {
            case 2: 
            case 3: {
                throw new EofException("Closed");
            }
        }
        if (this._onError != null) {
            throw new EofException(this._onError);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        boolean async;
        boolean aggregate;
        boolean last;
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(array {})", (Object)BufferUtil.toDetailString(ByteBuffer.wrap(b, off, len)));
        }
        try (AutoLock l = this._channelState.lock();){
            boolean flush;
            this.checkWritable();
            long written = this._written + (long)len;
            int space = this.maximizeAggregateSpace();
            last = this._servletChannel.getServletContextResponse().isAllContentWritten(written);
            aggregate = len <= this._commitSize && (!last || this._aggregate != null && this._aggregate.hasRemaining() && len <= space);
            boolean bl = flush = last || !aggregate || len >= space;
            if (last && this._state == State.OPEN) {
                this._state = State.CLOSING;
            }
            switch (this._apiState.ordinal()) {
                case 0: {
                    this._apiState = flush ? ApiState.BLOCKED : ApiState.BLOCKING;
                    async = false;
                    break;
                }
                case 2: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case 3: {
                    async = true;
                    this._apiState = flush ? ApiState.PENDING : ApiState.ASYNC;
                    break;
                }
                case 4: 
                case 5: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
            this._written = written;
            if (aggregate) {
                this.lockedAcquireBuffer();
                int filled = BufferUtil.fill(this._aggregate.getByteBuffer(), b, off, len);
                if (!flush) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("write(array) {} aggregated !flush {}", (Object)this.stateString(), (Object)this._aggregate);
                    }
                    return;
                }
                off += filled;
                len -= filled;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("write(array) {} last={} agg={} flush=true async={}, len={} {}", this.stateString(), last, aggregate, async, len, this._aggregate);
        }
        if (async) {
            new AsyncWrite(b, off, len, last).iterate();
            return;
        }
        try {
            boolean complete = false;
            if (this._aggregate != null && this._aggregate.hasRemaining()) {
                ByteBuffer byteBuffer = this._aggregate.getByteBuffer();
                complete = last && len == 0;
                this.channelWrite(byteBuffer, complete);
                if (len > 0 && !last && len <= this._commitSize && len <= this.maximizeAggregateSpace()) {
                    BufferUtil.append(byteBuffer, b, off, len);
                    this.onWriteComplete(false, null);
                    return;
                }
            }
            if (len > 0) {
                ByteBuffer view = ByteBuffer.wrap(b, off, len);
                while (len > this.getBufferSize()) {
                    int p = view.position();
                    int l = p + this.getBufferSize();
                    view.limit(l);
                    this.channelWrite(view, false);
                    view.limit(p + len);
                    view.position(l);
                    len -= this.getBufferSize();
                }
                this.channelWrite(view, last);
            } else if (last && !complete) {
                this.channelWrite(BufferUtil.EMPTY_BUFFER, true);
            }
            this.onWriteComplete(last, null);
        }
        catch (Throwable t) {
            this.onWriteComplete(last, t);
            throw t;
        }
    }

    @Override
    public void write(ByteBuffer buffer) throws IOException {
        boolean async;
        boolean flush;
        boolean last;
        int len = BufferUtil.length(buffer);
        try (AutoLock l = this._channelState.lock();){
            this.checkWritable();
            long written = this._written + (long)len;
            last = this._servletChannel.getServletContextResponse().isAllContentWritten(written);
            boolean bl = flush = last || len > 0 || this._aggregate != null && this._aggregate.hasRemaining();
            if (last && this._state == State.OPEN) {
                this._state = State.CLOSING;
            }
            switch (this._apiState.ordinal()) {
                case 0: {
                    async = false;
                    this._apiState = flush ? ApiState.BLOCKED : ApiState.BLOCKING;
                    break;
                }
                case 2: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case 3: {
                    async = true;
                    this._apiState = flush ? ApiState.PENDING : ApiState.ASYNC;
                    break;
                }
                case 4: 
                case 5: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
            this._written = written;
        }
        if (!flush) {
            return;
        }
        if (async) {
            new AsyncWrite(buffer, last).iterate();
        } else {
            try {
                boolean complete = false;
                if (this._aggregate != null && this._aggregate.hasRemaining()) {
                    complete = last && len == 0;
                    this.channelWrite(this._aggregate.getByteBuffer(), complete);
                }
                if (len > 0) {
                    this.channelWrite(buffer, last);
                } else if (last && !complete) {
                    this.channelWrite(BufferUtil.EMPTY_BUFFER, true);
                }
                this.onWriteComplete(last, null);
            }
            catch (Throwable t) {
                this.onWriteComplete(last, t);
                throw t;
            }
        }
    }

    @Override
    public void write(int b) throws IOException {
        boolean flush;
        boolean last;
        boolean async = false;
        try (AutoLock l = this._channelState.lock();){
            this.checkWritable();
            long written = this._written + 1L;
            int space = this.maximizeAggregateSpace();
            last = this._servletChannel.getServletContextResponse().isAllContentWritten(written);
            boolean bl = flush = last || space == 1;
            if (last && this._state == State.OPEN) {
                this._state = State.CLOSING;
            }
            switch (this._apiState.ordinal()) {
                case 0: {
                    this._apiState = flush ? ApiState.BLOCKED : ApiState.BLOCKING;
                    break;
                }
                case 2: {
                    throw new IllegalStateException("isReady() not called: " + this.stateString());
                }
                case 3: {
                    async = true;
                    this._apiState = flush ? ApiState.PENDING : ApiState.ASYNC;
                    break;
                }
                case 4: 
                case 5: {
                    throw new WritePendingException();
                }
                default: {
                    throw new IllegalStateException(this.stateString());
                }
            }
            this._written = written;
            this.lockedAcquireBuffer();
            BufferUtil.append(this._aggregate.getByteBuffer(), (byte)b);
        }
        if (!flush) {
            return;
        }
        if (async) {
            new AsyncFlush(last).iterate();
        } else {
            try {
                this.channelWrite(this._aggregate.getByteBuffer(), last);
                this.onWriteComplete(last, null);
            }
            catch (Throwable t) {
                this.onWriteComplete(last, t);
                throw t;
            }
        }
    }

    @Override
    public void print(String s) throws IOException {
        this.print(s, false);
    }

    @Override
    public void println(String s) throws IOException {
        this.print(s, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void print(String s, boolean eoln) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
        s = String.valueOf(s);
        String charset = this._servletChannel.getServletContextResponse().getCharacterEncoding(false);
        CharsetEncoder encoder = _encoder.take();
        if (encoder == null || !encoder.charset().name().equalsIgnoreCase(charset)) {
            encoder = Charset.forName(charset).newEncoder();
            encoder.onMalformedInput(CodingErrorAction.REPLACE);
            encoder.onUnmappableCharacter(CodingErrorAction.REPLACE);
        }
        ByteBufferPool pool = this._servletChannel.getRequest().getComponents().getByteBufferPool();
        RetainableByteBuffer out = pool.acquire((int)(1.0f + (float)(s.length() + 2) * encoder.averageBytesPerChar()), false);
        try {
            CharBuffer in = CharBuffer.wrap(s);
            CharBuffer crlf = eoln ? CharBuffer.wrap("\r\n") : null;
            ByteBuffer byteBuffer = out.getByteBuffer();
            BufferUtil.flipToFill(byteBuffer);
            while (true) {
                CoderResult result;
                if (in.hasRemaining()) {
                    result = encoder.encode(in, byteBuffer, crlf == null);
                    if (result.isUnderflow()) {
                        if (crlf != null) continue;
                        break;
                    }
                } else {
                    if (crlf == null || !crlf.hasRemaining()) break;
                    result = encoder.encode(crlf, byteBuffer, true);
                    if (result.isUnderflow()) {
                        if (encoder.flush(byteBuffer).isUnderflow()) break;
                        result.throwException();
                        break;
                    }
                }
                if (result.isOverflow()) {
                    BufferUtil.flipToFlush(byteBuffer, 0);
                    RetainableByteBuffer bigger = pool.acquire(out.capacity() + s.length() + 2, out.isDirect());
                    BufferUtil.flipToFill(bigger.getByteBuffer());
                    bigger.getByteBuffer().put(byteBuffer);
                    out.release();
                    BufferUtil.flipToFill(bigger.getByteBuffer());
                    out = bigger;
                    byteBuffer = bigger.getByteBuffer();
                    continue;
                }
                result.throwException();
            }
            BufferUtil.flipToFlush(byteBuffer, 0);
            this.write(byteBuffer.array(), byteBuffer.arrayOffset(), byteBuffer.remaining());
        }
        finally {
            out.release();
            encoder.reset();
            _encoder.offer(encoder);
        }
    }

    public void sendContent(ByteBuffer content) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent({})", (Object)BufferUtil.toDetailString(content));
        }
        this._written += (long)content.remaining();
        this.channelWrite(content, true);
    }

    public void sendContent(InputStream in) throws IOException {
        try (Blocker.Callback blocker = this._writeBlocker.callback();){
            new InputStreamWritingCB(in, blocker).iterate();
            blocker.block();
        }
    }

    public void sendContent(ReadableByteChannel in) throws IOException {
        try (Blocker.Callback blocker = this._writeBlocker.callback();){
            new ReadableByteChannelWritingCB(in, blocker).iterate();
            blocker.block();
        }
    }

    public void sendContent(ByteBuffer content, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(buffer={},{})", (Object)BufferUtil.toDetailString(content), (Object)callback);
        }
        if (this.prepareSendContent(content.remaining(), callback)) {
            this.channelWrite(content, true, new Callback.Nested(callback){

                @Override
                public void succeeded() {
                    HttpOutput.this.onWriteComplete(true, null);
                    super.succeeded();
                }

                @Override
                public void failed(Throwable x) {
                    HttpOutput.this.onWriteComplete(true, x);
                    super.failed(x);
                }
            });
        }
    }

    public void sendContent(InputStream in, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(stream={},{})", (Object)in, (Object)callback);
        }
        if (this.prepareSendContent(0, callback)) {
            new InputStreamWritingCB(in, callback).iterate();
        }
    }

    public void sendContent(ReadableByteChannel in, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("sendContent(channel={},{})", (Object)in, (Object)callback);
        }
        if (this.prepareSendContent(0, callback)) {
            new ReadableByteChannelWritingCB(in, callback).iterate();
        }
    }

    private boolean prepareSendContent(int len, Callback callback) {
        try (AutoLock l = this._channelState.lock();){
            if (this._aggregate != null && this._aggregate.hasRemaining()) {
                callback.failed(new IOException("cannot sendContent() after write()"));
                boolean bl = false;
                return bl;
            }
            if (this._servletChannel.isCommitted()) {
                callback.failed(new IOException("cannot sendContent(), output already committed"));
                boolean bl = false;
                return bl;
            }
            switch (this._state.ordinal()) {
                case 2: 
                case 3: {
                    callback.failed(new EofException("Closed"));
                    boolean bl = false;
                    return bl;
                }
            }
            this._state = State.CLOSING;
            if (this._onError != null) {
                callback.failed(this._onError);
                boolean bl = false;
                return bl;
            }
            if (this._apiState != ApiState.BLOCKING) {
                throw new IllegalStateException(this.stateString());
            }
            this._apiState = ApiState.PENDING;
            if (len > 0) {
                this._written += (long)len;
            }
            boolean bl = true;
            return bl;
        }
    }

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int size) {
        this._bufferSize = size;
        this._commitSize = size;
    }

    public void onFlushed(long bytes) throws IOException {
        if (this._firstByteNanoTime == -1L || this._firstByteNanoTime == Long.MAX_VALUE) {
            return;
        }
        long minDataRate = this._servletChannel.getConnectionMetaData().getHttpConfiguration().getMinResponseDataRate();
        this._flushed += bytes;
        long minFlushed = minDataRate * NanoTime.millisSince(this._firstByteNanoTime) / TimeUnit.SECONDS.toMillis(1L);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Flushed bytes min/actual {}/{}", (Object)minFlushed, (Object)this._flushed);
        }
        if (this._flushed < minFlushed) {
            IOException ioe = new IOException(String.format("Response content data rate < %d B/s", minDataRate));
            this._servletChannel.abort(ioe);
            throw ioe;
        }
    }

    public void recycle() {
        try (AutoLock l = this._channelState.lock();){
            this.lockedReleaseBuffer(this._state != State.CLOSED);
            this._state = State.OPEN;
            this._apiState = ApiState.BLOCKING;
            this._softClose = true;
            HttpConfiguration config = this._servletChannel.getConnectionMetaData().getHttpConfiguration();
            this._bufferSize = config.getOutputBufferSize();
            this._commitSize = config.getOutputAggregationSize();
            if (this._commitSize > this._bufferSize) {
                this._commitSize = this._bufferSize;
            }
            this._written = 0L;
            this._writeListener = null;
            this._onError = null;
            this._firstByteNanoTime = -1L;
            this._flushed = 0L;
            this._closedCallback = null;
        }
    }

    public void resetBuffer() {
        try (AutoLock l = this._channelState.lock();){
            if (this._aggregate != null) {
                this._aggregate.clear();
            }
            this._written = 0L;
        }
    }

    @Override
    public void setWriteListener(WriteListener writeListener) {
        boolean wake;
        if (!this._servletChannel.getServletRequestState().isAsync()) {
            throw new IllegalStateException("!ASYNC: " + this.stateString());
        }
        try (AutoLock l = this._channelState.lock();){
            if (this._apiState != ApiState.BLOCKING) {
                throw new IllegalStateException("!OPEN" + this.stateString());
            }
            this._apiState = ApiState.READY;
            this._writeListener = writeListener;
            wake = this._servletChannel.getServletRequestState().onWritePossible();
        }
        if (wake) {
            this._servletChannel.execute(this._servletChannel::handle);
        }
    }

    @Override
    public boolean isReady() {
        try (AutoLock l = this._channelState.lock();){
            switch (this._apiState.ordinal()) {
                case 0: 
                case 3: {
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    this._apiState = ApiState.READY;
                    boolean bl = true;
                    return bl;
                }
                case 4: {
                    this._apiState = ApiState.UNREADY;
                    boolean bl = false;
                    return bl;
                }
                case 1: 
                case 5: {
                    boolean bl = false;
                    return bl;
                }
            }
            throw new IllegalStateException(this.stateString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable error = null;
        try (AutoLock l = this._channelState.lock();){
            if (this._onError != null) {
                error = this._onError;
                this._onError = null;
            }
        }
        try {
            if (error == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onWritePossible");
                }
                this._writeListener.onWritePossible();
                return;
            }
        }
        catch (Throwable t) {
            error = t;
        }
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("onError", error);
            }
            this._writeListener.onError(error);
        }
        catch (Throwable t) {
            if (LOG.isDebugEnabled()) {
                t.addSuppressed(error);
                LOG.debug("Failed in call onError on {}", (Object)this._writeListener, (Object)t);
            }
        }
        finally {
            IO.close(this);
        }
    }

    private String stateString() {
        return String.format("s=%s,api=%s,sc=%b,e=%s", new Object[]{this._state, this._apiState, this._softClose, this._onError});
    }

    public String toString() {
        try (AutoLock l = this._channelState.lock();){
            String string = String.format("%s@%x{%s}", this.getClass().getSimpleName(), this.hashCode(), this.stateString());
            return string;
        }
    }

    static enum ApiState {
        BLOCKING,
        BLOCKED,
        ASYNC,
        READY,
        PENDING,
        UNREADY;

    }

    static enum State {
        OPEN,
        CLOSE,
        CLOSING,
        CLOSED;

    }

    private class WriteCompleteCB
    implements Callback {
        private WriteCompleteCB() {
        }

        @Override
        public void succeeded() {
            HttpOutput.this.onWriteComplete(true, null);
        }

        @Override
        public void failed(Throwable x) {
            HttpOutput.this.onWriteComplete(true, x);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }
    }

    private class AsyncFlush
    extends ChannelWriteCB {
        private volatile boolean _flushed;

        private AsyncFlush(boolean last) {
            super(last);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (HttpOutput.this._aggregate != null && HttpOutput.this._aggregate.hasRemaining()) {
                this._flushed = true;
                HttpOutput.this.channelWrite(HttpOutput.this._aggregate.getByteBuffer(), false, this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._flushed) {
                this._flushed = true;
                HttpOutput.this.channelWrite(BufferUtil.EMPTY_BUFFER, false, this);
                return IteratingCallback.Action.SCHEDULED;
            }
            return IteratingCallback.Action.SUCCEEDED;
        }
    }

    private class AsyncWrite
    extends ChannelWriteCB {
        private final ByteBuffer _buffer;
        private final ByteBuffer _slice;
        private final int _len;
        private boolean _completed;

        private AsyncWrite(byte[] b, int off, int len, boolean last) {
            super(last);
            this._buffer = ByteBuffer.wrap(b, off, len);
            this._len = len;
            this._slice = this._len < HttpOutput.this.getBufferSize() ? null : this._buffer.duplicate();
        }

        private AsyncWrite(ByteBuffer buffer, boolean last) {
            super(last);
            this._buffer = buffer;
            this._len = buffer.remaining();
            this._slice = this._buffer.isDirect() || this._len < HttpOutput.this.getBufferSize() ? null : this._buffer.duplicate();
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (HttpOutput.this._aggregate != null && HttpOutput.this._aggregate.hasRemaining()) {
                this._completed = this._len == 0;
                HttpOutput.this.channelWrite(HttpOutput.this._aggregate.getByteBuffer(), this._last && this._completed, this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (!this._last && HttpOutput.this._aggregate != null && this._len < HttpOutput.this.maximizeAggregateSpace() && this._len < HttpOutput.this._commitSize) {
                ByteBuffer byteBuffer = HttpOutput.this._aggregate.getByteBuffer();
                int position = BufferUtil.flipToFill(byteBuffer);
                BufferUtil.put(this._buffer, byteBuffer);
                BufferUtil.flipToFlush(byteBuffer, position);
                return IteratingCallback.Action.SUCCEEDED;
            }
            if (this._buffer.hasRemaining()) {
                if (this._slice == null) {
                    this._completed = true;
                    HttpOutput.this.channelWrite(this._buffer, this._last, this);
                    return IteratingCallback.Action.SCHEDULED;
                }
                int p = this._buffer.position();
                int l = Math.min(HttpOutput.this.getBufferSize(), this._buffer.remaining());
                int pl = p + l;
                this._slice.limit(pl);
                this._buffer.position(pl);
                this._slice.position(p);
                this._completed = !this._buffer.hasRemaining();
                HttpOutput.this.channelWrite(this._slice, this._last && this._completed, this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (this._last && !this._completed) {
                this._completed = true;
                HttpOutput.this.channelWrite(BufferUtil.EMPTY_BUFFER, true, this);
                return IteratingCallback.Action.SCHEDULED;
            }
            if (LOG.isDebugEnabled() && this._completed) {
                LOG.debug("EOF of {}", (Object)this);
            }
            return IteratingCallback.Action.SUCCEEDED;
        }
    }

    private class InputStreamWritingCB
    extends NestedChannelWriteCB {
        private final InputStream _in;
        private final RetainableByteBuffer _buffer;
        private boolean _eof;
        private boolean _closed;

        private InputStreamWritingCB(InputStream in, Callback callback) {
            super(callback, true);
            this._in = in;
            ByteBufferPool pool = HttpOutput.this._servletChannel.getRequest().getComponents().getByteBufferPool();
            this._buffer = pool.acquire(HttpOutput.this.getBufferSize(), false);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this._eof) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EOF of {}", (Object)this);
                }
                if (!this._closed) {
                    this._closed = true;
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            ByteBuffer byteBuffer = this._buffer.getByteBuffer();
            int len = 0;
            while (len < byteBuffer.capacity() && !this._eof) {
                int r = this._in.read(byteBuffer.array(), byteBuffer.arrayOffset() + len, byteBuffer.capacity() - len);
                if (r < 0) {
                    this._eof = true;
                    continue;
                }
                len += r;
            }
            byteBuffer.position(0);
            byteBuffer.limit(len);
            HttpOutput.this._written += (long)len;
            HttpOutput.this.channelWrite(byteBuffer, this._eof, this);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onCompleteSuccess() {
            this._buffer.release();
            IO.close(this._in);
            super.onCompleteSuccess();
        }

        @Override
        public void onCompleteFailure(Throwable x) {
            this._buffer.release();
            IO.close(this._in);
            super.onCompleteFailure(x);
        }
    }

    private class ReadableByteChannelWritingCB
    extends NestedChannelWriteCB {
        private final ReadableByteChannel _in;
        private final RetainableByteBuffer _buffer;
        private boolean _eof;
        private boolean _closed;

        private ReadableByteChannelWritingCB(ReadableByteChannel in, Callback callback) {
            super(callback, true);
            this._in = in;
            boolean useOutputDirectByteBuffers = HttpOutput.this._servletChannel.getConnectionMetaData().getHttpConfiguration().isUseOutputDirectByteBuffers();
            ByteBufferPool pool = HttpOutput.this._servletChannel.getRequest().getComponents().getByteBufferPool();
            this._buffer = pool.acquire(HttpOutput.this.getBufferSize(), useOutputDirectByteBuffers);
        }

        @Override
        protected IteratingCallback.Action process() throws Exception {
            if (this._eof) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("EOF of {}", (Object)this);
                }
                if (!this._closed) {
                    this._closed = true;
                }
                return IteratingCallback.Action.SUCCEEDED;
            }
            ByteBuffer byteBuffer = this._buffer.getByteBuffer();
            BufferUtil.clearToFill(byteBuffer);
            while (byteBuffer.hasRemaining() && !this._eof) {
                this._eof = this._in.read(byteBuffer) < 0;
            }
            BufferUtil.flipToFlush(byteBuffer, 0);
            HttpOutput.this._written += (long)byteBuffer.remaining();
            HttpOutput.this.channelWrite(byteBuffer, this._eof, this);
            return IteratingCallback.Action.SCHEDULED;
        }

        @Override
        protected void onCompleteSuccess() {
            this._buffer.release();
            IO.close(this._in);
            super.onCompleteSuccess();
        }

        @Override
        public void onCompleteFailure(Throwable x) {
            this._buffer.release();
            IO.close(this._in);
            super.onCompleteFailure(x);
        }
    }

    private abstract class NestedChannelWriteCB
    extends ChannelWriteCB {
        private final Callback _callback;

        private NestedChannelWriteCB(Callback callback, boolean last) {
            super(last);
            this._callback = callback;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }

        @Override
        protected void onCompleteSuccess() {
            try {
                super.onCompleteSuccess();
            }
            finally {
                this._callback.succeeded();
            }
        }

        @Override
        public void onCompleteFailure(Throwable e2) {
            try {
                super.onCompleteFailure(e2);
            }
            catch (Throwable t) {
                ExceptionUtil.addSuppressedIfNotAssociated(e2, t);
            }
            finally {
                this._callback.failed(e2);
            }
        }
    }

    private abstract class ChannelWriteCB
    extends IteratingCallback {
        final boolean _last;

        private ChannelWriteCB(boolean last) {
            this._last = last;
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.InvocationType.NON_BLOCKING;
        }

        @Override
        protected void onCompleteSuccess() {
            HttpOutput.this.onWriteComplete(this._last, null);
        }

        @Override
        public void onCompleteFailure(Throwable e2) {
            HttpOutput.this.onWriteComplete(this._last, e2);
        }
    }
}

