/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.crypto.hash;

import java.security.SecureRandom;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Random;
import org.apache.shiro.crypto.hash.ConfigurableHashService;
import org.apache.shiro.crypto.hash.Hash;
import org.apache.shiro.crypto.hash.HashProvider;
import org.apache.shiro.crypto.hash.HashRequest;
import org.apache.shiro.crypto.hash.HashSpi;

public class DefaultHashService
implements ConfigurableHashService {
    private final Random random = new SecureRandom();
    private String defaultAlgorithmName = "argon2";

    @Override
    public Hash computeHash(HashRequest request) {
        if (request == null || request.getSource() == null || request.getSource().isEmpty()) {
            return null;
        }
        String algorithmName = this.getAlgorithmName(request);
        Optional<HashSpi> kdfHash = HashProvider.getByAlgorithmName(algorithmName);
        if (kdfHash.isPresent()) {
            HashSpi hashSpi = kdfHash.orElseThrow(NoSuchElementException::new);
            return hashSpi.newHashFactory(this.random).generate(request);
        }
        throw new UnsupportedOperationException("Cannot create a hash with the given algorithm: " + algorithmName);
    }

    protected String getAlgorithmName(HashRequest request) {
        return request.getAlgorithmName().orElseGet(this::getDefaultAlgorithmName);
    }

    @Override
    public void setDefaultAlgorithmName(String name) {
        this.defaultAlgorithmName = name;
    }

    @Override
    public String getDefaultAlgorithmName() {
        return this.defaultAlgorithmName;
    }
}

