/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene92;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.backward_codecs.lucene92.Lucene92HnswVectorsFormat;
import org.apache.lucene.backward_codecs.lucene92.OffHeapFloatVectorValues;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.KnnVectorsReader;
import org.apache.lucene.codecs.hnsw.DefaultFlatVectorScorer;
import org.apache.lucene.index.ByteVectorValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.FloatVectorValues;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.search.KnnCollector;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.hnsw.HnswGraph;
import org.apache.lucene.util.hnsw.HnswGraphSearcher;
import org.apache.lucene.util.hnsw.OrdinalTranslatedKnnCollector;
import org.apache.lucene.util.hnsw.RandomAccessVectorValues;
import org.apache.lucene.util.hnsw.RandomVectorScorer;
import org.apache.lucene.util.packed.DirectMonotonicReader;

public final class Lucene92HnswVectorsReader
extends KnnVectorsReader {
    private final Map<String, FieldEntry> fields = new HashMap<String, FieldEntry>();
    private final IndexInput vectorData;
    private final IndexInput vectorIndex;
    private final DefaultFlatVectorScorer defaultFlatVectorScorer = new DefaultFlatVectorScorer();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Lucene92HnswVectorsReader(SegmentReadState state) throws IOException {
        int versionMeta = this.readMetadata(state);
        boolean success = false;
        try {
            this.vectorData = Lucene92HnswVectorsReader.openDataInput(state, versionMeta, "vec", "lucene92HnswVectorsFormatData");
            this.vectorIndex = Lucene92HnswVectorsReader.openDataInput(state, versionMeta, "vex", "lucene92HnswVectorsFormatIndex");
            return;
        }
        catch (Throwable throwable) {
            if (success) throw throwable;
            IOUtils.closeWhileHandlingException(this);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readMetadata(SegmentReadState state) throws IOException {
        int versionMeta;
        block11: {
            String metaFileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, "vem");
            versionMeta = -1;
            try (ChecksumIndexInput meta = state.directory.openChecksumInput(metaFileName, state.context);){
                Throwable priorE = null;
                try {
                    versionMeta = CodecUtil.checkIndexHeader(meta, "lucene92HnswVectorsFormatMeta", 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                    this.readFields(meta, state.fieldInfos);
                }
                catch (Throwable exception) {
                    try {
                        priorE = exception;
                        break block11;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        CodecUtil.checkFooter(meta, priorE);
                    }
                }
                CodecUtil.checkFooter(meta, priorE);
            }
        }
        return versionMeta;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IndexInput openDataInput(SegmentReadState state, int versionMeta, String fileExtension, String codecName) throws IOException {
        IndexInput indexInput;
        block4: {
            String fileName = IndexFileNames.segmentFileName(state.segmentInfo.name, state.segmentSuffix, fileExtension);
            IndexInput in = state.directory.openInput(fileName, state.context);
            boolean success = false;
            try {
                int versionVectorData = CodecUtil.checkIndexHeader(in, codecName, 0, 0, state.segmentInfo.getId(), state.segmentSuffix);
                if (versionMeta != versionVectorData) {
                    throw new CorruptIndexException("Format versions mismatch: meta=" + versionMeta + ", " + codecName + "=" + versionVectorData, in);
                }
                CodecUtil.retrieveChecksum(in);
                success = true;
                indexInput = in;
                if (success) break block4;
            }
            catch (Throwable throwable) {
                if (!success) {
                    IOUtils.closeWhileHandlingException(in);
                }
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(in);
        }
        return indexInput;
    }

    private void readFields(ChecksumIndexInput meta, FieldInfos infos) throws IOException {
        int fieldNumber = meta.readInt();
        while (fieldNumber != -1) {
            FieldInfo info = infos.fieldInfo(fieldNumber);
            if (info == null) {
                throw new CorruptIndexException("Invalid field number: " + fieldNumber, meta);
            }
            FieldEntry fieldEntry = this.readField(meta, info);
            this.validateFieldEntry(info, fieldEntry);
            this.fields.put(info.name, fieldEntry);
            fieldNumber = meta.readInt();
        }
    }

    private void validateFieldEntry(FieldInfo info, FieldEntry fieldEntry) {
        int dimension = info.getVectorDimension();
        if (dimension != fieldEntry.dimension) {
            throw new IllegalStateException("Inconsistent vector dimension for field=\"" + info.name + "\"; " + dimension + " != " + fieldEntry.dimension);
        }
        long numBytes = (long)fieldEntry.size() * (long)dimension * 4L;
        if (numBytes != fieldEntry.vectorDataLength) {
            throw new IllegalStateException("Vector data length " + fieldEntry.vectorDataLength + " not matching size=" + fieldEntry.size() + " * dim=" + dimension + " * 4 = " + numBytes);
        }
    }

    private VectorSimilarityFunction readSimilarityFunction(DataInput input) throws IOException {
        int similarityFunctionId = input.readInt();
        if (similarityFunctionId < 0 || similarityFunctionId >= VectorSimilarityFunction.values().length) {
            throw new CorruptIndexException("Invalid similarity function id: " + similarityFunctionId, input);
        }
        return VectorSimilarityFunction.values()[similarityFunctionId];
    }

    private FieldEntry readField(IndexInput input, FieldInfo info) throws IOException {
        VectorSimilarityFunction similarityFunction = this.readSimilarityFunction(input);
        if (similarityFunction != info.getVectorSimilarityFunction()) {
            throw new IllegalStateException("Inconsistent vector similarity function for field=\"" + info.name + "\"; " + similarityFunction + " != " + info.getVectorSimilarityFunction());
        }
        return new FieldEntry(input, info.getVectorSimilarityFunction());
    }

    @Override
    public long ramBytesUsed() {
        long totalBytes = RamUsageEstimator.shallowSizeOfInstance(Lucene92HnswVectorsFormat.class);
        return totalBytes += RamUsageEstimator.sizeOfMap(this.fields, RamUsageEstimator.shallowSizeOfInstance(FieldEntry.class));
    }

    @Override
    public void checkIntegrity() throws IOException {
        CodecUtil.checksumEntireFile(this.vectorData);
        CodecUtil.checksumEntireFile(this.vectorIndex);
    }

    @Override
    public FloatVectorValues getFloatVectorValues(String field) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        return OffHeapFloatVectorValues.load(fieldEntry, this.vectorData);
    }

    @Override
    public ByteVectorValues getByteVectorValues(String field) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void search(String field, float[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        FieldEntry fieldEntry = this.fields.get(field);
        if (fieldEntry.size() == 0) {
            return;
        }
        OffHeapFloatVectorValues vectorValues = OffHeapFloatVectorValues.load(fieldEntry, this.vectorData);
        RandomVectorScorer scorer = this.defaultFlatVectorScorer.getRandomVectorScorer(fieldEntry.similarityFunction, (RandomAccessVectorValues)vectorValues, target);
        HnswGraphSearcher.search(scorer, new OrdinalTranslatedKnnCollector(knnCollector, vectorValues::ordToDoc), this.getGraph(fieldEntry), vectorValues.getAcceptOrds(acceptDocs));
    }

    @Override
    public void search(String field, byte[] target, KnnCollector knnCollector, Bits acceptDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    private HnswGraph getGraph(FieldEntry entry) throws IOException {
        IndexInput bytesSlice = this.vectorIndex.slice("graph-data", entry.vectorIndexOffset, entry.vectorIndexLength);
        return new OffHeapHnswGraph(entry, bytesSlice);
    }

    @Override
    public void close() throws IOException {
        IOUtils.close(this.vectorData, this.vectorIndex);
    }

    private static final class OffHeapHnswGraph
    extends HnswGraph {
        final IndexInput dataIn;
        final int[][] nodesByLevel;
        final long[] graphOffsetsByLevel;
        final int numLevels;
        final int entryNode;
        final int size;
        final long bytesForConns;
        final long bytesForConns0;
        int arcCount;
        int arcUpTo;
        int arc;

        OffHeapHnswGraph(FieldEntry entry, IndexInput dataIn) {
            this.dataIn = dataIn;
            this.nodesByLevel = entry.nodesByLevel;
            this.numLevels = entry.numLevels;
            this.entryNode = this.numLevels > 1 ? this.nodesByLevel[this.numLevels - 1][0] : 0;
            this.size = entry.size();
            this.graphOffsetsByLevel = entry.graphOffsetsByLevel;
            this.bytesForConns = Math.multiplyExact(Math.addExact((long)entry.M, 1L), 4);
            this.bytesForConns0 = Math.multiplyExact(Math.addExact(Math.multiplyExact((long)entry.M, 2L), 1L), 4);
        }

        @Override
        public void seek(int level, int targetOrd) throws IOException {
            int targetIndex;
            int n = targetIndex = level == 0 ? targetOrd : Arrays.binarySearch(this.nodesByLevel[level], 0, this.nodesByLevel[level].length, targetOrd);
            assert (targetIndex >= 0);
            long graphDataOffset = this.graphOffsetsByLevel[level] + (long)targetIndex * (level == 0 ? this.bytesForConns0 : this.bytesForConns);
            this.dataIn.seek(graphDataOffset);
            this.arcCount = this.dataIn.readInt();
            this.arc = -1;
            this.arcUpTo = 0;
        }

        @Override
        public int size() {
            return this.size;
        }

        @Override
        public int nextNeighbor() throws IOException {
            if (this.arcUpTo >= this.arcCount) {
                return Integer.MAX_VALUE;
            }
            ++this.arcUpTo;
            this.arc = this.dataIn.readInt();
            return this.arc;
        }

        @Override
        public int numLevels() {
            return this.numLevels;
        }

        @Override
        public int entryNode() {
            return this.entryNode;
        }

        @Override
        public HnswGraph.NodesIterator getNodesOnLevel(int level) {
            if (level == 0) {
                return new HnswGraph.ArrayNodesIterator(this.size());
            }
            return new HnswGraph.ArrayNodesIterator(this.nodesByLevel[level], this.nodesByLevel[level].length);
        }
    }

    static class FieldEntry {
        final VectorSimilarityFunction similarityFunction;
        final long vectorDataOffset;
        final long vectorDataLength;
        final long vectorIndexOffset;
        final long vectorIndexLength;
        final int M;
        final int numLevels;
        final int dimension;
        final int size;
        final int[][] nodesByLevel;
        final long[] graphOffsetsByLevel;
        final long docsWithFieldOffset;
        final long docsWithFieldLength;
        final short jumpTableEntryCount;
        final byte denseRankPower;
        final long addressesOffset;
        final int blockShift;
        final DirectMonotonicReader.Meta meta;
        final long addressesLength;

        FieldEntry(IndexInput input, VectorSimilarityFunction similarityFunction) throws IOException {
            this.similarityFunction = similarityFunction;
            this.vectorDataOffset = input.readVLong();
            this.vectorDataLength = input.readVLong();
            this.vectorIndexOffset = input.readVLong();
            this.vectorIndexLength = input.readVLong();
            this.dimension = input.readInt();
            this.size = input.readInt();
            this.docsWithFieldOffset = input.readLong();
            this.docsWithFieldLength = input.readLong();
            this.jumpTableEntryCount = input.readShort();
            this.denseRankPower = input.readByte();
            if (this.docsWithFieldOffset == -1L || this.docsWithFieldOffset == -2L) {
                this.addressesOffset = 0L;
                this.blockShift = 0;
                this.meta = null;
                this.addressesLength = 0L;
            } else {
                this.addressesOffset = input.readLong();
                this.blockShift = input.readVInt();
                this.meta = DirectMonotonicReader.loadMeta(input, this.size, this.blockShift);
                this.addressesLength = input.readLong();
            }
            this.M = input.readInt();
            this.numLevels = input.readInt();
            this.nodesByLevel = new int[this.numLevels][];
            for (int level = 0; level < this.numLevels; ++level) {
                int numNodesOnLevel = input.readInt();
                if (level == 0) {
                    assert (numNodesOnLevel == this.size);
                    this.nodesByLevel[0] = null;
                    continue;
                }
                this.nodesByLevel[level] = new int[numNodesOnLevel];
                for (int i = 0; i < numNodesOnLevel; ++i) {
                    this.nodesByLevel[level][i] = input.readInt();
                }
            }
            this.graphOffsetsByLevel = new long[this.numLevels];
            long connectionsAndSizeLevel0Bytes = Math.multiplyExact(Math.addExact(1L, Math.multiplyExact((long)this.M, 2L)), 4);
            long connectionsAndSizeBytes = Math.multiplyExact(Math.addExact(1L, (long)this.M), 4);
            for (int level = 0; level < this.numLevels; ++level) {
                if (level == 0) {
                    this.graphOffsetsByLevel[level] = 0L;
                    continue;
                }
                if (level == 1) {
                    this.graphOffsetsByLevel[level] = Math.multiplyExact(connectionsAndSizeLevel0Bytes, this.size);
                    continue;
                }
                int numNodesOnPrevLevel = this.nodesByLevel[level - 1].length;
                this.graphOffsetsByLevel[level] = Math.addExact(this.graphOffsetsByLevel[level - 1], Math.multiplyExact(connectionsAndSizeBytes, numNodesOnPrevLevel));
            }
        }

        int size() {
            return this.size;
        }
    }
}

