/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.hunspell;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.IntPredicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.hunspell.Dictionary;
import org.apache.lucene.analysis.hunspell.FlagEnumerator;
import org.apache.lucene.analysis.hunspell.Hunspell;
import org.apache.lucene.analysis.hunspell.Root;
import org.apache.lucene.analysis.hunspell.SuggestibleEntryCache;
import org.apache.lucene.analysis.hunspell.Suggestion;
import org.apache.lucene.analysis.hunspell.TrigramAutomaton;
import org.apache.lucene.analysis.hunspell.WordCase;
import org.apache.lucene.util.CharsRef;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.fst.FST;

class GeneratingSuggester {
    private static final int MAX_ROOTS = 100;
    private static final int MAX_WORDS = 100;
    private static final int MAX_GUESSES = 200;
    private static final int MAX_ROOT_LENGTH_DIFF = 4;
    private final Dictionary dictionary;
    private final Hunspell speller;
    private final SuggestibleEntryCache entryCache;

    GeneratingSuggester(Hunspell speller, SuggestibleEntryCache entryCache) {
        this.dictionary = speller.dictionary;
        this.speller = speller;
        this.entryCache = entryCache;
    }

    List<String> suggest(String word, WordCase originalCase, Set<Suggestion> prevSuggestions) {
        List<Weighted<Root<String>>> roots = this.findSimilarDictionaryEntries(word, originalCase);
        List<Weighted<String>> expanded = this.expandRoots(word, roots);
        TreeSet<Weighted<String>> bySimilarity = this.rankBySimilarity(word, expanded);
        return this.getMostRelevantSuggestions(bySimilarity, prevSuggestions);
    }

    private List<Weighted<Root<String>>> findSimilarDictionaryEntries(String word, WordCase originalCase) {
        Comparator natural = Comparator.naturalOrder();
        PriorityQueue roots = new PriorityQueue(natural.reversed());
        char[] excludeFlags = this.dictionary.allNonSuggestibleFlags();
        FlagEnumerator.Lookup flagLookup = this.dictionary.flagLookup;
        IntPredicate isSuggestible = formId -> !flagLookup.hasAnyFlag(formId, excludeFlags);
        boolean ignoreTitleCaseRoots = originalCase == WordCase.LOWER && !this.dictionary.hasLanguage("de");
        TrigramAutomaton automaton = new TrigramAutomaton(word){

            @Override
            char transformChar(char c) {
                return GeneratingSuggester.this.dictionary.caseFold(c);
            }
        };
        this.processSuggestibleWords(Math.max(1, word.length() - 4), word.length() + 4, (rootChars, formSupplier) -> {
            if (ignoreTitleCaseRoots && Character.isUpperCase(rootChars.charAt(0)) && WordCase.caseOf(rootChars) == WordCase.TITLE) {
                return;
            }
            int sc = automaton.ngramScore((CharsRef)rootChars);
            if (sc == 0) {
                return;
            }
            if (roots.size() == 100 && GeneratingSuggester.isWorseThan(sc += GeneratingSuggester.commonPrefix(word, rootChars) - GeneratingSuggester.longerWorsePenalty(word.length(), rootChars.length), rootChars, (Weighted)roots.peek())) {
                return;
            }
            this.speller.checkCanceled.run();
            String root2 = rootChars.toString();
            IntsRef forms = (IntsRef)formSupplier.get();
            for (int i = 0; i < forms.length; ++i) {
                if (!isSuggestible.test(forms.ints[forms.offset + i])) continue;
                roots.add(new Weighted<Root<String>>(new Root<String>(root2, forms.ints[forms.offset + i]), sc));
                if (roots.size() != 100) continue;
                roots.poll();
            }
        });
        return roots.stream().sorted().collect(Collectors.toList());
    }

    private static boolean isWorseThan(int score, CharsRef candidate, Weighted<Root<String>> root2) {
        return score < root2.score || score == root2.score && CharSequence.compare(candidate, ((Root)root2.word).word) > 0;
    }

    private void processSuggestibleWords(int minLength, int maxLength, BiConsumer<CharsRef, Supplier<IntsRef>> processor) {
        if (this.entryCache != null) {
            this.entryCache.processSuggestibleWords(minLength, maxLength, processor);
        } else {
            this.dictionary.words.processSuggestibleWords(minLength, maxLength, processor);
        }
    }

    private List<Weighted<String>> expandRoots(String misspelled, List<Weighted<Root<String>>> roots) {
        int thresh = GeneratingSuggester.calcThreshold(misspelled);
        TreeSet<Weighted<String>> expanded = new TreeSet<Weighted<String>>();
        for (Weighted<Root<String>> weighted : roots) {
            for (String guess : this.expandRoot((Root)weighted.word, misspelled)) {
                String lower = this.dictionary.toLowerCase(guess);
                int sc = GeneratingSuggester.anyMismatchNgram(misspelled.length(), misspelled, lower, false) + GeneratingSuggester.commonPrefix(misspelled, guess);
                if (sc <= thresh) continue;
                expanded.add(new Weighted<String>(guess, sc));
            }
        }
        return expanded.stream().limit(200L).collect(Collectors.toList());
    }

    private static int calcThreshold(String word) {
        int thresh = 0;
        for (int sp = 1; sp < 4; ++sp) {
            char[] mw = word.toCharArray();
            for (int k = sp; k < word.length(); k += 4) {
                mw[k] = 42;
            }
            thresh += GeneratingSuggester.anyMismatchNgram(word.length(), word, new String(mw), false);
        }
        return thresh / 3 - 1;
    }

    private List<String> expandRoot(Root<String> root2, String misspelled) {
        ArrayList crossProducts = new ArrayList();
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        if (!this.dictionary.hasFlag(root2.entryId, this.dictionary.needaffix)) {
            result.add((String)root2.word);
        }
        char[] wordChars = ((String)root2.word).toCharArray();
        this.processAffixes(false, misspelled, (suffixLength, suffixId) -> {
            int stripLength = this.affixStripLength(suffixId);
            if (!this.hasCompatibleFlags(root2, suffixId) || !this.checkAffixCondition(suffixId, wordChars, 0, wordChars.length - stripLength)) {
                return;
            }
            String suffix = misspelled.substring(misspelled.length() - suffixLength);
            String withSuffix = ((String)root2.word).substring(0, ((String)root2.word).length() - stripLength) + suffix;
            result.add(withSuffix);
            if (this.dictionary.isCrossProduct(suffixId)) {
                crossProducts.add(withSuffix.toCharArray());
            }
        });
        this.processAffixes(true, misspelled, (prefixLength, prefixId) -> {
            if (!this.dictionary.hasFlag(root2.entryId, this.dictionary.affixData(prefixId, 0)) || !this.dictionary.isCrossProduct(prefixId)) {
                return;
            }
            int stripLength = this.affixStripLength(prefixId);
            String prefix = misspelled.substring(0, prefixLength);
            for (char[] suffixed : crossProducts) {
                int stemLength;
                if (!this.checkAffixCondition(prefixId, suffixed, stripLength, stemLength = suffixed.length - stripLength)) continue;
                result.add(prefix + new String(suffixed, stripLength, stemLength));
            }
        });
        this.processAffixes(true, misspelled, (prefixLength, prefixId) -> {
            int stripLength = this.affixStripLength(prefixId);
            int stemLength = wordChars.length - stripLength;
            if (this.hasCompatibleFlags(root2, prefixId) && this.checkAffixCondition(prefixId, wordChars, stripLength, stemLength)) {
                String prefix = misspelled.substring(0, prefixLength);
                result.add(prefix + ((String)root2.word).substring(stripLength));
            }
        });
        return result.stream().limit(100L).collect(Collectors.toList());
    }

    private void processAffixes(boolean prefixes, String word, AffixProcessor processor) {
        int i;
        FST<IntsRef> fst;
        FST<IntsRef> fST = fst = prefixes ? this.dictionary.prefixes : this.dictionary.suffixes;
        if (fst == null) {
            return;
        }
        FST.Arc<IntsRef> arc = fst.getFirstArc(new FST.Arc());
        if (arc.isFinal()) {
            this.processAffixIds(0, arc.nextFinalOutput(), processor);
        }
        FST.BytesReader reader = fst.getBytesReader();
        IntsRef output = (IntsRef)fst.outputs.getNoOutput();
        int length = word.length();
        int step = prefixes ? 1 : -1;
        int limit = prefixes ? length : -1;
        int n = i = prefixes ? 0 : length - 1;
        while (i != limit && (output = Dictionary.nextArc(fst, arc, reader, output, word.charAt(i))) != null) {
            if (arc.isFinal()) {
                IntsRef affixIds = fst.outputs.add(output, arc.nextFinalOutput());
                this.processAffixIds(prefixes ? i + 1 : length - i, affixIds, processor);
            }
            i += step;
        }
    }

    private void processAffixIds(int affixLength, IntsRef affixIds, AffixProcessor processor) {
        for (int j = 0; j < affixIds.length; ++j) {
            processor.processAffix(affixLength, affixIds.ints[affixIds.offset + j]);
        }
    }

    private boolean hasCompatibleFlags(Root<?> root2, int affixId) {
        if (!this.dictionary.hasFlag(root2.entryId, this.dictionary.affixData(affixId, 0))) {
            return false;
        }
        char append = this.dictionary.affixData(affixId, 3);
        return !this.dictionary.hasFlag(append, this.dictionary.needaffix) && !this.dictionary.hasFlag(append, this.dictionary.circumfix) && !this.dictionary.hasFlag(append, this.dictionary.onlyincompound);
    }

    private boolean checkAffixCondition(int suffixId, char[] word, int offset, int length) {
        if (length < 0) {
            return false;
        }
        int condition = this.dictionary.getAffixCondition(suffixId);
        return condition == 0 || this.dictionary.patterns.get(condition).acceptsStem(word, offset, length);
    }

    private int affixStripLength(int affixId) {
        char stripOrd = this.dictionary.affixData(affixId, 1);
        return this.dictionary.stripOffsets[stripOrd + '\u0001'] - this.dictionary.stripOffsets[stripOrd];
    }

    private TreeSet<Weighted<String>> rankBySimilarity(String word, List<Weighted<String>> expanded) {
        double fact = (10.0 - (double)this.dictionary.maxDiff) / 5.0;
        TreeSet<Weighted<String>> bySimilarity = new TreeSet<Weighted<String>>();
        for (Weighted<String> weighted : expanded) {
            String guess = (String)weighted.word;
            String lower = this.dictionary.toLowerCase(guess);
            if (lower.equals(word)) {
                bySimilarity.add(new Weighted<String>(guess, weighted.score + 2000));
                break;
            }
            int re = GeneratingSuggester.anyMismatchNgram(2, word, lower, true) + GeneratingSuggester.anyMismatchNgram(2, lower, word, true);
            int score = 2 * GeneratingSuggester.lcs(word, lower) - Math.abs(word.length() - lower.length()) + GeneratingSuggester.commonCharacterPositionScore(word, lower) + GeneratingSuggester.commonPrefix(word, lower) + GeneratingSuggester.anyMismatchNgram(4, word, lower, false) + re + ((double)re < (double)(word.length() + lower.length()) * fact ? -1000 : 0);
            bySimilarity.add(new Weighted<String>(guess, score));
        }
        return bySimilarity;
    }

    private List<String> getMostRelevantSuggestions(TreeSet<Weighted<String>> bySimilarity, Set<Suggestion> prevSuggestions) {
        ArrayList<String> result = new ArrayList<String>();
        boolean hasExcellent = false;
        for (Weighted<String> weighted : bySimilarity) {
            boolean bad;
            if (weighted.score > 1000) {
                hasExcellent = true;
            } else if (hasExcellent) break;
            boolean bl = bad = weighted.score < -100;
            if (bad && (!result.isEmpty() || this.dictionary.onlyMaxDiff)) break;
            if (prevSuggestions.stream().noneMatch(s -> ((String)weighted.word).contains(s.raw))) {
                if (result.stream().noneMatch(((String)weighted.word)::contains) && this.speller.checkWord((String)weighted.word)) {
                    result.add((String)weighted.word);
                    if (result.size() >= this.dictionary.maxNGramSuggestions) break;
                }
            }
            if (!bad) continue;
            break;
        }
        return result;
    }

    static int commonPrefix(CharSequence s1, CharSequence s2) {
        int i;
        int limit = Math.min(s1.length(), s2.length());
        for (i = 0; i < limit && s1.charAt(i) == s2.charAt(i); ++i) {
        }
        return i;
    }

    static int ngramScore(int n, String s1, String s2, boolean weighted) {
        int l1 = s1.length();
        int score = 0;
        int[] lastStarts = new int[l1];
        for (int j = 1; j <= n; ++j) {
            int ns = 0;
            for (int i = 0; i <= l1 - j; ++i) {
                if (lastStarts[i] >= 0) {
                    int pos;
                    lastStarts[i] = pos = GeneratingSuggester.indexOfSubstring(s2, lastStarts[i], s1, i, j);
                    if (pos >= 0) {
                        ++ns;
                        continue;
                    }
                }
                if (!weighted) continue;
                --ns;
                if (i != 0 && i != l1 - j) continue;
                --ns;
            }
            score += ns;
            if (ns < 2 && !weighted) break;
        }
        return score;
    }

    private static int longerWorsePenalty(int length1, int length2) {
        return Math.max(length2 - length1 - 2, 0);
    }

    private static int anyMismatchNgram(int n, String s1, String s2, boolean weighted) {
        return GeneratingSuggester.ngramScore(n, s1, s2, weighted) - Math.max(Math.abs(s2.length() - s1.length()) - 2, 0);
    }

    private static int indexOfSubstring(String haystack, int haystackPos, String needle, int needlePos, int len) {
        char c = needle.charAt(needlePos);
        int limit = haystack.length() - len;
        for (int i = haystackPos; i <= limit; ++i) {
            if (haystack.charAt(i) != c || !haystack.regionMatches(i + 1, needle, needlePos + 1, len - 1)) continue;
            return i;
        }
        return -1;
    }

    private static int lcs(String s1, String s2) {
        int[] lengths = new int[s2.length() + 1];
        for (int i = 1; i <= s1.length(); ++i) {
            int prev = 0;
            for (int j = 1; j <= s2.length(); ++j) {
                int cur = lengths[j];
                lengths[j] = s1.charAt(i - 1) == s2.charAt(j - 1) ? prev + 1 : Math.max(cur, lengths[j - 1]);
                prev = cur;
            }
        }
        return lengths[s2.length()];
    }

    private static int commonCharacterPositionScore(String s1, String s2) {
        int commonScore;
        int i;
        int num = 0;
        int diffPos1 = -1;
        int diffPos2 = -1;
        int diff = 0;
        for (i = 0; i < s1.length() && i < s2.length(); ++i) {
            if (s1.charAt(i) == s2.charAt(i)) {
                ++num;
                continue;
            }
            if (diff == 0) {
                diffPos1 = i;
            } else if (diff == 1) {
                diffPos2 = i;
            }
            ++diff;
        }
        int n = commonScore = num > 0 ? 1 : 0;
        if (diff == 2 && i == s1.length() && i == s2.length() && s1.charAt(diffPos1) == s2.charAt(diffPos2) && s1.charAt(diffPos2) == s2.charAt(diffPos1)) {
            return commonScore + 10;
        }
        return commonScore;
    }

    private static class Weighted<T extends Comparable<T>>
    implements Comparable<Weighted<T>> {
        final T word;
        final int score;

        Weighted(T word, int score) {
            this.word = word;
            this.score = score;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Weighted)) {
                return false;
            }
            Weighted that = (Weighted)o;
            return this.score == that.score && this.word.equals(that.word);
        }

        public int hashCode() {
            return Objects.hash(this.word, this.score);
        }

        public String toString() {
            return this.word + "(" + this.score + ")";
        }

        @Override
        public int compareTo(Weighted<T> o) {
            int cmp = Integer.compare(this.score, o.score);
            return cmp != 0 ? -cmp : this.word.compareTo(o.word);
        }
    }

    private static interface AffixProcessor {
        public void processAffix(int var1, int var2);
    }
}

