/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shex.expressions;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shex.eval.ShapeEval;
import org.apache.jena.shex.expressions.SemAct;
import org.apache.jena.shex.expressions.ShapeExprVisitor;
import org.apache.jena.shex.expressions.ShapeExpression;
import org.apache.jena.shex.expressions.TripleExpression;
import org.apache.jena.shex.sys.ValidationContext;

public class ShapeExprTripleExpr
extends ShapeExpression {
    private Node label;
    private Set<Node> extras;
    private boolean closed;
    private TripleExpression tripleExpr;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ShapeExprTripleExpr(Node label, Set<Node> extras, boolean closed, TripleExpression tripleExpr, List<SemAct> semActs) {
        super(semActs);
        this.label = label;
        this.extras = extras == null || extras.isEmpty() ? null : extras;
        this.closed = closed;
        this.tripleExpr = tripleExpr;
    }

    public TripleExpression getTripleExpr() {
        return this.tripleExpr;
    }

    public Node getLabel() {
        return this.label;
    }

    public Set<Node> getExtras() {
        return this.extras;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean satisfies(ValidationContext vCxt, Node node) {
        return ShapeEval.matchesTripleExpr(vCxt, this.tripleExpr, node, this.extras, this.closed);
    }

    @Override
    public void print(IndentedWriter iOut, NodeFormatter nFmt) {
        iOut.print("Shape");
        if (this.label != null) {
            iOut.print(" ");
            nFmt.format(iOut, this.label);
        }
        iOut.println();
        iOut.incIndent();
        if (this.closed) {
            iOut.println("CLOSED");
        }
        iOut.println("TripleExpression");
        iOut.incIndent();
        if (this.tripleExpr != null) {
            this.tripleExpr.print(iOut, nFmt);
        } else {
            iOut.println("<none>");
        }
        iOut.decIndent();
        iOut.decIndent();
    }

    @Override
    public void visit(ShapeExprVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        return "Shape: " + (Serializable)(this.label == null ? "" : this.label);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.closed, this.label, this.tripleExpr);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShapeExprTripleExpr other = (ShapeExprTripleExpr)obj;
        return this.closed == other.closed && Objects.equals(this.label, other.label) && Objects.equals(this.tripleExpr, other.tripleExpr);
    }

    public static class Builder {
        private Node label;
        private Set<Node> extras = null;
        private List<SemAct> semActs;
        private Optional<Boolean> closed = null;
        private TripleExpression tripleExpr = null;

        Builder() {
        }

        public Builder label(Node label) {
            this.label = label;
            return this;
        }

        public Builder extras(List<Node> extrasList) {
            if (this.extras == null) {
                this.extras = new HashSet<Node>();
            }
            this.extras.addAll(extrasList);
            return this;
        }

        public Builder semActs(List<SemAct> semActsList) {
            if (this.semActs == null) {
                this.semActs = new ArrayList<SemAct>();
            }
            if (semActsList != null) {
                this.semActs.addAll(semActsList);
            }
            return this;
        }

        public Builder closed(boolean value) {
            this.closed = Optional.of(value);
            return this;
        }

        public Builder shapeExpr(TripleExpression tripleExpr) {
            this.tripleExpr = tripleExpr;
            return this;
        }

        public ShapeExprTripleExpr build() {
            boolean isClosed = this.closed == null ? false : this.closed.get();
            return new ShapeExprTripleExpr(this.label, this.extras, isClosed, this.tripleExpr, this.semActs);
        }
    }
}

