/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.shacl.engine.constraint;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Node;
import org.apache.jena.riot.out.NodeFormatter;
import org.apache.jena.shacl.compact.writer.CompactOut;
import org.apache.jena.shacl.engine.ValidationContext;
import org.apache.jena.shacl.engine.constraint.ConstraintTerm;
import org.apache.jena.shacl.parser.ConstraintVisitor;
import org.apache.jena.shacl.validation.ReportItem;
import org.apache.jena.shacl.vocabulary.SHJ;

public class JViolationConstraint
extends ConstraintTerm {
    private final boolean generateViolation;

    public JViolationConstraint(boolean generateViolation) {
        this.generateViolation = generateViolation;
    }

    public boolean generatesViolation() {
        return this.generateViolation;
    }

    @Override
    public Node getComponent() {
        return SHJ.ViolationConstraintComponent;
    }

    @Override
    public ReportItem validate(ValidationContext vCxt, Node n) {
        if (!this.generateViolation) {
            return null;
        }
        return new ReportItem("Violation");
    }

    @Override
    public void visit(ConstraintVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void printCompact(IndentedWriter out, NodeFormatter nodeFmt) {
        CompactOut.compactUnquotedString(out, "violation", Boolean.toString(this.generateViolation));
    }

    public String toString() {
        return "Violation[" + this.generateViolation + "]";
    }

    public int hashCode() {
        return 158 + (this.generateViolation ? 1 : 2);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JViolationConstraint other = (JViolationConstraint)obj;
        return this.generateViolation == other.generateViolation;
    }
}

