/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.fuseki.servlets;

import org.apache.commons.lang3.StringUtils;
import org.apache.jena.atlas.logging.FmtLog;
import org.apache.jena.fuseki.servlets.ActionLib;
import org.apache.jena.fuseki.servlets.ActionPrefixesR;
import org.apache.jena.fuseki.servlets.HttpAction;
import org.apache.jena.fuseki.servlets.ServletOps;
import org.apache.jena.fuseki.servlets.prefixes.PrefixUtils;
import org.apache.jena.fuseki.servlets.prefixes.PrefixesAccess;

public class ActionPrefixesRW
extends ActionPrefixesR {
    @Override
    protected void doOptions(HttpAction action) {
        ActionLib.setCommonHeadersForOptions(action);
        action.setResponseHeader("Allow", "GET,OPTIONS,POST,DELETE");
        ServletOps.success(action);
    }

    @Override
    protected void validatePrefixesDELETE(HttpAction action) {
        String prefixToRemove = action.getRequestParameter("prefix");
        if (prefixToRemove == null || prefixToRemove.isEmpty() || !PrefixUtils.prefixIsValid(prefixToRemove)) {
            ServletOps.errorBadRequest("Remove operation unsuccessful!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDelete(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        action.beginWrite();
        try {
            String prefixToRemove = action.getRequestParameter("prefix");
            PrefixesAccess prefixes = this.prefixes(action);
            prefixes.removePrefix(prefixToRemove);
            FmtLog.info(action.log, "[%d] Remove %s:", action.id, prefixToRemove);
            action.commit();
            ServletOps.success(action);
        }
        catch (RuntimeException ex) {
            action.abortSilent();
            ServletOps.errorOccurred(ex);
        }
        finally {
            action.end();
        }
    }

    @Override
    protected void validatePrefixesPOST(HttpAction action) {
        String prefix = action.getRequestParameter("prefix");
        String uri = action.getRequestParameter("uri");
        if (prefix.isEmpty()) {
            ServletOps.errorBadRequest("Missing prefix parameter");
            return;
        }
        if (StringUtils.isEmpty(uri)) {
            ServletOps.errorBadRequest("Missing URI parameter");
            return;
        }
        if (!PrefixUtils.prefixIsValid(prefix) || !PrefixUtils.uriIsValid(uri)) {
            ServletOps.errorBadRequest("Empty operation - unsuccessful!");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doPost(HttpAction action) {
        ActionLib.setCommonHeaders(action);
        action.beginWrite();
        try {
            try {
                String prefix = action.getRequestParameter("prefix");
                String uri = action.getRequestParameter("uri");
                PrefixesAccess prefixes = this.prefixes(action);
                prefixes.updatePrefix(prefix, uri);
                FmtLog.info(action.log, "[%d] Set %s: <%s>", action.id, prefix, uri);
                action.commit();
                ServletOps.success(action);
            }
            catch (RuntimeException ex) {
                action.abortSilent();
                ServletOps.errorOccurred(ex);
            }
        }
        finally {
            action.end();
        }
    }
}

