/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.cmd;

import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.atlas.iterator.Iter;

public class Usage {
    private List<Category> categories = new ArrayList<Category>();

    public Usage() {
        this.startCategory(null);
    }

    public void startCategory(String desc) {
        this.categories.add(new Category(desc));
    }

    public void addUsage(String argName, String msg) {
        this.current().entries.add(new Entry(argName, msg));
    }

    public void output(PrintStream out) {
        this.output(new IndentedWriter(out));
    }

    public void output(IndentedWriter out) {
        int INDENT1 = 2;
        int INDENT2 = 4;
        out.incIndent(INDENT1);
        Iter.reverseIterate(this.categories, c -> {
            if (c.desc != null) {
                out.println(c.desc);
            }
            out.incIndent(INDENT2);
            for (Entry e2 : c.entries) {
                out.print(e2.arg);
                if (e2.msg != null) {
                    out.pad(20);
                    out.print("   ");
                    out.print(e2.msg);
                }
                out.println();
            }
            out.decIndent(INDENT2);
        });
        out.decIndent(INDENT1);
        out.flush();
    }

    private Category current() {
        return this.categories.get(this.categories.size() - 1);
    }

    public static class Category {
        String desc;
        List<Entry> entries = new ArrayList<Entry>();

        Category(String desc) {
            this.desc = desc;
        }
    }

    private static class Entry {
        String arg;
        String msg;

        Entry(String arg, String msg) {
            this.arg = arg;
            this.msg = msg;
        }
    }
}

