/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.selectitems;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.model.SelectItem;
import javax.faces.model.SelectItemGroup;
import org.omnifaces.util.Utils;
import org.omnifaces.util.selectitems.SelectItemsCollector;

public final class SelectItemsUtils {
    private SelectItemsUtils() {
    }

    public static Object findValueByStringConversion(FacesContext context2, UIComponent component, String value, Converter<Object> converter) {
        return SelectItemsUtils.findValueByStringConversion(context2, component, SelectItemsCollector.collectFromParent(context2, component).iterator(), value, converter);
    }

    private static Object findValueByStringConversion(FacesContext context2, UIComponent component, Iterator<SelectItem> items, String value, Converter<Object> converter) {
        while (items.hasNext()) {
            Object itemValue;
            String convertedItemValue;
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                SelectItem[] groupItems = ((SelectItemGroup)item).getSelectItems();
                Object object = SelectItemsUtils.findValueByStringConversion(context2, component, groupItems, value, converter);
                if (object == null) continue;
                return object;
            }
            if (item.isNoSelectionOption() || !Objects.equals(value, convertedItemValue = converter.getAsString(context2, component, itemValue = item.getValue()))) continue;
            return itemValue;
        }
        return null;
    }

    private static Object findValueByStringConversion(FacesContext context2, UIComponent component, SelectItem[] items, String value, Converter<Object> converter) {
        return Utils.isEmpty(items) ? null : SelectItemsUtils.findValueByStringConversion(context2, component, new ArrayIterator(items), value, converter);
    }

    public static List<Object> collectAllValuesFromSelectItems(FacesContext context2, UIComponent component) {
        ArrayList<Object> values = new ArrayList<Object>();
        SelectItemsUtils.collect(SelectItemsCollector.collectFromParent(context2, component).iterator(), values);
        return values;
    }

    private static void collect(Iterator<SelectItem> items, List<Object> values) {
        while (items.hasNext()) {
            SelectItem item = items.next();
            if (item instanceof SelectItemGroup) {
                SelectItem[] subitems = ((SelectItemGroup)item).getSelectItems();
                if (Utils.isEmpty(subitems)) continue;
                SelectItemsUtils.collect(new ArrayIterator(subitems), values);
                continue;
            }
            if (item.isNoSelectionOption()) continue;
            values.add(item.getValue());
        }
    }

    static class ArrayIterator
    implements Iterator<SelectItem> {
        private SelectItem[] items;
        private int index = 0;

        public ArrayIterator(SelectItem[] items) {
            this.items = items;
        }

        @Override
        public boolean hasNext() {
            return this.index < this.items.length;
        }

        @Override
        public SelectItem next() {
            if (this.hasNext()) {
                return this.items[this.index++];
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

