/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.FacesWrapper;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ProjectStage;
import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.Flash;
import javax.faces.context.PartialViewContext;
import javax.faces.convert.Converter;
import javax.faces.convert.FacesConverter;
import javax.faces.event.PhaseId;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.faces.validator.FacesValidator;
import javax.faces.validator.Validator;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewMetadata;
import javax.faces.view.facelets.FaceletContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.Part;
import org.omnifaces.component.ParamHolder;
import org.omnifaces.component.input.HashParam;
import org.omnifaces.component.input.ScriptParam;
import org.omnifaces.config.FacesConfigXml;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Callback;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.Utils;

public final class FacesLocal {
    private static final Logger logger = Logger.getLogger(FacesLocal.class.getName());
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final int DEFAULT_SENDFILE_BUFFER_SIZE = 10240;
    private static final String ERROR_NO_VIEW = "There is no view.";

    private FacesLocal() {
    }

    public static Package getPackage(FacesContext context2) {
        if (context2 != null) {
            while (context2 instanceof FacesWrapper) {
                context2 = (FacesContext)((FacesWrapper)context2).getWrapped();
            }
            return context2.getClass().getPackage();
        }
        return FacesContext.class.getPackage();
    }

    public static String getImplInfo(FacesContext context2) {
        Package facesPackage = FacesLocal.getPackage(context2);
        return facesPackage.getImplementationTitle() + " " + facesPackage.getImplementationVersion();
    }

    public static String getServerInfo(FacesContext context2) {
        return FacesLocal.getServletContext(context2).getServerInfo();
    }

    public static ProjectStage getProjectStage(FacesContext context2) {
        return context2.getApplication().getProjectStage();
    }

    public static boolean isDevelopment(FacesContext context2) {
        return FacesLocal.getProjectStage(context2) == ProjectStage.Development;
    }

    public static boolean isSystemTest(FacesContext context2) {
        return FacesLocal.getProjectStage(context2) == ProjectStage.SystemTest;
    }

    public static boolean isProduction(FacesContext context2) {
        return FacesLocal.getProjectStage(context2) == ProjectStage.Production;
    }

    public static String getMapping(FacesContext context2) {
        ExternalContext externalContext = context2.getExternalContext();
        if (externalContext.getRequestPathInfo() == null) {
            String path = externalContext.getRequestServletPath();
            return path.substring(path.lastIndexOf(46));
        }
        return externalContext.getRequestServletPath();
    }

    public static boolean isPrefixMapping(FacesContext context2) {
        return Faces.isPrefixMapping(FacesLocal.getMapping(context2));
    }

    public static <T> T evaluateExpressionGet(FacesContext context2, String expression) {
        if (Utils.isEmpty(expression)) {
            return null;
        }
        return (T)context2.getApplication().evaluateExpressionGet(context2, expression, Object.class);
    }

    public static void evaluateExpressionSet(FacesContext context2, String expression, Object value) {
        ELContext elContext = context2.getELContext();
        ValueExpression valueExpression = context2.getApplication().getExpressionFactory().createValueExpression(elContext, expression, Object.class);
        valueExpression.setValue(elContext, value);
    }

    public static <T> T resolveExpressionGet(FacesContext context2, Object base, String property) {
        ELResolver elResolver = context2.getApplication().getELResolver();
        return (T)elResolver.getValue(context2.getELContext(), base, (Object)property);
    }

    public static void resolveExpressionSet(FacesContext context2, Object base, String property, Object value) {
        ELResolver elResolver = context2.getApplication().getELResolver();
        elResolver.setValue(context2.getELContext(), base, (Object)property, value);
    }

    public static <T> T getContextAttribute(FacesContext context2, String name) {
        return (T)context2.getAttributes().get(name);
    }

    public static <T> T getContextAttribute(FacesContext context2, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getContextAttribute(context2, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setContextAttribute(context2, name, value);
        }
        return value;
    }

    public static void setContextAttribute(FacesContext context2, String name, Object value) {
        context2.getAttributes().put(name, value);
    }

    public static <T> Converter<T> createConverter(FacesContext context2, Object identifier) {
        if (identifier instanceof String) {
            return FacesLocal.createConverter(context2, (String)identifier);
        }
        if (identifier instanceof Class) {
            return FacesLocal.createConverter(context2, (Class)identifier);
        }
        if (identifier instanceof Converter) {
            return (Converter)identifier;
        }
        return null;
    }

    public static <T> Converter<T> createConverter(FacesContext context2, String identifier) {
        Converter<T> converter = context2.getApplication().createConverter(identifier);
        if (converter == null) {
            converter = FacesLocal.createConverter(context2, Reflection.toClassOrNull(identifier));
        }
        return converter;
    }

    public static <T> Converter<T> createConverter(FacesContext context2, Class<?> identifier) {
        if (Converter.class.isAssignableFrom(identifier)) {
            FacesConverter annotation = identifier.getAnnotation(FacesConverter.class);
            if (annotation != null) {
                return (Converter)Beans.getReference(identifier, new Annotation[]{annotation});
            }
            return (Converter)Reflection.instance(identifier);
        }
        return context2.getApplication().createConverter(identifier);
    }

    public static <T> Validator<T> createValidator(FacesContext context2, Object identifier) {
        if (identifier instanceof String) {
            return FacesLocal.createValidator(context2, (String)identifier);
        }
        if (identifier instanceof Class) {
            return FacesLocal.createValidator(context2, (Class)identifier);
        }
        if (identifier instanceof Validator) {
            return (Validator)identifier;
        }
        return null;
    }

    public static <T> Validator<T> createValidator(FacesContext context2, String identifier) {
        Validator<T> validator = context2.getApplication().createValidator(identifier);
        if (validator == null) {
            validator = FacesLocal.createValidator(context2, Reflection.toClassOrNull(identifier));
        }
        return validator;
    }

    public static <T> Validator<T> createValidator(FacesContext context2, Class<?> identifier) {
        if (Validator.class.isAssignableFrom(identifier)) {
            FacesValidator annotation = identifier.getAnnotation(FacesValidator.class);
            if (annotation != null) {
                return (Validator)Beans.getReference(identifier, new Annotation[]{annotation});
            }
            return (Validator)Reflection.instance(identifier);
        }
        return null;
    }

    public static Resource createResource(FacesContext context2, String resourceName) {
        return context2.getApplication().getResourceHandler().createResource(resourceName);
    }

    public static Resource createResource(FacesContext context2, String libraryName, String resourceName) {
        return context2.getApplication().getResourceHandler().createResource(resourceName, libraryName);
    }

    public static Resource createResource(FacesContext context2, ResourceIdentifier resourceIdentifier) {
        return context2.getApplication().getResourceHandler().createResource(resourceIdentifier.getName(), resourceIdentifier.getLibrary());
    }

    public static Lifecycle getLifecycle(FacesContext context2) {
        return Servlets.getFacesLifecycle(FacesLocal.getServletContext(context2));
    }

    public static void setViewRoot(FacesContext context2, String viewId) {
        context2.setViewRoot(context2.getApplication().getViewHandler().createView(context2, viewId));
    }

    public static String getViewId(FacesContext context2) {
        UIViewRoot viewRoot = context2.getViewRoot();
        return viewRoot != null ? viewRoot.getViewId() : null;
    }

    public static String getViewIdWithParameters(FacesContext context2) {
        String viewId = Utils.coalesce(FacesLocal.getViewId(context2), "");
        String viewParameters = Servlets.toQueryString(FacesLocal.getViewParameterMap(context2));
        String hashParameters = FacesLocal.getHashQueryString(context2);
        return (viewParameters == null ? viewId : viewId + "?" + viewParameters) + (hashParameters == null ? "" : "#" + hashParameters);
    }

    public static String getViewName(FacesContext context2) {
        String viewId = FacesLocal.getViewId(context2);
        return viewId != null ? viewId.substring(viewId.lastIndexOf(47) + 1).split("\\.")[0] : null;
    }

    public static ViewDeclarationLanguage getViewDeclarationLanguage(FacesContext context2) {
        return context2.getApplication().getViewHandler().getViewDeclarationLanguage(context2, context2.getViewRoot().getViewId());
    }

    public static RenderKit getRenderKit(FacesContext context2) {
        String renderKitId = null;
        UIViewRoot view = context2.getViewRoot();
        if (view != null) {
            renderKitId = view.getRenderKitId();
        }
        if (renderKitId == null) {
            Application application = context2.getApplication();
            ViewHandler viewHandler = application.getViewHandler();
            if (viewHandler != null) {
                renderKitId = viewHandler.calculateRenderKitId(context2);
            }
            if (renderKitId == null && (renderKitId = application.getDefaultRenderKitId()) == null) {
                renderKitId = "HTML_BASIC";
            }
        }
        return ((RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory")).getRenderKit(context2, renderKitId);
    }

    public static String normalizeViewId(FacesContext context2, String path) {
        String mapping = FacesLocal.getMapping(context2);
        if (Faces.isPrefixMapping(mapping)) {
            if (path.startsWith(mapping)) {
                return path.substring(mapping.length());
            }
        } else if (path.endsWith(mapping)) {
            return path.substring(0, path.lastIndexOf(46)) + Utils.coalesce(FacesLocal.getInitParameter(context2, "javax.faces.FACELETS_SUFFIX"), ".xhtml");
        }
        return path;
    }

    public static Collection<UIViewParameter> getViewParameters(FacesContext context2) {
        UIViewRoot viewRoot = context2.getViewRoot();
        return viewRoot != null ? ViewMetadata.getViewParameters((UIViewRoot)viewRoot) : Collections.emptyList();
    }

    public static Map<String, List<String>> getViewParameterMap(FacesContext context2) {
        Collection<UIViewParameter> viewParameters = FacesLocal.getViewParameters(context2);
        if (viewParameters.isEmpty()) {
            return new LinkedHashMap<String, List<String>>(0);
        }
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(viewParameters.size());
        for (UIViewParameter viewParameter : viewParameters) {
            String value = viewParameter.getStringValue(context2);
            if (value == null) continue;
            parameterMap.put(viewParameter.getName(), Arrays.asList(value));
        }
        return parameterMap;
    }

    public static Collection<HashParam> getHashParameters(FacesContext context2) {
        UIViewRoot viewRoot = context2.getViewRoot();
        return viewRoot != null ? Components.findComponentsInChildren(viewRoot.getFacet("javax_faces_metadata"), HashParam.class) : Collections.emptyList();
    }

    public static Map<String, List<String>> getHashParameterMap(FacesContext context2) {
        Collection<HashParam> hashParameters = FacesLocal.getHashParameters(context2);
        if (hashParameters.isEmpty()) {
            return new LinkedHashMap<String, List<String>>(0);
        }
        LinkedHashMap<String, List<String>> parameterMap = new LinkedHashMap<String, List<String>>(hashParameters.size());
        for (HashParam hashParameter : hashParameters) {
            String value;
            if (Utils.isEmpty(hashParameter.getName()) || Utils.isEmpty(value = hashParameter.getRenderedValue(context2))) continue;
            parameterMap.put(hashParameter.getName(), Arrays.asList(value));
        }
        return parameterMap;
    }

    public static String getHashQueryString(FacesContext context2) {
        return Servlets.toQueryString(FacesLocal.getHashParameterMap(context2));
    }

    public static Collection<ScriptParam> getScriptParameters(FacesContext context2) {
        UIViewRoot viewRoot = context2.getViewRoot();
        return viewRoot != null ? Components.findComponentsInChildren(viewRoot.getFacet("javax_faces_metadata"), ScriptParam.class) : Collections.emptyList();
    }

    public static Map<String, Object> getMetadataAttributes(FacesContext context2, String viewId) {
        ViewHandler viewHandler = context2.getApplication().getViewHandler();
        ViewDeclarationLanguage vdl = viewHandler.getViewDeclarationLanguage(context2, viewId);
        ViewMetadata metadata = vdl.getViewMetadata(context2, viewId);
        return metadata != null ? metadata.createMetadataView(context2).getAttributes() : Collections.emptyMap();
    }

    public static Map<String, Object> getMetadataAttributes(FacesContext context2) {
        return context2.getViewRoot().getAttributes();
    }

    public static <T> T getMetadataAttribute(FacesContext context2, String viewId, String name) {
        return (T)FacesLocal.getMetadataAttributes(context2, viewId).get(name);
    }

    public static <T> T getMetadataAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getMetadataAttributes(context2).get(name);
    }

    public static Locale getLocale(FacesContext context2) {
        Locale locale = null;
        if (context2 != null) {
            UIViewRoot viewRoot = context2.getViewRoot();
            if (viewRoot != null) {
                locale = viewRoot.getLocale();
            }
            if (locale == null) {
                Locale clientLocale = context2.getExternalContext().getRequestLocale();
                if (FacesLocal.getSupportedLocales(context2).contains(clientLocale)) {
                    locale = clientLocale;
                }
            }
            if (locale == null) {
                locale = context2.getApplication().getDefaultLocale();
            }
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static Locale getDefaultLocale(FacesContext context2) {
        return context2.getApplication().getDefaultLocale();
    }

    public static List<Locale> getSupportedLocales(FacesContext context2) {
        Application application = context2.getApplication();
        ArrayList<Locale> supportedLocales = new ArrayList<Locale>();
        Locale defaultLocale = application.getDefaultLocale();
        if (defaultLocale != null) {
            supportedLocales.add(defaultLocale);
        }
        Iterator iter = application.getSupportedLocales();
        while (iter.hasNext()) {
            Locale supportedLocale = (Locale)iter.next();
            if (supportedLocale.equals(defaultLocale)) continue;
            supportedLocales.add(supportedLocale);
        }
        return supportedLocales;
    }

    public static void setLocale(FacesContext context2, Locale locale) {
        UIViewRoot viewRoot = context2.getViewRoot();
        if (viewRoot == null) {
            throw new IllegalStateException(ERROR_NO_VIEW);
        }
        viewRoot.setLocale(locale);
    }

    public static ResourceBundle getMessageBundle(FacesContext context2) {
        String messageBundle = context2.getApplication().getMessageBundle();
        if (messageBundle == null) {
            return null;
        }
        return ResourceBundle.getBundle(messageBundle, FacesLocal.getLocale(context2));
    }

    public static ResourceBundle getResourceBundle(FacesContext context2, String var) {
        return context2.getApplication().getResourceBundle(context2, var);
    }

    public static Map<String, ResourceBundle> getResourceBundles(FacesContext context2) {
        Map<String, String> resourceBundles = FacesConfigXml.instance().getResourceBundles();
        HashMap<String, ResourceBundle> map = new HashMap<String, ResourceBundle>(resourceBundles.size());
        for (String var : resourceBundles.keySet()) {
            map.put(var, FacesLocal.getResourceBundle(context2, var));
        }
        return map;
    }

    public static String getBundleString(FacesContext context2, String key) {
        for (ResourceBundle bundle : FacesLocal.getResourceBundles(context2).values()) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; there is a fallback anyway.", ignore);
            }
        }
        return "???" + key + "???";
    }

    public static void navigate(FacesContext context2, String outcome) {
        context2.getApplication().getNavigationHandler().handleNavigation(context2, null, outcome);
    }

    public static String getBookmarkableURL(FacesContext context2, Map<String, List<String>> params, boolean includeViewParams) {
        String viewId = FacesLocal.getViewId(context2);
        if (viewId == null) {
            throw new IllegalStateException(ERROR_NO_VIEW);
        }
        return FacesLocal.getBookmarkableURL(context2, viewId, params, includeViewParams);
    }

    public static String getBookmarkableURL(FacesContext context2, String viewId, Map<String, List<String>> params, boolean includeViewParams) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (params != null) {
            for (Map.Entry<String, List<String>> param : params.entrySet()) {
                for (String value : param.getValue()) {
                    Servlets.addParamToMapIfNecessary(map, param.getKey(), value);
                }
            }
        }
        return context2.getApplication().getViewHandler().getBookmarkableURL(context2, viewId, map, includeViewParams);
    }

    public static String getBookmarkableURL(FacesContext context2, Collection<? extends ParamHolder<?>> params, boolean includeViewParams) {
        String viewId = FacesLocal.getViewId(context2);
        if (viewId == null) {
            throw new IllegalStateException(ERROR_NO_VIEW);
        }
        return FacesLocal.getBookmarkableURL(context2, viewId, params, includeViewParams);
    }

    public static String getBookmarkableURL(FacesContext context2, String viewId, Collection<? extends ParamHolder<?>> params, boolean includeViewParams) {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        if (params != null) {
            for (ParamHolder<?> param : params) {
                Servlets.addParamToMapIfNecessary(map, param.getName(), param.getValue());
            }
        }
        return context2.getApplication().getViewHandler().getBookmarkableURL(context2, viewId, map, includeViewParams);
    }

    public static FaceletContext getFaceletContext(FacesContext context2) {
        FaceletContext faceletContext = (FaceletContext)FacesLocal.getContextAttribute(context2, FaceletContext.FACELET_CONTEXT_KEY);
        if (faceletContext != null) {
            return faceletContext;
        }
        throw new IllegalStateException(ERROR_NO_VIEW);
    }

    public static <T> T getFaceletAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getFaceletContext(context2).getAttribute(name);
    }

    public static void setFaceletAttribute(FacesContext context2, String name, Object value) {
        FacesLocal.getFaceletContext(context2).setAttribute(name, value);
    }

    public static HttpServletRequest getRequest(FacesContext context2) {
        return (HttpServletRequest)context2.getExternalContext().getRequest();
    }

    public static boolean isAjaxRequest(FacesContext context2) {
        return context2.getPartialViewContext().isAjaxRequest();
    }

    public static boolean isAjaxRequestWithPartialRendering(FacesContext context2) {
        PartialViewContext pvc = context2.getPartialViewContext();
        return pvc.isAjaxRequest() && !pvc.isRenderAll();
    }

    public static boolean isPostback(FacesContext context2) {
        return "POST".equalsIgnoreCase(FacesLocal.getRequest(context2).getMethod()) && context2.isPostback();
    }

    public static Map<String, String> getRequestParameterMap(FacesContext context2) {
        return context2.getExternalContext().getRequestParameterMap();
    }

    public static Map<String, List<String>> getMutableRequestParameterMap(FacesContext context2) {
        return Servlets.getMutableRequestParameterMap(FacesLocal.getRequest(context2));
    }

    public static String getRequestParameter(FacesContext context2, String name) {
        return FacesLocal.getRequestParameterMap(context2).get(name);
    }

    public static <T> T getRequestParameter(FacesContext context2, String name, Class<T> type) {
        return (T)FacesLocal.getRequestParameter(context2, name, (String value) -> Optional.ofNullable(FacesLocal.createConverter(context2, type)).map(c -> c.getAsObject(context2, (UIComponent)context2.getViewRoot(), value)).orElse(value));
    }

    public static <T> T getRequestParameter(FacesContext context2, String name, Function<String, T> converter) {
        return (T)FacesLocal.getRequestParameter(context2, name, converter, () -> null);
    }

    public static <T> T getRequestParameter(FacesContext context2, String name, Function<String, T> converter, Supplier<T> defaultValue) {
        return Optional.ofNullable(FacesLocal.getRequestParameter(context2, name)).filter(value -> !Utils.isEmpty(value)).map(converter).orElseGet(defaultValue);
    }

    public static Map<String, String[]> getRequestParameterValuesMap(FacesContext context2) {
        return context2.getExternalContext().getRequestParameterValuesMap();
    }

    public static String[] getRequestParameterValues(FacesContext context2, String name) {
        return FacesLocal.getRequestParameterValuesMap(context2).get(name);
    }

    public static <T> T[] getRequestParameterValues(FacesContext context2, String name, Class<T> type) {
        String[] values = FacesLocal.getRequestParameterValues(context2, name);
        if (values == null) {
            return null;
        }
        Converter<T> converter = FacesLocal.createConverter(context2, type);
        if (converter == null) {
            return values;
        }
        Object convertedValues = Array.newInstance(type, values.length);
        for (int i = 0; i < values.length; ++i) {
            Array.set(convertedValues, i, converter.getAsObject(context2, (UIComponent)context2.getViewRoot(), values[i]));
        }
        return (Object[])convertedValues;
    }

    public static Collection<Part> getRequestParts(FacesContext context2) {
        try {
            return FacesLocal.getRequest(context2).getParts();
        }
        catch (IOException | ServletException e2) {
            throw new FacesException(e2);
        }
    }

    public static Part getRequestPart(FacesContext context2, String name) {
        try {
            return FacesLocal.getRequest(context2).getPart(name);
        }
        catch (IOException | ServletException e2) {
            throw new FacesException(e2);
        }
    }

    public static Collection<Part> getRequestParts(FacesContext context2, String name) {
        try {
            ArrayList<Part> parts = new ArrayList<Part>();
            for (Part part : FacesLocal.getRequest(context2).getParts()) {
                if (!name.equals(part.getName())) continue;
                parts.add(part);
            }
            return Collections.unmodifiableList(parts);
        }
        catch (IOException | ServletException e2) {
            throw new FacesException(e2);
        }
    }

    public static Map<String, String> getRequestHeaderMap(FacesContext context2) {
        return context2.getExternalContext().getRequestHeaderMap();
    }

    public static Map<String, List<String>> getMutableRequestHeaderMap(FacesContext context2) {
        return Servlets.getMutableRequestHeaderMap(FacesLocal.getRequest(context2));
    }

    public static String getRequestHeader(FacesContext context2, String name) {
        return FacesLocal.getRequestHeaderMap(context2).get(name);
    }

    public static Map<String, String[]> getRequestHeaderValuesMap(FacesContext context2) {
        return context2.getExternalContext().getRequestHeaderValuesMap();
    }

    public static String[] getRequestHeaderValues(FacesContext context2, String name) {
        return FacesLocal.getRequestHeaderValuesMap(context2).get(name);
    }

    public static String getRequestContextPath(FacesContext context2) {
        return context2.getExternalContext().getRequestContextPath();
    }

    public static String getRequestServletPath(FacesContext context2) {
        return context2.getExternalContext().getRequestServletPath();
    }

    public static String getRequestPathInfo(FacesContext context2) {
        return Servlets.getRequestPathInfo(FacesLocal.getRequest(context2));
    }

    public static String getRequestHostname(FacesContext context2) {
        return Servlets.getRequestHostname(FacesLocal.getRequest(context2));
    }

    public static String getRequestBaseURL(FacesContext context2) {
        return Servlets.getRequestBaseURL(FacesLocal.getRequest(context2));
    }

    public static String getRequestDomainURL(FacesContext context2) {
        return Servlets.getRequestDomainURL(FacesLocal.getRequest(context2));
    }

    public static String getRequestURL(FacesContext context2) {
        return Servlets.getRequestURL(FacesLocal.getRequest(context2));
    }

    public static String getRequestURI(FacesContext context2) {
        return Servlets.getRequestURI(FacesLocal.getRequest(context2));
    }

    public static String getRequestQueryString(FacesContext context2) {
        return Servlets.getRequestQueryString(FacesLocal.getRequest(context2));
    }

    public static Map<String, List<String>> getRequestQueryStringMap(FacesContext context2) {
        return Servlets.getRequestQueryStringMap(FacesLocal.getRequest(context2));
    }

    public static String getRequestURLWithQueryString(FacesContext context2) {
        return Servlets.getRequestURLWithQueryString(FacesLocal.getRequest(context2));
    }

    public static String getRequestURIWithQueryString(FacesContext context2) {
        return Servlets.getRequestURIWithQueryString(FacesLocal.getRequest(context2));
    }

    public static String getRemoteAddr(FacesContext context2) {
        return Servlets.getRemoteAddr(FacesLocal.getRequest(context2));
    }

    public static String getUserAgent(FacesContext context2) {
        return Servlets.getUserAgent(FacesLocal.getRequest(context2));
    }

    public static String getReferrer(FacesContext context2) {
        return Servlets.getReferrer(FacesLocal.getRequest(context2));
    }

    public static boolean isRequestSecure(FacesContext context2) {
        return Servlets.isSecure(FacesLocal.getRequest(context2));
    }

    public static HttpServletResponse getResponse(FacesContext context2) {
        return (HttpServletResponse)context2.getExternalContext().getResponse();
    }

    public static int getResponseBufferSize(FacesContext context2) {
        return context2.getExternalContext().getResponseBufferSize();
    }

    public static String getResponseCharacterEncoding(FacesContext context2) {
        return context2.getExternalContext().getResponseCharacterEncoding();
    }

    public static void setResponseStatus(FacesContext context2, int status) {
        context2.getExternalContext().setResponseStatus(status);
    }

    public static void redirect(FacesContext context2, String url, Object ... paramValues) {
        ExternalContext externalContext = context2.getExternalContext();
        externalContext.getFlash().setRedirect(true);
        externalContext.getFlash().keep("org.omnifaces.view_expired");
        try {
            externalContext.redirect(Servlets.prepareRedirectURL(FacesLocal.getRequest(context2), url, paramValues));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    public static void redirectPermanent(FacesContext context2, String url, Object ... paramValues) {
        context2.getExternalContext().getFlash().setRedirect(true);
        Servlets.redirectPermanent(FacesLocal.getResponse(context2), Servlets.prepareRedirectURL(FacesLocal.getRequest(context2), url, paramValues));
        context2.responseComplete();
    }

    public static void refresh(FacesContext context2) {
        FacesLocal.redirect(context2, FacesLocal.getRequestURI(context2), new Object[0]);
    }

    public static void refreshWithQueryString(FacesContext context2) {
        FacesLocal.redirect(context2, FacesLocal.getRequestURIWithQueryString(context2), new Object[0]);
    }

    public static void responseSendError(FacesContext context2, int status, String message) {
        try {
            context2.getExternalContext().responseSendError(status, message);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        context2.responseComplete();
        if (!Faces.hasContext()) {
            Faces.setContext(context2);
        }
    }

    public static void addResponseHeader(FacesContext context2, String name, String value) {
        context2.getExternalContext().addResponseHeader(name, value);
    }

    public static boolean isResponseCommitted(FacesContext context2) {
        return context2.getExternalContext().isResponseCommitted();
    }

    public static void responseReset(FacesContext context2) {
        context2.getExternalContext().responseReset();
    }

    public static boolean isRenderResponse(FacesContext context2) {
        return context2.getCurrentPhaseId() == PhaseId.RENDER_RESPONSE;
    }

    public static void login(FacesContext context2, String username, String password) throws ServletException {
        FacesLocal.getRequest(context2).login(username, password);
    }

    public static boolean authenticate(FacesContext context2) throws ServletException {
        try {
            return FacesLocal.getRequest(context2).authenticate(FacesLocal.getResponse(context2));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    public static void logout(FacesContext context2) throws ServletException {
        FacesLocal.getRequest(context2).logout();
    }

    public static String getRemoteUser(FacesContext context2) {
        return context2.getExternalContext().getRemoteUser();
    }

    public static boolean isUserInRole(FacesContext context2, String role) {
        return context2.getExternalContext().isUserInRole(role);
    }

    public static String getRequestCookie(FacesContext context2, String name) {
        Cookie cookie = (Cookie)context2.getExternalContext().getRequestCookieMap().get(name);
        return cookie != null ? Utils.decodeURL(cookie.getValue()) : null;
    }

    public static void addResponseCookie(FacesContext context2, String name, String value, int maxAge) {
        FacesLocal.addResponseCookie(context2, name, value, null, null, maxAge);
    }

    public static void addResponseCookie(FacesContext context2, String name, String value, String path, int maxAge) {
        FacesLocal.addResponseCookie(context2, name, value, null, path, maxAge, true);
    }

    public static void addResponseCookie(FacesContext context2, String name, String value, String domain, String path, int maxAge) {
        FacesLocal.addResponseCookie(context2, name, value, domain, path, maxAge, true);
    }

    public static void addResponseCookie(FacesContext context2, String name, String value, String domain, String path, int maxAge, boolean httpOnly) {
        ExternalContext externalContext = context2.getExternalContext();
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (!"localhost".equals(domain)) {
            properties.put("domain", domain == null ? FacesLocal.getRequestHostname(context2) : domain);
        }
        if (path != null) {
            properties.put("path", path);
        }
        properties.put("maxAge", maxAge);
        properties.put("httpOnly", httpOnly);
        properties.put("secure", Servlets.isSecure((HttpServletRequest)externalContext.getRequest()));
        externalContext.addResponseCookie(name, Utils.encodeURL(value), properties);
    }

    public static void removeResponseCookie(FacesContext context2, String name, String path) {
        FacesLocal.addResponseCookie(context2, name, null, path, 0);
    }

    public static HttpSession getSession(FacesContext context2) {
        return FacesLocal.getSession(context2, true);
    }

    public static HttpSession getSession(FacesContext context2, boolean create) {
        return (HttpSession)context2.getExternalContext().getSession(create);
    }

    public static String getSessionId(FacesContext context2) {
        HttpSession session = FacesLocal.getSession(context2, false);
        return session != null ? session.getId() : null;
    }

    public static void invalidateSession(FacesContext context2) {
        context2.getExternalContext().invalidateSession();
    }

    public static boolean hasSession(FacesContext context2) {
        return FacesLocal.getSession(context2, false) != null;
    }

    public static boolean isSessionNew(FacesContext context2) {
        HttpSession session = FacesLocal.getSession(context2, false);
        return session != null && session.isNew();
    }

    public static boolean isRequestedSessionExpired(FacesContext context2) {
        HttpServletRequest request = FacesLocal.getRequest(context2);
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }

    public static long getSessionCreationTime(FacesContext context2) {
        return FacesLocal.getSession(context2).getCreationTime();
    }

    public static long getSessionLastAccessedTime(FacesContext context2) {
        return FacesLocal.getSession(context2).getLastAccessedTime();
    }

    public static int getSessionMaxInactiveInterval(FacesContext context2) {
        return FacesLocal.getSession(context2).getMaxInactiveInterval();
    }

    public static void setSessionMaxInactiveInterval(FacesContext context2, int seconds) {
        FacesLocal.getSession(context2).setMaxInactiveInterval(seconds);
    }

    public static boolean hasSessionTimedOut(FacesContext context2) {
        HttpServletRequest request = FacesLocal.getRequest(context2);
        return request.getRequestedSessionId() != null && !request.isRequestedSessionIdValid();
    }

    public static ServletContext getServletContext(FacesContext context2) {
        return (ServletContext)context2.getExternalContext().getContext();
    }

    public static Map<String, String> getInitParameterMap(FacesContext context2) {
        return context2.getExternalContext().getInitParameterMap();
    }

    public static String getInitParameter(FacesContext context2, String name) {
        return context2.getExternalContext().getInitParameter(name);
    }

    public static String getInitParameterOrDefault(FacesContext context2, String name, String defaultValue) {
        return context2.getExternalContext().getInitParameterMap().getOrDefault(name, defaultValue);
    }

    public static String getMimeType(FacesContext context2, String name) {
        String mimeType = context2.getExternalContext().getMimeType(name);
        if (mimeType == null) {
            mimeType = DEFAULT_MIME_TYPE;
        }
        return mimeType;
    }

    public static URL getResource(FacesContext context2, String path) throws MalformedURLException {
        return context2.getExternalContext().getResource(path);
    }

    public static InputStream getResourceAsStream(FacesContext context2, String path) {
        return context2.getExternalContext().getResourceAsStream(path);
    }

    public static Set<String> getResourcePaths(FacesContext context2, String path) {
        return context2.getExternalContext().getResourcePaths(path);
    }

    public static String getRealPath(FacesContext context2, String webContentPath) {
        return context2.getExternalContext().getRealPath(webContentPath);
    }

    public static Map<String, Object> getRequestMap(FacesContext context2) {
        return context2.getExternalContext().getRequestMap();
    }

    public static <T> T getRequestAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getRequestMap(context2).get(name);
    }

    public static <T> T getRequestAttribute(FacesContext context2, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getRequestAttribute(context2, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setRequestAttribute(context2, name, value);
        }
        return value;
    }

    public static void setRequestAttribute(FacesContext context2, String name, Object value) {
        FacesLocal.getRequestMap(context2).put(name, value);
    }

    public static <T> T removeRequestAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getRequestMap(context2).remove(name);
    }

    public static Flash getFlash(FacesContext context2) {
        return context2.getExternalContext().getFlash();
    }

    public static <T> T getFlashAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getFlash(context2).get((Object)name);
    }

    public static <T> T getFlashAttribute(FacesContext context2, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getFlashAttribute(context2, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setFlashAttribute(context2, name, value);
        }
        return value;
    }

    public static void setFlashAttribute(FacesContext context2, String name, Object value) {
        FacesLocal.getFlash(context2).put((Object)name, value);
    }

    public static <T> T removeFlashAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getFlash(context2).remove((Object)name);
    }

    public static Map<String, Object> getViewMap(FacesContext context2) {
        return context2.getViewRoot().getViewMap();
    }

    public static <T> T getViewAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getViewMap(context2).get(name);
    }

    public static <T> T getViewAttribute(FacesContext context2, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getViewAttribute(context2, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setViewAttribute(context2, name, value);
        }
        return value;
    }

    public static void setViewAttribute(FacesContext context2, String name, Object value) {
        FacesLocal.getViewMap(context2).put(name, value);
    }

    public static <T> T removeViewAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getViewMap(context2).remove(name);
    }

    public static Map<String, Object> getSessionMap(FacesContext context2) {
        return context2.getExternalContext().getSessionMap();
    }

    public static <T> T getSessionAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getSessionMap(context2).get(name);
    }

    public static <T> T getSessionAttribute(FacesContext context2, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getSessionAttribute(context2, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setSessionAttribute(context2, name, value);
        }
        return value;
    }

    public static void setSessionAttribute(FacesContext context2, String name, Object value) {
        FacesLocal.getSessionMap(context2).put(name, value);
    }

    public static <T> T removeSessionAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getSessionMap(context2).remove(name);
    }

    public static Map<String, Object> getApplicationMap(FacesContext context2) {
        return context2.getExternalContext().getApplicationMap();
    }

    public static <T> T getApplicationAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getApplicationMap(context2).get(name);
    }

    public static <T> T getApplicationAttribute(FacesContext context2, String name, Supplier<T> computeIfAbsent) {
        T value = FacesLocal.getApplicationAttribute(context2, name);
        if (value == null) {
            value = computeIfAbsent.get();
            FacesLocal.setApplicationAttribute(context2, name, value);
        }
        return value;
    }

    public static void setApplicationAttribute(FacesContext context2, String name, Object value) {
        FacesLocal.getApplicationMap(context2).put(name, value);
    }

    public static <T> T removeApplicationAttribute(FacesContext context2, String name) {
        return (T)FacesLocal.getApplicationMap(context2).remove(name);
    }

    public static void sendFile(FacesContext context2, File file, boolean attachment) throws IOException {
        FacesLocal.sendFile(context2, new FileInputStream(file), file.getName(), file.length(), attachment);
    }

    public static void sendFile(FacesContext context2, File file, String filename, boolean attachment) throws IOException {
        FacesLocal.sendFile(context2, new FileInputStream(file), filename, file.length(), attachment);
    }

    public static void sendFile(FacesContext context2, Path path, boolean attachment) throws IOException {
        FacesLocal.sendFile(context2, path.toFile(), attachment);
    }

    public static void sendFile(FacesContext context2, Path path, String filename, boolean attachment) throws IOException {
        FacesLocal.sendFile(context2, path.toFile(), filename, attachment);
    }

    public static void sendFile(FacesContext context2, byte[] content, String filename, boolean attachment) {
        FacesLocal.sendFile(context2, new ByteArrayInputStream(content), filename, content.length, attachment);
    }

    public static void sendFile(FacesContext context2, InputStream content, String filename, boolean attachment) {
        FacesLocal.sendFile(context2, content, filename, -1L, attachment);
    }

    public static void sendFile(FacesContext context2, String filename, boolean attachment, Callback.Output outputCallback) {
        ExternalContext externalContext = context2.getExternalContext();
        externalContext.setResponseBufferSize(10240);
        externalContext.setResponseContentType(FacesLocal.getMimeType(context2, filename));
        externalContext.setResponseHeader("Content-Disposition", Servlets.formatContentDispositionHeader(filename, attachment));
        if (Servlets.isSecure((HttpServletRequest)externalContext.getRequest())) {
            externalContext.setResponseHeader("Cache-Control", "public");
            externalContext.setResponseHeader("Pragma", "public");
        }
        try (OutputStream output = externalContext.getResponseOutputStream();){
            outputCallback.writeTo(output);
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
        context2.responseComplete();
    }

    private static void sendFile(FacesContext context2, InputStream input, String filename, long contentLength, boolean attachment) {
        FacesLocal.sendFile(context2, filename, attachment, output -> {
            ExternalContext externalContext = context2.getExternalContext();
            if (contentLength != -1L) {
                externalContext.setResponseHeader("Content-Length", String.valueOf(contentLength));
            }
            long size = Utils.stream(input, output);
            if (contentLength == -1L && !externalContext.isResponseCommitted()) {
                externalContext.setResponseHeader("Content-Length", String.valueOf(size));
            }
        });
    }
}

