/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.faces.application.ResourceHandler;
import javax.faces.application.ViewResource;
import javax.faces.context.FacesContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.omnifaces.resourcehandler.DefaultResourceHandler;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Platform;
import org.omnifaces.util.Utils;

public class ViewResourceHandler
extends DefaultResourceHandler {
    public static final String PARAM_NAME_VIEW_RESOURCES = "org.omnifaces.VIEW_RESOURCE_HANDLER_URIS";
    private static final String ERROR_MISSING_FORWARD_SLASH = "View resource '%s' must start with a forward slash '/'.";
    private static final String ERROR_UNKNOWN_VIEW_RESOURCE = "View resource '%s' does not exist.";
    private static final Set<String> VIEW_RESOURCES = new HashSet<String>();
    private static final ViewResource VIEW_RESOURCE = new ViewResource(){

        public URL getURL() {
            try {
                FacesContext context2 = Faces.getContext();
                return FacesLocal.getResource(context2, FacesLocal.getRequestServletPath(context2));
            }
            catch (MalformedURLException e2) {
                throw new IllegalStateException(e2);
            }
        }
    };

    public static void addFacesServletMappingsIfNecessary(ServletContext servletContext) throws MalformedURLException {
        String viewResourcesParam = servletContext.getInitParameter(PARAM_NAME_VIEW_RESOURCES);
        if (Utils.isEmpty(viewResourcesParam)) {
            return;
        }
        ServletRegistration facesServletRegistration = Platform.getFacesServletRegistration(servletContext);
        if (facesServletRegistration != null) {
            Collection existingMappings = facesServletRegistration.getMappings();
            for (String viewResource : viewResourcesParam.split("\\s*,\\s*")) {
                if (!viewResource.startsWith("/")) {
                    throw new IllegalArgumentException(String.format(ERROR_MISSING_FORWARD_SLASH, viewResource));
                }
                if (servletContext.getResource(viewResource) == null) {
                    throw new IllegalArgumentException(String.format(ERROR_UNKNOWN_VIEW_RESOURCE, viewResource));
                }
                VIEW_RESOURCES.add(viewResource);
                if (existingMappings.contains(viewResource)) continue;
                facesServletRegistration.addMapping(new String[]{viewResource});
            }
        }
    }

    public static boolean isViewResourceRequest(FacesContext context2) {
        return !VIEW_RESOURCES.isEmpty() && FacesLocal.getContextAttribute(context2, ViewResourceHandler.class.getName(), () -> FacesLocal.getRequest(context2) != null && VIEW_RESOURCES.contains(FacesLocal.getRequest(context2).getServletPath())) != false;
    }

    public ViewResourceHandler(ResourceHandler wrapped) {
        super(wrapped);
    }

    public ViewResource createViewResource(FacesContext context2, String resourceName) {
        if (ViewResourceHandler.isViewResourceRequest(context2)) {
            return VIEW_RESOURCE;
        }
        return super.createViewResource(context2, resourceName);
    }
}

