/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.renderer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;
import javax.faces.render.Renderer;
import org.omnifaces.component.messages.OmniMessages;
import org.omnifaces.util.Components;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Renderers;
import org.omnifaces.util.Utils;

@FacesRenderer(componentFamily="javax.faces.Messages", rendererType="org.omnifaces.Messages")
public class MessagesRenderer
extends Renderer {
    public static final String RENDERER_TYPE = "org.omnifaces.Messages";
    private static final String LAYOUT_TABLE = "table";
    private static final Map<FacesMessage.Severity, String> SEVERITY_NAMES = MessagesRenderer.createSeverityNames();

    private static Map<FacesMessage.Severity, String> createSeverityNames() {
        HashMap<FacesMessage.Severity, String> severityNames = new HashMap<FacesMessage.Severity, String>();
        severityNames.put(FacesMessage.SEVERITY_INFO, "info");
        severityNames.put(FacesMessage.SEVERITY_WARN, "warn");
        severityNames.put(FacesMessage.SEVERITY_ERROR, "error");
        severityNames.put(FacesMessage.SEVERITY_FATAL, "fatal");
        return Collections.unmodifiableMap(severityNames);
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context2, UIComponent component) throws IOException {
        if (!component.isRendered()) {
            return;
        }
        OmniMessages omniMessages = (OmniMessages)component;
        List<FacesMessage> messages = this.getMessages(context2, omniMessages);
        if (!Utils.isEmpty(omniMessages.getVar()) && omniMessages.getChildCount() > 0) {
            this.encodeMessagesRepeater(context2, omniMessages, messages);
        } else if (messages.isEmpty()) {
            this.encodeEmptyMessages(context2, omniMessages);
        } else {
            String message = omniMessages.getMessage();
            if (!Utils.isEmpty(message)) {
                messages = Arrays.asList(Messages.createInfo(message, new Object[0]));
            }
            this.encodeMessages(context2, omniMessages, messages, LAYOUT_TABLE.equals(omniMessages.getLayout()));
        }
    }

    protected List<FacesMessage> getMessages(FacesContext context2, OmniMessages component) {
        String forClientIds = component.getFor();
        if (forClientIds == null) {
            return component.isGlobalOnly() ? context2.getMessageList(null) : context2.getMessageList();
        }
        ArrayList<FacesMessage> messages = new ArrayList<FacesMessage>();
        for (String forClientId : forClientIds.split("\\s+")) {
            UIComponent forComponent = component.findComponent(forClientId);
            if (forComponent == null) continue;
            messages.addAll(context2.getMessageList(forComponent.getClientId(context2)));
            if (forComponent instanceof UIInput) continue;
            Components.forEachComponent(context2).fromRoot(forComponent).ofTypes(UIInput.class).invoke(input -> messages.addAll(context2.getMessageList(input.getClientId(context2))));
        }
        return messages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void encodeMessagesRepeater(FacesContext context2, OmniMessages component, List<FacesMessage> messages) throws IOException {
        String var = component.getVar();
        Map requestMap = context2.getExternalContext().getRequestMap();
        Object originalVar = requestMap.get(var);
        try {
            for (FacesMessage message : messages) {
                if (message.isRendered() && !component.isRedisplay()) continue;
                requestMap.put(var, message);
                for (UIComponent child : component.getChildren()) {
                    child.encodeAll(context2);
                }
                message.rendered();
            }
        }
        finally {
            if (originalVar != null) {
                requestMap.put(var, originalVar);
            } else {
                requestMap.remove(var);
            }
        }
    }

    protected void encodeEmptyMessages(FacesContext context2, OmniMessages component) throws IOException {
        String id = component.getId();
        if (!Utils.isOneOf(id, null, "javax_faces_developmentstage_messages")) {
            ResponseWriter writer = context2.getResponseWriter();
            writer.startElement("div", (UIComponent)component);
            Renderers.writeAttribute(writer, "id", (Object)component.getClientId(context2));
            Renderers.writeAttribute(writer, (UIComponent)component, "styleClass", "class");
            writer.endElement("div");
        }
    }

    protected void encodeMessages(FacesContext context2, OmniMessages component, List<FacesMessage> messages, boolean table) throws IOException {
        ResponseWriter writer = context2.getResponseWriter();
        writer.startElement(table ? LAYOUT_TABLE : "ul", (UIComponent)component);
        Renderers.writeAttribute(writer, "id", (Object)component.getClientId(context2));
        Renderers.writeAttribute(writer, (UIComponent)component, "styleClass", "class");
        Renderers.writeAttributes(writer, (UIComponent)component, "style", "title", "lang", "dir");
        for (FacesMessage message : messages) {
            if (message.isRendered() && !component.isRedisplay()) continue;
            this.encodeMessage(context2, component, message, table);
            message.rendered();
        }
        writer.endElement(table ? LAYOUT_TABLE : "ul");
    }

    protected void encodeMessage(FacesContext context2, OmniMessages component, FacesMessage message, boolean table) throws IOException {
        ResponseWriter writer = context2.getResponseWriter();
        writer.startElement(table ? "tr" : "li", (UIComponent)component);
        String severityName = SEVERITY_NAMES.get(message.getSeverity());
        Renderers.writeAttribute(writer, (UIComponent)component, severityName + "Style", "style");
        Renderers.writeAttribute(writer, (UIComponent)component, severityName + "Class", "class", "styleClass");
        if (table) {
            writer.startElement("td", (UIComponent)component);
        }
        String summary = Utils.coalesce(message.getSummary(), "");
        String detail = Utils.coalesce(message.getDetail(), summary);
        if (component.isTooltip() && Utils.isEmpty(component.getTitle())) {
            Renderers.writeAttribute(writer, "title", (Object)detail);
        }
        if (component.isShowSummary()) {
            Renderers.writeText(writer, (UIComponent)component, summary, component.isEscape());
            if (component.isShowDetail()) {
                writer.write(" ");
            }
        }
        if (component.isShowDetail()) {
            Renderers.writeText(writer, (UIComponent)component, detail, component.isEscape());
        }
        if (table) {
            writer.endElement("td");
        }
        writer.endElement(table ? "tr" : "li");
    }
}

