/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitHint;
import javax.faces.context.FacesContext;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.event.PreRenderViewEvent;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import org.omnifaces.cdi.push.Socket;
import org.omnifaces.cdi.push.SocketChannelManager;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;

public class SocketFacesListener
implements SystemEventListener {
    private static final String SCRIPT_OPEN = "OmniFaces.Push.open('%s');";
    private static final String SCRIPT_CLOSE = "OmniFaces.Push.close('%s');";

    public boolean isListenerForSource(Object source) {
        return source instanceof UIViewRoot;
    }

    public void processEvent(SystemEvent event) {
        if (!(event instanceof PreRenderViewEvent)) {
            return;
        }
        FacesContext context2 = FacesContext.getCurrentInstance();
        Map<String, Map.Entry<Serializable, Boolean>> sockets = SocketFacesListener.getSockets(context2);
        if (!FacesLocal.isAjaxRequest(context2)) {
            sockets.clear();
        }
        Components.forEachComponent(context2).ofTypes(Socket.class).withHints(VisitHint.SKIP_ITERATION).invoke(socket -> {
            boolean previouslyConnected;
            if (!sockets.containsKey(socket.getChannel())) {
                return;
            }
            boolean connected = socket.isRendered() && socket.isConnected();
            if (connected != (previouslyConnected = ((Map.Entry)sockets.get(socket.getChannel())).setValue(connected).booleanValue())) {
                Components.addScript(String.format(connected ? SCRIPT_OPEN : SCRIPT_CLOSE, socket.getChannel()));
            }
        });
    }

    static void subscribeIfNecessary() {
        UIViewRoot view = Faces.getViewRoot();
        List listeners = view.getListenersForEventClass(PostAddToViewEvent.class);
        if (listeners != null) {
            for (SystemEventListener listener : listeners) {
                if (!(listener instanceof SocketFacesListener)) continue;
                return;
            }
        }
        view.subscribeToViewEvent(PreRenderViewEvent.class, (SystemEventListener)new SocketFacesListener());
    }

    static boolean register(FacesContext context2, Socket socket) {
        AbstractMap.SimpleEntry<Serializable, Boolean> currentlyConnectedUser = new AbstractMap.SimpleEntry<Serializable, Boolean>(socket.getUser(), socket.isConnected());
        Map.Entry previouslyConnectedUser = SocketFacesListener.getSockets(context2).put(socket.getChannel(), currentlyConnectedUser);
        if (previouslyConnectedUser != null && !Objects.equals(previouslyConnectedUser.getKey(), socket.getUser())) {
            SocketChannelManager.getInstance().switchUser(socket.getChannel(), socket.getScope(), (Serializable)previouslyConnectedUser.getKey(), socket.getUser());
        }
        return previouslyConnectedUser == null;
    }

    private static Map<String, Map.Entry<Serializable, Boolean>> getSockets(FacesContext context2) {
        return FacesLocal.getViewAttribute(context2, Socket.class.getName(), () -> new HashMap(3));
    }
}

