/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.PassivationCapable;
import org.omnifaces.util.Beans;

public class BeanStorage
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ConcurrentHashMap<String, Serializable> beans;

    public BeanStorage(int initialCapacity) {
        this.beans = new ConcurrentHashMap(initialCapacity);
    }

    public <T> T createBean(Contextual<T> type, CreationalContext<T> context2) {
        Object bean = type.create(context2);
        this.beans.put(BeanStorage.getBeanId(type), (Serializable)bean);
        return (T)bean;
    }

    public <T> T getBean(Contextual<T> type) {
        return (T)this.beans.get(BeanStorage.getBeanId(type));
    }

    private static String getBeanId(Contextual<?> type) {
        return type instanceof PassivationCapable ? ((PassivationCapable)type).getId() : type.getClass().getName();
    }

    public synchronized void destroyBeans() {
        for (Serializable bean : this.beans.values()) {
            Beans.destroy(bean);
        }
        this.beans.clear();
    }
}

