/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces;

import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Application;
import javax.faces.application.ResourceHandler;
import javax.faces.event.SystemEvent;
import javax.faces.event.SystemEventListener;
import javax.servlet.ServletContext;
import org.omnifaces.component.search.MessagesKeywordResolver;
import org.omnifaces.config.FacesConfigXml;
import org.omnifaces.config.OmniFaces;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.util.Faces;

public class ApplicationProcessor
implements SystemEventListener {
    private static final Logger logger = Logger.getLogger(ApplicationProcessor.class.getName());
    private static final String ERROR_DUPLICATE_RESOURCE_HANDLER = "Resource handler %s is duplicated. This will result in erratic resource handling behavior. Please check if your build is clean and does not contain duplicate libraries having same resource handler. Also check if the same resource handler is not declared multiple times in all your faces-config.xml files combined.";

    public boolean isListenerForSource(Object source) {
        return source instanceof Application;
    }

    public void processEvent(SystemEvent event) {
        ServletContext servletContext = Faces.getServletContext();
        try {
            Application application = (Application)event.getSource();
            this.checkDuplicateResourceHandler();
            FacesViews.registerViewHandler(servletContext, application);
            MessagesKeywordResolver.register(application);
        }
        catch (Exception | LinkageError e2) {
            if (OmniFaces.skipDeploymentException(servletContext)) {
                logger.log(Level.WARNING, String.format("OmniFaces failed to initialize! %s", e2));
            }
            throw new IllegalStateException("OmniFaces failed to initialize! Report an issue to OmniFaces.", e2);
        }
    }

    private void checkDuplicateResourceHandler() {
        HashSet<Class<? extends ResourceHandler>> allResourceHandlers = new HashSet<Class<? extends ResourceHandler>>();
        for (Class<? extends ResourceHandler> resourceHandler : FacesConfigXml.instance().getResourceHandlers()) {
            if (allResourceHandlers.add(resourceHandler)) continue;
            throw new IllegalStateException(String.format(ERROR_DUPLICATE_RESOURCE_HANDLER, resourceHandler));
        }
    }
}

