/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.listeners;

import java.lang.annotation.Annotation;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.shiro.cdi.annotations.CipherKeySupplier;
import org.apache.shiro.config.Ini;
import org.apache.shiro.crypto.cipher.AesCipherService;
import org.apache.shiro.ee.filters.FormAuthenticationFilter;
import org.apache.shiro.ee.filters.LogoutFilter;
import org.apache.shiro.ee.filters.SslFilter;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.web.config.WebIniSecurityManagerFactory;
import org.apache.shiro.web.env.IniWebEnvironment;
import org.apache.shiro.web.filter.mgt.DefaultFilter;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Lazy;
import org.omnifaces.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IniEnvironment
extends IniWebEnvironment {
    private static final Logger log = LoggerFactory.getLogger(IniEnvironment.class);
    private String otherConfigLocation;

    public IniEnvironment() {
        this(DefaultWebSecurityManager::new);
    }

    public IniEnvironment(Function<Supplier<byte[]>, SecurityManager> securityManagerSupplier) {
        SecurityManagerFactory securityManagerFactory = new SecurityManagerFactory(securityManagerSupplier);
        securityManagerFactory.getReflectionBuilder().setAlternateObjectSupplier(Beans::getInstance);
        this.setSecurityManagerFactory(securityManagerFactory);
    }

    @Override
    public void setConfigLocations(String[] configLocations) {
        if (configLocations.length == 2) {
            this.otherConfigLocation = configLocations[1];
            super.setConfigLocations(configLocations[0]);
        } else {
            super.setConfigLocations(configLocations);
        }
    }

    @Override
    protected Ini getFrameworkIni() {
        if (this.otherConfigLocation != null) {
            return this.createIni(this.otherConfigLocation, true);
        }
        return super.getFrameworkIni();
    }

    private static final class SecurityManagerFactory
    extends WebIniSecurityManagerFactory {
        private final Function<Supplier<byte[]>, SecurityManager> securityManagerSupplier;
        private final Lazy<AesCipherService> cipherService = new Lazy(AesCipherService::new);

        @Override
        protected Map<String, ?> createDefaults(Ini ini, Ini.Section mainSection) {
            Map<String, ?> defaults = super.createDefaults(ini, mainSection);
            try {
                SslFilter sslFilter = new SslFilter();
                defaults.replace(DefaultFilter.authc.name(), new FormAuthenticationFilter());
                defaults.replace(DefaultFilter.ssl.name(), sslFilter);
                defaults.replace(DefaultFilter.logout.name(), new LogoutFilter());
            }
            catch (Throwable e2) {
                log.warn("unable to initialize filters", e2);
            }
            return defaults;
        }

        @Override
        protected SecurityManager createDefaultInstance() {
            return this.securityManagerSupplier.apply(this::generateCipherKey);
        }

        private byte[] generateCipherKey() {
            CipherKeySupplier cipherKeySupplier;
            CipherKeySupplier cipherKeySupplier2 = cipherKeySupplier = Beans.getManager() == null ? null : Beans.getReference(CipherKeySupplier.class, new Annotation[0]);
            if (cipherKeySupplier == null || Utils.isBlank((String)cipherKeySupplier.get())) {
                return this.cipherService.get().generateNewKey().getEncoded();
            }
            return ((String)cipherKeySupplier.get()).getBytes(StandardCharsets.UTF_8);
        }

        public SecurityManagerFactory(Function<Supplier<byte[]>, SecurityManager> securityManagerSupplier) {
            this.securityManagerSupplier = securityManagerSupplier;
        }
    }
}

