/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.ee.cdi;

import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.CDI;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.UnavailableSecurityManagerException;
import org.apache.shiro.ee.cdi.ShiroSessionScopeExtension;
import org.apache.shiro.ee.filters.FormResubmitSupport;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.session.Session;
import org.apache.shiro.web.mgt.WebSecurityManager;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.omnifaces.cdi.BeanStorage;
import org.omnifaces.cdi.ViewScoped;
import org.omnifaces.cdi.viewscope.ViewScopeManager;
import org.omnifaces.util.Beans;

public class ShiroScopeContext
implements Context,
Serializable {
    private static final String BEAN_STORAGE_KEY = "org.apache.shiro.ee.bean-storage";
    private static final long serialVersionUID = 1L;
    private final Class<? extends Annotation> scopeType;
    private final Class<? extends Annotation> webScopeType;
    private final boolean isViewScoped;

    public ShiroScopeContext(Class<? extends Annotation> scopeType, Class<? extends Annotation> webScopeType) {
        this.scopeType = scopeType;
        this.webScopeType = webScopeType;
        this.isViewScoped = webScopeType == jakarta.faces.view.ViewScoped.class || webScopeType == ViewScoped.class;
    }

    public Class<? extends Annotation> getScope() {
        return this.scopeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        if (ShiroScopeContext.isWebContainerSessions()) {
            Context ctx = CDI.current().getBeanManager().getContext(this.webScopeType);
            return (T)ctx.get(contextual, creationalContext);
        }
        Contextual<T> contextual2 = contextual;
        synchronized (contextual2) {
            if (this.isViewScoped) {
                return (T)Beans.getReference(ViewScopeManager.class, new Annotation[0]).createBean(contextual, creationalContext);
            }
            return (T)this.getBeanStorage(SecurityUtils.getSubject().getSession()).createBean(contextual, creationalContext);
        }
    }

    public <T> T get(Contextual<T> contextual) {
        if (ShiroScopeContext.isWebContainerSessions()) {
            Context ctx = CDI.current().getBeanManager().getContext(this.webScopeType);
            return (T)ctx.get(contextual);
        }
        if (this.isViewScoped) {
            return (T)Beans.getReference(ViewScopeManager.class, new Annotation[0]).getBean(contextual);
        }
        return (T)this.getBeanStorage(SecurityUtils.getSubject().getSession()).getBean(contextual);
    }

    public boolean isActive() {
        return true;
    }

    void onCreate(Session session) {
        session.setAttribute(BEAN_STORAGE_KEY, new BeanStorage(20));
    }

    void onDestroy(Session session) {
        this.getBeanStorage(session).destroyBeans();
    }

    public static boolean isWebContainerSessions(SecurityManager sm) {
        if (sm instanceof WebSecurityManager) {
            WebSecurityManager wsm = (WebSecurityManager)sm;
            return wsm.isHttpSessionMode();
        }
        return false;
    }

    public static void addScopeSessionListeners(WebSecurityManager wsm) {
        if (!ShiroScopeContext.isWebContainerSessions(wsm)) {
            DefaultWebSessionManager dsm = FormResubmitSupport.getNativeSessionManager(wsm);
            Beans.getReference(ShiroSessionScopeExtension.class, new Annotation[0]).addSessionListeners(dsm.getSessionListeners(), wsm);
        }
    }

    static boolean isWebContainerSessions() {
        try {
            return ShiroScopeContext.isWebContainerSessions(SecurityUtils.getSecurityManager());
        }
        catch (UnavailableSecurityManagerException unavailable) {
            return true;
        }
    }

    private BeanStorage getBeanStorage(Session session) {
        return (BeanStorage)session.getAttribute(BEAN_STORAGE_KEY);
    }
}

