/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import java.util.Objects;
import org.apache.lucene.store.ByteArrayDataOutput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.IntsRefBuilder;
import org.apache.lucene.util.fst.FST;
import org.apache.lucene.util.fst.FSTReader;
import org.apache.lucene.util.fst.GrowableByteArrayDataOutput;
import org.apache.lucene.util.fst.NodeHash;
import org.apache.lucene.util.fst.Outputs;
import org.apache.lucene.util.fst.ReadWriteDataOutput;

public class FSTCompiler<T> {
    static final float DIRECT_ADDRESSING_MAX_OVERSIZING_FACTOR = 1.0f;
    static final int FIXED_LENGTH_ARC_SHALLOW_DEPTH = 3;
    static final int FIXED_LENGTH_ARC_SHALLOW_NUM_ARCS = 5;
    static final int FIXED_LENGTH_ARC_DEEP_NUM_ARCS = 10;
    private static final float DIRECT_ADDRESSING_MAX_OVERSIZE_WITH_CREDIT_FACTOR = 1.66f;
    private static final FSTReader NULL_FST_READER = new NullFSTReader();
    private final NodeHash<T> dedupHash;
    final FST<T> fst;
    private final T NO_OUTPUT;
    private final IntsRefBuilder lastInput = new IntsRefBuilder();
    private boolean paddingBytePending;
    private UnCompiledNode<T>[] frontier;
    long lastFrozenNode;
    int[] numBytesPerArc = new int[4];
    int[] numLabelBytesPerArc = new int[this.numBytesPerArc.length];
    final FixedLengthArcsBuffer fixedLengthArcsBuffer = new FixedLengthArcsBuffer();
    long arcCount;
    long nodeCount;
    long binarySearchNodeCount;
    long directAddressingNodeCount;
    long continuousNodeCount;
    final boolean allowFixedLengthArcs;
    final float directAddressingMaxOversizingFactor;
    final int version;
    long directAddressingExpansionCredit;
    final DataOutput dataOutput;
    final GrowableByteArrayDataOutput scratchBytes = new GrowableByteArrayDataOutput();
    private long numBytesWritten;

    public static DataOutput getOnHeapReaderWriter(int blockBits) {
        return new ReadWriteDataOutput(blockBits);
    }

    private FSTCompiler(FST.INPUT_TYPE inputType, double suffixRAMLimitMB, Outputs<T> outputs, boolean allowFixedLengthArcs, DataOutput dataOutput, float directAddressingMaxOversizingFactor, int version2) {
        this.allowFixedLengthArcs = allowFixedLengthArcs;
        this.directAddressingMaxOversizingFactor = directAddressingMaxOversizingFactor;
        this.version = version2;
        ++this.numBytesWritten;
        this.paddingBytePending = true;
        this.dataOutput = dataOutput;
        this.fst = new FST<Object>(new FST.FSTMetadata<Object>(inputType, outputs, null, -1L, version2, 0L), NULL_FST_READER);
        if (suffixRAMLimitMB < 0.0) {
            throw new IllegalArgumentException("ramLimitMB must be >= 0; got: " + suffixRAMLimitMB);
        }
        this.dedupHash = suffixRAMLimitMB > 0.0 ? new NodeHash(this, suffixRAMLimitMB) : null;
        this.NO_OUTPUT = outputs.getNoOutput();
        UnCompiledNode[] f = new UnCompiledNode[10];
        this.frontier = f;
        for (int idx = 0; idx < this.frontier.length; ++idx) {
            this.frontier[idx] = new UnCompiledNode(this, idx);
        }
    }

    public FSTReader getFSTReader() {
        if (this.dataOutput instanceof FSTReader) {
            return (FSTReader)((Object)this.dataOutput);
        }
        throw new IllegalStateException("The DataOutput must implement FSTReader, but got " + this.dataOutput);
    }

    public float getDirectAddressingMaxOversizingFactor() {
        return this.directAddressingMaxOversizingFactor;
    }

    public long getNodeCount() {
        return 1L + this.nodeCount;
    }

    public long getArcCount() {
        return this.arcCount;
    }

    private CompiledNode compileNode(UnCompiledNode<T> nodeIn) throws IOException {
        long node;
        long bytesPosStart = this.numBytesWritten;
        if (this.dedupHash != null) {
            if (nodeIn.numArcs == 0) {
                this.lastFrozenNode = node = this.addNode(nodeIn);
            } else {
                node = this.dedupHash.add(nodeIn);
            }
        } else {
            node = this.addNode(nodeIn);
        }
        assert (node != -2L);
        long bytesPosEnd = this.numBytesWritten;
        if (bytesPosEnd != bytesPosStart) {
            assert (bytesPosEnd > bytesPosStart);
            this.lastFrozenNode = node;
        }
        nodeIn.clear();
        CompiledNode fn = new CompiledNode();
        fn.node = node;
        return fn;
    }

    long addNode(UnCompiledNode<T> nodeIn) throws IOException {
        if (nodeIn.numArcs == 0) {
            if (nodeIn.isFinal) {
                return -1L;
            }
            return 0L;
        }
        this.scratchBytes.setPosition(0);
        boolean doFixedLengthArcs = this.shouldExpandNodeWithFixedLengthArcs(nodeIn);
        if (doFixedLengthArcs && this.numBytesPerArc.length < nodeIn.numArcs) {
            this.numBytesPerArc = new int[ArrayUtil.oversize(nodeIn.numArcs, 4)];
            this.numLabelBytesPerArc = new int[this.numBytesPerArc.length];
        }
        this.arcCount += (long)nodeIn.numArcs;
        int lastArc = nodeIn.numArcs - 1;
        long lastArcStart = 0L;
        int maxBytesPerArc = 0;
        int maxBytesPerArcWithoutLabel = 0;
        for (int arcIdx = 0; arcIdx < nodeIn.numArcs; ++arcIdx) {
            int numArcBytes;
            boolean targetHasArcs;
            Arc arc = nodeIn.arcs[arcIdx];
            CompiledNode target = (CompiledNode)arc.target;
            int flags = 0;
            if (arcIdx == lastArc) {
                flags += 2;
            }
            if (this.lastFrozenNode == target.node && !doFixedLengthArcs) {
                flags += 4;
            }
            if (arc.isFinal) {
                ++flags;
                if (arc.nextFinalOutput != this.NO_OUTPUT) {
                    flags += 32;
                }
            } else assert (arc.nextFinalOutput == this.NO_OUTPUT);
            boolean bl = targetHasArcs = target.node > 0L;
            if (!targetHasArcs) {
                flags += 8;
            }
            if (arc.output != this.NO_OUTPUT) {
                flags += 16;
            }
            this.scratchBytes.writeByte((byte)flags);
            long labelStart = this.scratchBytes.getPosition();
            this.writeLabel(this.scratchBytes, arc.label);
            int numLabelBytes = (int)((long)this.scratchBytes.getPosition() - labelStart);
            if (arc.output != this.NO_OUTPUT) {
                this.fst.outputs.write(arc.output, this.scratchBytes);
            }
            if (arc.nextFinalOutput != this.NO_OUTPUT) {
                this.fst.outputs.writeFinalOutput(arc.nextFinalOutput, this.scratchBytes);
            }
            if (targetHasArcs && (flags & 4) == 0) {
                assert (target.node > 0L);
                this.scratchBytes.writeVLong(target.node);
            }
            if (!doFixedLengthArcs) continue;
            this.numBytesPerArc[arcIdx] = numArcBytes = (int)((long)this.scratchBytes.getPosition() - lastArcStart);
            this.numLabelBytesPerArc[arcIdx] = numLabelBytes;
            lastArcStart = this.scratchBytes.getPosition();
            maxBytesPerArc = Math.max(maxBytesPerArc, numArcBytes);
            maxBytesPerArcWithoutLabel = Math.max(maxBytesPerArcWithoutLabel, numArcBytes - numLabelBytes);
        }
        if (doFixedLengthArcs) {
            boolean continuousLabel;
            assert (maxBytesPerArc > 0);
            int labelRange = nodeIn.arcs[nodeIn.numArcs - 1].label - nodeIn.arcs[0].label + 1;
            assert (labelRange > 0);
            boolean bl = continuousLabel = labelRange == nodeIn.numArcs;
            if (continuousLabel && this.version >= 9) {
                this.writeNodeForDirectAddressingOrContinuous(nodeIn, maxBytesPerArcWithoutLabel, labelRange, true);
                ++this.continuousNodeCount;
            } else if (this.shouldExpandNodeWithDirectAddressing(nodeIn, maxBytesPerArc, maxBytesPerArcWithoutLabel, labelRange)) {
                this.writeNodeForDirectAddressingOrContinuous(nodeIn, maxBytesPerArcWithoutLabel, labelRange, false);
                ++this.directAddressingNodeCount;
            } else {
                this.writeNodeForBinarySearch(nodeIn, maxBytesPerArc);
                ++this.binarySearchNodeCount;
            }
        }
        this.reverseScratchBytes();
        if (this.paddingBytePending) {
            this.writePaddingByte();
        }
        this.scratchBytes.writeTo(this.dataOutput);
        this.numBytesWritten += (long)this.scratchBytes.getPosition();
        ++this.nodeCount;
        return this.numBytesWritten - 1L;
    }

    private void writePaddingByte() throws IOException {
        assert (this.paddingBytePending);
        this.dataOutput.writeByte((byte)0);
        this.paddingBytePending = false;
    }

    private void writeLabel(DataOutput out, int v) throws IOException {
        assert (v >= 0) : "v=" + v;
        if (this.fst.metadata.inputType == FST.INPUT_TYPE.BYTE1) {
            assert (v <= 255) : "v=" + v;
            out.writeByte((byte)v);
        } else if (this.fst.metadata.inputType == FST.INPUT_TYPE.BYTE2) {
            assert (v <= 65535) : "v=" + v;
            out.writeShort((short)v);
        } else {
            out.writeVInt(v);
        }
    }

    private boolean shouldExpandNodeWithFixedLengthArcs(UnCompiledNode<T> node) {
        return this.allowFixedLengthArcs && (node.depth <= 3 && node.numArcs >= 5 || node.numArcs >= 10);
    }

    private boolean shouldExpandNodeWithDirectAddressing(UnCompiledNode<T> nodeIn, int numBytesPerArc, int maxBytesPerArcWithoutLabel, int labelRange) {
        int allowedOversize;
        int sizeForBinarySearch = numBytesPerArc * nodeIn.numArcs;
        int sizeForDirectAddressing = FST.getNumPresenceBytes(labelRange) + this.numLabelBytesPerArc[0] + maxBytesPerArcWithoutLabel * nodeIn.numArcs;
        int expansionCost = sizeForDirectAddressing - (allowedOversize = (int)((float)sizeForBinarySearch * this.getDirectAddressingMaxOversizingFactor()));
        if (expansionCost <= 0 || this.directAddressingExpansionCredit >= (long)expansionCost && (float)sizeForDirectAddressing <= (float)allowedOversize * 1.66f) {
            this.directAddressingExpansionCredit -= (long)expansionCost;
            return true;
        }
        return false;
    }

    private void writeNodeForBinarySearch(UnCompiledNode<T> nodeIn, int maxBytesPerArc) {
        this.fixedLengthArcsBuffer.resetPosition().writeByte((byte)32).writeVInt(nodeIn.numArcs).writeVInt(maxBytesPerArc);
        int headerLen = this.fixedLengthArcsBuffer.getPosition();
        int srcPos = this.scratchBytes.getPosition();
        int destPos = headerLen + nodeIn.numArcs * maxBytesPerArc;
        assert (destPos >= srcPos);
        if (destPos > srcPos) {
            this.scratchBytes.setPosition(destPos);
            for (int arcIdx = nodeIn.numArcs - 1; arcIdx >= 0; --arcIdx) {
                int arcLen = this.numBytesPerArc[arcIdx];
                if ((srcPos -= arcLen) == (destPos -= maxBytesPerArc)) continue;
                assert (destPos > srcPos) : "destPos=" + destPos + " srcPos=" + srcPos + " arcIdx=" + arcIdx + " maxBytesPerArc=" + maxBytesPerArc + " arcLen=" + arcLen + " nodeIn.numArcs=" + nodeIn.numArcs;
                this.writeScratchBytes(destPos, this.scratchBytes.getBytes(), srcPos, arcLen);
            }
        }
        this.writeScratchBytes(0, this.fixedLengthArcsBuffer.getBytes(), 0, headerLen);
    }

    private void reverseScratchBytes() {
        int pos = this.scratchBytes.getPosition();
        byte[] bytes = this.scratchBytes.getBytes();
        int limit = pos / 2;
        for (int i = 0; i < limit; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[pos - 1 - i];
            bytes[pos - 1 - i] = b;
        }
    }

    private void writeScratchBytes(int destPos, byte[] bytes, int offset, int length) {
        assert (destPos + length <= this.scratchBytes.getPosition());
        System.arraycopy(bytes, offset, this.scratchBytes.getBytes(), destPos, length);
    }

    private void writeNodeForDirectAddressingOrContinuous(UnCompiledNode<T> nodeIn, int maxBytesPerArcWithoutLabel, int labelRange, boolean continuous) {
        int headerMaxLen = 11;
        int numPresenceBytes = continuous ? 0 : FST.getNumPresenceBytes(labelRange);
        int srcPos = this.scratchBytes.getPosition();
        int totalArcBytes = this.numLabelBytesPerArc[0] + nodeIn.numArcs * maxBytesPerArcWithoutLabel;
        int bufferOffset = headerMaxLen + numPresenceBytes + totalArcBytes;
        byte[] buffer = this.fixedLengthArcsBuffer.ensureCapacity(bufferOffset).getBytes();
        for (int arcIdx = nodeIn.numArcs - 1; arcIdx >= 0; --arcIdx) {
            int srcArcLen = this.numBytesPerArc[arcIdx];
            int labelLen = this.numLabelBytesPerArc[arcIdx];
            this.scratchBytes.writeTo(srcPos -= srcArcLen, buffer, bufferOffset -= maxBytesPerArcWithoutLabel, 1);
            int remainingArcLen = srcArcLen - 1 - labelLen;
            if (remainingArcLen != 0) {
                this.scratchBytes.writeTo(srcPos + 1 + labelLen, buffer, bufferOffset + 1, remainingArcLen);
            }
            if (arcIdx != 0) continue;
            this.scratchBytes.writeTo(srcPos + 1, buffer, bufferOffset -= labelLen, labelLen);
        }
        assert (bufferOffset == headerMaxLen + numPresenceBytes);
        this.fixedLengthArcsBuffer.resetPosition().writeByte(continuous ? (byte)96 : 64).writeVInt(labelRange).writeVInt(maxBytesPerArcWithoutLabel);
        int headerLen = this.fixedLengthArcsBuffer.getPosition();
        this.scratchBytes.setPosition(0);
        this.scratchBytes.writeBytes(this.fixedLengthArcsBuffer.getBytes(), 0, headerLen);
        if (!continuous) {
            this.writePresenceBits(nodeIn);
            assert (this.scratchBytes.getPosition() == headerLen + numPresenceBytes);
        }
        this.scratchBytes.writeBytes(this.fixedLengthArcsBuffer.getBytes(), bufferOffset, totalArcBytes);
        assert (this.scratchBytes.getPosition() == headerLen + numPresenceBytes + totalArcBytes);
    }

    private void writePresenceBits(UnCompiledNode<T> nodeIn) {
        byte presenceBits = 1;
        int presenceIndex = 0;
        int previousLabel = nodeIn.arcs[0].label;
        for (int arcIdx = 1; arcIdx < nodeIn.numArcs; ++arcIdx) {
            int label = nodeIn.arcs[arcIdx].label;
            assert (label > previousLabel);
            presenceIndex += label - previousLabel;
            while (presenceIndex >= 8) {
                this.scratchBytes.writeByte(presenceBits);
                presenceBits = 0;
                presenceIndex -= 8;
            }
            presenceBits = (byte)(presenceBits | 1 << presenceIndex);
            previousLabel = label;
        }
        assert (presenceIndex == (nodeIn.arcs[nodeIn.numArcs - 1].label - nodeIn.arcs[0].label) % 8);
        assert (presenceBits != 0);
        assert ((presenceBits & 1 << presenceIndex) != 0);
        this.scratchBytes.writeByte(presenceBits);
    }

    private void freezeTail(int prefixLenPlus1) throws IOException {
        int downTo = Math.max(1, prefixLenPlus1);
        for (int idx = this.lastInput.length(); idx >= downTo; --idx) {
            UnCompiledNode<T> node = this.frontier[idx];
            UnCompiledNode parent = this.frontier[idx - 1];
            Object nextFinalOutput = node.output;
            boolean isFinal = node.isFinal || node.numArcs == 0;
            parent.replaceLast(this.lastInput.intAt(idx - 1), this.compileNode(node), nextFinalOutput, isFinal);
        }
    }

    public void add(IntsRef input, T output) throws IOException {
        int idx;
        if (output.equals(this.NO_OUTPUT)) {
            output = this.NO_OUTPUT;
        }
        assert (this.lastInput.length() == 0 || input.compareTo(this.lastInput.get()) >= 0) : "inputs are added out of order lastInput=" + this.lastInput.get() + " vs input=" + input;
        assert (this.validOutput(output));
        if (input.length == 0) {
            this.frontier[0].isFinal = true;
            this.setEmptyOutput(output);
            return;
        }
        int pos1 = 0;
        int pos2 = input.offset;
        int pos1Stop = Math.min(this.lastInput.length(), input.length);
        while (pos1 < pos1Stop && this.lastInput.intAt(pos1) == input.ints[pos2]) {
            ++pos1;
            ++pos2;
        }
        int prefixLenPlus1 = pos1 + 1;
        if (this.frontier.length < input.length + 1) {
            UnCompiledNode<T>[] next = ArrayUtil.grow(this.frontier, input.length + 1);
            for (idx = this.frontier.length; idx < next.length; ++idx) {
                next[idx] = new UnCompiledNode(this, idx);
            }
            this.frontier = next;
        }
        this.freezeTail(prefixLenPlus1);
        for (int idx2 = prefixLenPlus1; idx2 <= input.length; ++idx2) {
            this.frontier[idx2 - 1].addArc(input.ints[input.offset + idx2 - 1], this.frontier[idx2]);
        }
        UnCompiledNode<T> lastNode = this.frontier[input.length];
        if (this.lastInput.length() != input.length || prefixLenPlus1 != input.length + 1) {
            lastNode.isFinal = true;
            lastNode.output = this.NO_OUTPUT;
        }
        for (idx = 1; idx < prefixLenPlus1; ++idx) {
            T wordSuffix;
            T commonOutputPrefix;
            UnCompiledNode<T> node = this.frontier[idx];
            UnCompiledNode<T> parentNode = this.frontier[idx - 1];
            T lastOutput = parentNode.getLastOutput(input.ints[input.offset + idx - 1]);
            assert (this.validOutput(lastOutput));
            if (lastOutput != this.NO_OUTPUT) {
                commonOutputPrefix = this.fst.outputs.common(output, lastOutput);
                assert (this.validOutput(commonOutputPrefix));
                wordSuffix = this.fst.outputs.subtract(lastOutput, commonOutputPrefix);
                assert (this.validOutput(wordSuffix));
                parentNode.setLastOutput(input.ints[input.offset + idx - 1], commonOutputPrefix);
                node.prependOutput(wordSuffix);
            } else {
                commonOutputPrefix = wordSuffix = this.NO_OUTPUT;
            }
            output = this.fst.outputs.subtract(output, commonOutputPrefix);
            assert (this.validOutput(output));
        }
        if (this.lastInput.length() == input.length && prefixLenPlus1 == 1 + input.length) {
            lastNode.output = this.fst.outputs.merge(lastNode.output, output);
        } else {
            this.frontier[prefixLenPlus1 - 1].setLastOutput(input.ints[input.offset + prefixLenPlus1 - 1], output);
        }
        this.lastInput.copyInts(input);
    }

    void setEmptyOutput(T v) {
        this.fst.metadata.emptyOutput = this.fst.metadata.emptyOutput != null ? this.fst.outputs.merge(this.fst.metadata.emptyOutput, v) : v;
    }

    void finish(long newStartNode) {
        assert (newStartNode <= this.numBytesWritten);
        if (this.fst.metadata.startNode != -1L) {
            throw new IllegalStateException("already finished");
        }
        if (newStartNode == -1L && this.fst.metadata.emptyOutput != null) {
            newStartNode = 0L;
        }
        this.fst.metadata.startNode = newStartNode;
        this.fst.metadata.numBytes = this.numBytesWritten;
        if (this.dataOutput instanceof ReadWriteDataOutput) {
            ((ReadWriteDataOutput)this.dataOutput).freeze();
        }
    }

    private boolean validOutput(T output) {
        return output == this.NO_OUTPUT || !output.equals(this.NO_OUTPUT);
    }

    public FST.FSTMetadata<T> compile() throws IOException {
        UnCompiledNode<T> root2 = this.frontier[0];
        this.freezeTail(0);
        if (root2.numArcs == 0) {
            if (this.fst.metadata.emptyOutput == null) {
                return null;
            }
            this.writePaddingByte();
        }
        this.finish(this.compileNode(root2).node);
        return this.fst.metadata;
    }

    public long fstRamBytesUsed() {
        long ramBytesUsed = this.scratchBytes.ramBytesUsed();
        if (this.dataOutput instanceof Accountable) {
            ramBytesUsed += ((Accountable)((Object)this.dataOutput)).ramBytesUsed();
        }
        return ramBytesUsed;
    }

    public long fstSizeInBytes() {
        return this.numBytesWritten;
    }

    static class FixedLengthArcsBuffer {
        private byte[] bytes = new byte[11];
        private final ByteArrayDataOutput bado = new ByteArrayDataOutput(this.bytes);

        FixedLengthArcsBuffer() {
        }

        FixedLengthArcsBuffer ensureCapacity(int capacity) {
            if (this.bytes.length < capacity) {
                this.bytes = new byte[ArrayUtil.oversize(capacity, 1)];
                this.bado.reset(this.bytes);
            }
            return this;
        }

        FixedLengthArcsBuffer resetPosition() {
            this.bado.reset(this.bytes);
            return this;
        }

        FixedLengthArcsBuffer writeByte(byte b) {
            this.bado.writeByte(b);
            return this;
        }

        FixedLengthArcsBuffer writeVInt(int i) {
            try {
                this.bado.writeVInt(i);
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
            return this;
        }

        int getPosition() {
            return this.bado.getPosition();
        }

        byte[] getBytes() {
            return this.bytes;
        }
    }

    static final class UnCompiledNode<T>
    implements Node {
        final FSTCompiler<T> owner;
        int numArcs;
        Arc<T>[] arcs;
        T output;
        boolean isFinal;
        final int depth;

        UnCompiledNode(FSTCompiler<T> owner, int depth) {
            this.owner = owner;
            this.arcs = new Arc[1];
            this.arcs[0] = new Arc();
            this.output = owner.NO_OUTPUT;
            this.depth = depth;
        }

        @Override
        public boolean isCompiled() {
            return false;
        }

        void clear() {
            this.numArcs = 0;
            this.isFinal = false;
            this.output = this.owner.NO_OUTPUT;
        }

        T getLastOutput(int labelToMatch) {
            assert (this.numArcs > 0);
            assert (this.arcs[this.numArcs - 1].label == labelToMatch);
            return this.arcs[this.numArcs - 1].output;
        }

        void addArc(int label, Node target) {
            assert (label >= 0);
            assert (this.numArcs == 0 || label > this.arcs[this.numArcs - 1].label) : "arc[numArcs-1].label=" + this.arcs[this.numArcs - 1].label + " new label=" + label + " numArcs=" + this.numArcs;
            if (this.numArcs == this.arcs.length) {
                Arc<T>[] newArcs = ArrayUtil.grow(this.arcs);
                for (int arcIdx = this.numArcs; arcIdx < newArcs.length; ++arcIdx) {
                    newArcs[arcIdx] = new Arc();
                }
                this.arcs = newArcs;
            }
            Arc<T> arc = this.arcs[this.numArcs++];
            arc.label = label;
            arc.target = target;
            arc.nextFinalOutput = this.owner.NO_OUTPUT;
            arc.output = arc.nextFinalOutput;
            arc.isFinal = false;
        }

        void replaceLast(int labelToMatch, Node target, T nextFinalOutput, boolean isFinal) {
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == labelToMatch) : "arc.label=" + arc.label + " vs " + labelToMatch;
            arc.target = target;
            arc.nextFinalOutput = nextFinalOutput;
            arc.isFinal = isFinal;
        }

        void deleteLast(int label, Node target) {
            assert (this.numArcs > 0);
            assert (label == this.arcs[this.numArcs - 1].label);
            assert (target == this.arcs[this.numArcs - 1].target);
            --this.numArcs;
        }

        void setLastOutput(int labelToMatch, T newOutput) {
            assert (this.owner.validOutput(newOutput));
            assert (this.numArcs > 0);
            Arc<T> arc = this.arcs[this.numArcs - 1];
            assert (arc.label == labelToMatch);
            arc.output = newOutput;
        }

        void prependOutput(T outputPrefix) {
            assert (this.owner.validOutput(outputPrefix));
            for (int arcIdx = 0; arcIdx < this.numArcs; ++arcIdx) {
                this.arcs[arcIdx].output = this.owner.fst.outputs.add(outputPrefix, this.arcs[arcIdx].output);
                assert (this.owner.validOutput(this.arcs[arcIdx].output));
            }
            if (this.isFinal) {
                this.output = this.owner.fst.outputs.add(outputPrefix, this.output);
                assert (this.owner.validOutput(this.output));
            }
        }
    }

    static final class CompiledNode
    implements Node {
        long node;

        CompiledNode() {
        }

        @Override
        public boolean isCompiled() {
            return true;
        }
    }

    static interface Node {
        public boolean isCompiled();
    }

    static class Arc<T> {
        int label;
        Node target;
        boolean isFinal;
        T output;
        T nextFinalOutput;

        Arc() {
        }
    }

    public static class Builder<T> {
        private final FST.INPUT_TYPE inputType;
        private final Outputs<T> outputs;
        private double suffixRAMLimitMB = 32.0;
        private boolean allowFixedLengthArcs = true;
        private DataOutput dataOutput;
        private float directAddressingMaxOversizingFactor = 1.0f;
        private int version = 9;

        public Builder(FST.INPUT_TYPE inputType, Outputs<T> outputs) {
            this.inputType = inputType;
            this.outputs = outputs;
        }

        public Builder<T> suffixRAMLimitMB(double mb) {
            if (mb < 0.0) {
                throw new IllegalArgumentException("suffixRAMLimitMB must be >= 0; got: " + mb);
            }
            this.suffixRAMLimitMB = mb;
            return this;
        }

        public Builder<T> allowFixedLengthArcs(boolean allowFixedLengthArcs) {
            this.allowFixedLengthArcs = allowFixedLengthArcs;
            return this;
        }

        public Builder<T> dataOutput(DataOutput dataOutput) {
            this.dataOutput = Objects.requireNonNull(dataOutput, "DataOutput cannot be null");
            return this;
        }

        public Builder<T> directAddressingMaxOversizingFactor(float factor) {
            this.directAddressingMaxOversizingFactor = factor;
            return this;
        }

        public Builder<T> setVersion(int version2) {
            if (version2 < 8 || version2 > 9) {
                throw new IllegalArgumentException("Expected version in range [8, 9], got " + version2);
            }
            this.version = version2;
            return this;
        }

        public FSTCompiler<T> build() {
            if (this.dataOutput == null) {
                this.dataOutput = FSTCompiler.getOnHeapReaderWriter(15);
            }
            return new FSTCompiler<T>(this.inputType, this.suffixRAMLimitMB, this.outputs, this.allowFixedLengthArcs, this.dataOutput, this.directAddressingMaxOversizingFactor, this.version);
        }
    }

    private static final class NullFSTReader
    implements FSTReader {
        private NullFSTReader() {
        }

        @Override
        public long ramBytesUsed() {
            return 0L;
        }

        @Override
        public FST.BytesReader getReverseBytesReader() {
            throw new UnsupportedOperationException("FST was not constructed with getOnHeapReaderWriter()");
        }

        @Override
        public void writeTo(DataOutput out) {
            throw new UnsupportedOperationException("FST was not constructed with getOnHeapReaderWriter()");
        }
    }
}

