/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.algebra;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import org.apache.jena.atlas.lib.Lib;
import org.apache.jena.atlas.lib.Pair;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.ARQ;
import org.apache.jena.query.Query;
import org.apache.jena.query.SortCondition;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.algebra.Op;
import org.apache.jena.sparql.algebra.OpLib;
import org.apache.jena.sparql.algebra.Table;
import org.apache.jena.sparql.algebra.TableFactory;
import org.apache.jena.sparql.algebra.Transform;
import org.apache.jena.sparql.algebra.Transformer;
import org.apache.jena.sparql.algebra.op.OpAssign;
import org.apache.jena.sparql.algebra.op.OpBGP;
import org.apache.jena.sparql.algebra.op.OpDistinct;
import org.apache.jena.sparql.algebra.op.OpExtend;
import org.apache.jena.sparql.algebra.op.OpFilter;
import org.apache.jena.sparql.algebra.op.OpGraph;
import org.apache.jena.sparql.algebra.op.OpGroup;
import org.apache.jena.sparql.algebra.op.OpJoin;
import org.apache.jena.sparql.algebra.op.OpLateral;
import org.apache.jena.sparql.algebra.op.OpLeftJoin;
import org.apache.jena.sparql.algebra.op.OpList;
import org.apache.jena.sparql.algebra.op.OpMinus;
import org.apache.jena.sparql.algebra.op.OpNull;
import org.apache.jena.sparql.algebra.op.OpOrder;
import org.apache.jena.sparql.algebra.op.OpProject;
import org.apache.jena.sparql.algebra.op.OpReduced;
import org.apache.jena.sparql.algebra.op.OpSequence;
import org.apache.jena.sparql.algebra.op.OpService;
import org.apache.jena.sparql.algebra.op.OpSlice;
import org.apache.jena.sparql.algebra.op.OpTable;
import org.apache.jena.sparql.algebra.op.OpUnion;
import org.apache.jena.sparql.algebra.optimize.TransformSimplify;
import org.apache.jena.sparql.core.BasicPattern;
import org.apache.jena.sparql.core.PathBlock;
import org.apache.jena.sparql.core.TriplePath;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.core.VarExprList;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.expr.E_Exists;
import org.apache.jena.sparql.expr.E_NotExists;
import org.apache.jena.sparql.expr.Expr;
import org.apache.jena.sparql.expr.ExprLib;
import org.apache.jena.sparql.expr.ExprList;
import org.apache.jena.sparql.path.PathLib;
import org.apache.jena.sparql.syntax.Element;
import org.apache.jena.sparql.syntax.ElementAssign;
import org.apache.jena.sparql.syntax.ElementBind;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementExists;
import org.apache.jena.sparql.syntax.ElementFilter;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementLateral;
import org.apache.jena.sparql.syntax.ElementMinus;
import org.apache.jena.sparql.syntax.ElementNamedGraph;
import org.apache.jena.sparql.syntax.ElementNotExists;
import org.apache.jena.sparql.syntax.ElementOptional;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.sparql.syntax.ElementService;
import org.apache.jena.sparql.syntax.ElementSubQuery;
import org.apache.jena.sparql.syntax.ElementTriplesBlock;
import org.apache.jena.sparql.syntax.ElementUnion;
import org.apache.jena.sparql.util.Context;

public class AlgebraGenerator {
    private final Context context;
    private final int subQueryDepth;
    private static final boolean fixedFilterPosition = false;
    private static final boolean applySimplification = true;
    private static final boolean simplifyTooEarlyInAlgebraGeneration = false;
    protected static Transform simplify = new TransformSimplify();

    public AlgebraGenerator(Context context2) {
        this(context2 != null ? context2 : ARQ.getContext().copy(), 0);
    }

    public AlgebraGenerator() {
        this(null);
    }

    protected AlgebraGenerator(Context context2, int depth) {
        this.context = context2;
        this.subQueryDepth = depth;
    }

    public Op compile(Query query2) {
        Element el = query2.getQueryPattern();
        Op op = this.compile(el);
        op = this.compileModifiers(query2, op);
        return op;
    }

    public Op compile(Element elt) {
        Op op;
        Op op2 = op = this.compileElement(elt);
        if (simplify != null) {
            op2 = AlgebraGenerator.simplify(op);
        }
        return op2;
    }

    protected static Op simplify(Op op) {
        return Transformer.transform(simplify, op);
    }

    protected Op compileElement(Element elt) {
        if (elt == null) {
            return OpNull.create();
        }
        if (elt instanceof ElementGroup) {
            ElementGroup elt2 = (ElementGroup)elt;
            return this.compileElementGroup(elt2);
        }
        if (elt instanceof ElementUnion) {
            ElementUnion elt2 = (ElementUnion)elt;
            return this.compileElementUnion(elt2);
        }
        if (elt instanceof ElementNamedGraph) {
            ElementNamedGraph elt2 = (ElementNamedGraph)elt;
            return this.compileElementGraph(elt2);
        }
        if (elt instanceof ElementService) {
            ElementService elt2 = (ElementService)elt;
            return this.compileElementService(elt2);
        }
        if (elt instanceof ElementSubQuery) {
            ElementSubQuery elt2 = (ElementSubQuery)elt;
            return this.compileElementSubquery(elt2);
        }
        if (elt instanceof ElementTriplesBlock) {
            ElementTriplesBlock elt2 = (ElementTriplesBlock)elt;
            return this.compileBasicPattern(elt2.getPattern());
        }
        if (elt instanceof ElementPathBlock) {
            ElementPathBlock elt2 = (ElementPathBlock)elt;
            return this.compilePathBlock(elt2.getPattern());
        }
        if (elt instanceof ElementData) {
            ElementData elt2 = (ElementData)elt;
            return this.compileElementData(elt2);
        }
        if (elt instanceof ElementFilter) {
            ElementFilter elt2 = (ElementFilter)elt;
            return this.compileElementFilter(elt2);
        }
        if (elt instanceof ElementBind) {
            ElementBind elt2 = (ElementBind)elt;
            return this.compileElementBind(elt2);
        }
        if (elt instanceof ElementAssign) {
            ElementAssign elt2 = (ElementAssign)elt;
            return this.compileElementAssign(elt2);
        }
        if (elt instanceof ElementOptional) {
            ElementOptional elt2 = (ElementOptional)elt;
            return this.compileElementOptional(OpTable.unit(), elt2);
        }
        if (elt instanceof ElementMinus) {
            ElementMinus elt2 = (ElementMinus)elt;
            return this.compileElementMinus(OpTable.unit(), elt2);
        }
        return this.compileUnknownElement(elt, "compile(Element)/Not a structural element: " + Lib.className(elt));
    }

    protected Op compileUnknownElement(Element elt, String error) {
        this.broken(error);
        return null;
    }

    protected Op compileElementGroup(ElementGroup groupElt) {
        Pair<List<Expr>, List<Element>> pair = this.prepareGroup(groupElt);
        List<Expr> filters = pair.getLeft();
        List<Element> groupElts = pair.getRight();
        Op current = OpLib.unit();
        ArrayDeque<Op> acc = new ArrayDeque<Op>();
        for (Element elt : groupElts) {
            if (elt == null) continue;
            current = this.compileOneInGroup(elt, current, acc);
        }
        if (filters != null) {
            for (Expr expr : filters) {
                current = OpFilter.filter(expr, current);
            }
        }
        return current;
    }

    protected Pair<List<Expr>, List<Element>> prepareGroup(ElementGroup groupElt) {
        ArrayList<Object> groupElts = new ArrayList<Object>();
        PathBlock currentPathBlock = null;
        ArrayList<Expr> filters = null;
        for (Element elt : groupElt.getElements()) {
            Object etb2;
            if (elt instanceof ElementFilter) {
                ElementFilter f = (ElementFilter)elt;
                if (filters == null) {
                    filters = new ArrayList<Expr>();
                }
                filters.add(f.getExpr());
                continue;
            }
            if (elt instanceof ElementTriplesBlock) {
                ElementTriplesBlock etb = (ElementTriplesBlock)elt;
                if (currentPathBlock == null) {
                    etb2 = new ElementPathBlock();
                    currentPathBlock = ((ElementPathBlock)etb2).getPattern();
                    groupElts.add(etb2);
                }
                for (Triple t : etb.getPattern()) {
                    currentPathBlock.add(new TriplePath(t));
                }
                continue;
            }
            if (elt instanceof ElementPathBlock) {
                ElementPathBlock epb = (ElementPathBlock)elt;
                if (currentPathBlock == null) {
                    etb2 = new ElementPathBlock();
                    currentPathBlock = ((ElementPathBlock)etb2).getPattern();
                    groupElts.add(etb2);
                }
                currentPathBlock.addAll(epb.getPattern());
                continue;
            }
            currentPathBlock = null;
            groupElts.add(elt);
        }
        return Pair.create(filters, groupElts);
    }

    protected Op compileOneInGroup(Element elt, Op current, Deque<Op> acc) {
        if (elt instanceof ElementAssign) {
            ElementAssign assign2 = (ElementAssign)elt;
            return OpAssign.assign(current, assign2.getVar(), assign2.getExpr());
        }
        if (elt instanceof ElementBind) {
            ElementBind bind = (ElementBind)elt;
            return OpExtend.create(current, bind.getVar(), bind.getExpr());
        }
        if (elt instanceof ElementOptional) {
            ElementOptional eltOpt = (ElementOptional)elt;
            return this.compileElementOptional(current, eltOpt);
        }
        if (elt instanceof ElementLateral) {
            ElementLateral eltLateral = (ElementLateral)elt;
            return this.compileElementLateral(current, eltLateral);
        }
        if (elt instanceof ElementMinus) {
            ElementMinus elt2 = (ElementMinus)elt;
            return this.compileElementMinus(current, elt2);
        }
        if (elt instanceof ElementGroup || elt instanceof ElementNamedGraph || elt instanceof ElementService || elt instanceof ElementUnion || elt instanceof ElementSubQuery || elt instanceof ElementData || elt instanceof ElementTriplesBlock || elt instanceof ElementPathBlock) {
            Op op = this.compileElement(elt);
            return AlgebraGenerator.join(current, op);
        }
        if (elt instanceof ElementExists) {
            ElementExists elt2 = (ElementExists)elt;
            return this.compileElementExists(current, elt2);
        }
        if (elt instanceof ElementNotExists) {
            ElementNotExists elt2 = (ElementNotExists)elt;
            return this.compileElementNotExists(current, elt2);
        }
        if (elt instanceof ElementFilter) {
            ElementFilter ef = (ElementFilter)elt;
            return OpFilter.filter(ef.getExpr(), current);
        }
        return this.compileUnknownElement(elt, "compile/Element not recognized: " + Lib.className(elt));
    }

    protected Op compileElementUnion(ElementUnion el) {
        Op current = null;
        for (Element subElt : el.getElements()) {
            Op op = this.compileElement(subElt);
            current = this.union(current, op);
        }
        return current;
    }

    protected Op compileElementNotExists(Op current, ElementNotExists elt2) {
        Element subElt = elt2.getElement();
        Op op = this.compile(subElt);
        E_NotExists expr = new E_NotExists(subElt, op);
        return OpFilter.filter(expr, current);
    }

    protected Op compileElementExists(Op current, ElementExists elt2) {
        Element subElt = elt2.getElement();
        Op op = this.compile(subElt);
        E_Exists expr = new E_Exists(subElt, op);
        return OpFilter.filter(expr, current);
    }

    protected Op compileElementMinus(Op current, ElementMinus elt2) {
        Op op = this.compile(elt2.getMinusElement());
        Op opMinus = OpMinus.create(current, op);
        return opMinus;
    }

    protected Op compileElementData(ElementData elt) {
        return OpTable.create(elt.getTable());
    }

    protected Op compileElementUnion(Op current, ElementUnion elt2) {
        Op op = this.compile(elt2.getElements().get(0));
        Op opUnion = OpUnion.create(current, op);
        return opUnion;
    }

    protected Op compileElementOptional(Op current, ElementOptional eltOpt) {
        Element subElt = eltOpt.getOptionalElement();
        Op op = this.compileElement(subElt);
        ExprList exprs = null;
        if (op instanceof OpFilter) {
            OpFilter f = (OpFilter)op;
            Op sub = f.getSubOp();
            if (sub instanceof OpFilter) {
                this.broken("compile/Optional/nested filters - unfinished");
            }
            exprs = f.getExprs();
            op = sub;
        }
        current = OpLeftJoin.create(current, op, exprs);
        return current;
    }

    protected Op compileElementLateral(Op current, ElementLateral eltLateral) {
        Element subElt = eltLateral.getLateralElement();
        Op op = this.compileElement(subElt);
        return OpLateral.create(current, op);
    }

    protected Op compileBasicPattern(BasicPattern pattern) {
        return new OpBGP(pattern);
    }

    protected Op compilePathBlock(PathBlock pathBlock) {
        if (pathBlock.size() == 0) {
            return OpLib.unit();
        }
        return PathLib.pathToTriples(pathBlock);
    }

    protected Op compileElementGraph(ElementNamedGraph eltGraph) {
        Node graphNode = eltGraph.getGraphNameNode();
        Op sub = this.compileElement(eltGraph.getElement());
        return new OpGraph(graphNode, sub);
    }

    protected Op compileElementService(ElementService eltService) {
        Node serviceNode = eltService.getServiceNode();
        Op sub = this.compileElement(eltService.getElement());
        return new OpService(serviceNode, sub, eltService, eltService.getSilent());
    }

    protected Op compileElementSubquery(ElementSubQuery eltSubQuery) {
        AlgebraGenerator gen = new AlgebraGenerator(this.context, this.subQueryDepth + 1);
        return gen.compile(eltSubQuery.getQuery());
    }

    protected Op compileElementFilter(ElementFilter elt) {
        return OpFilter.filter(elt.getExpr(), OpTable.unit());
    }

    protected Op compileElementBind(ElementBind elt) {
        VarExprList varExpList = new VarExprList(elt.getVar(), elt.getExpr());
        return OpExtend.extend(OpTable.unit(), varExpList);
    }

    protected Op compileElementAssign(ElementAssign elt) {
        VarExprList varExpList = new VarExprList(elt.getVar(), elt.getExpr());
        return OpAssign.assign(OpTable.unit(), varExpList);
    }

    protected Op compileModifiers(Query query2, Op pattern) {
        VarExprList projectVars = query2.getProject();
        VarExprList exprs = new VarExprList();
        ArrayList<Var> vars = new ArrayList<Var>();
        Op op = pattern;
        if (query2.hasGroupBy()) {
            op = OpGroup.create(op, query2.getGroupBy(), query2.getAggregators());
        }
        if (!projectVars.isEmpty() && !query2.isQueryResultStar()) {
            if (projectVars.size() == 0 && query2.isSelectType()) {
                Log.warn(this, "No project variables");
            }
            for (Var var : query2.getProject().getVars()) {
                Expr e2 = query2.getProject().getExpr(var);
                if (e2 != null) {
                    Expr e22 = ExprLib.replaceAggregateByVariable(e2);
                    exprs.add(var, e22);
                }
                vars.add(var);
            }
        }
        for (Var var : exprs.getVars()) {
            Expr e2 = exprs.getExpr(var);
            op = OpExtend.create(op, var, e2);
        }
        if (query2.hasHaving()) {
            for (Expr expr : query2.getHavingExprs()) {
                Expr expr2 = ExprLib.replaceAggregateByVariable(expr);
                op = OpFilter.filter(expr2, op);
            }
        }
        if (query2.hasValues()) {
            Table table = TableFactory.create(query2.getValuesVariables());
            for (Binding binding : query2.getValuesData()) {
                table.addBinding(binding);
            }
            OpTable opTable = OpTable.create(table);
            op = OpJoin.create(op, opTable);
        }
        if (this.context.isTrue(ARQ.generateToList)) {
            op = new OpList(op);
        }
        if (query2.getOrderBy() != null) {
            ArrayList<SortCondition> scList = new ArrayList<SortCondition>();
            for (SortCondition sc : query2.getOrderBy()) {
                Expr e3 = sc.getExpression();
                e3 = ExprLib.replaceAggregateByVariable(e3);
                scList.add(new SortCondition(e3, sc.getDirection()));
            }
            op = new OpOrder(op, scList);
        }
        if (vars.size() > 0) {
            op = new OpProject(op, vars);
        }
        if (query2.isDistinct()) {
            op = OpDistinct.create(op);
        }
        if (query2.isReduced()) {
            op = OpReduced.create(op);
        }
        if (query2.hasLimit() || query2.hasOffset()) {
            op = new OpSlice(op, query2.getOffset(), query2.getLimit());
        }
        return op;
    }

    protected static Op join(Op current, Op newOp) {
        return OpJoin.create(current, newOp);
    }

    protected Op sequence(Op current, Op newOp) {
        return OpSequence.create(current, newOp);
    }

    protected Op union(Op current, Op newOp) {
        return OpUnion.create(current, newOp);
    }

    protected final void broken(String msg) {
        throw new ARQInternalErrorException(msg);
    }
}

