/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import io.micrometer.core.instrument.binder.grpc.GrpcClientObservationContext;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.observation.Observation;

class ObservationGrpcClientCallListener<RespT>
extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
    private final Observation observation;

    ObservationGrpcClientCallListener(ClientCall.Listener<RespT> delegate, Observation observation) {
        super(delegate);
        this.observation = observation;
    }

    public void onHeaders(Metadata headers) {
        super.onHeaders(headers);
        Metadata headersToKeep = new Metadata();
        headersToKeep.merge(headers);
        GrpcClientObservationContext context2 = (GrpcClientObservationContext)this.observation.getContext();
        context2.setHeaders(headersToKeep);
    }

    public void onClose(Status status, Metadata trailers) {
        GrpcClientObservationContext context2 = (GrpcClientObservationContext)this.observation.getContext();
        context2.setStatusCode(status.getCode());
        context2.setTrailers(trailers);
        if (status.getCause() != null) {
            this.observation.error(status.getCause());
        }
        this.observation.stop();
        super.onClose(status, trailers);
    }

    public void onMessage(RespT message) {
        this.observation.event(GrpcObservationDocumentation.GrpcClientEvents.MESSAGE_RECEIVED);
        super.onMessage(message);
    }
}

