/*
 * Decompiled with CFR 0.152.
 */
package tdb2;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.apache.jena.atlas.lib.InternalErrorException;
import org.apache.jena.atlas.lib.ListUtils;
import org.apache.jena.atlas.lib.Timer;
import org.apache.jena.cmd.ArgDecl;
import org.apache.jena.cmd.CmdException;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.query.ARQ;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.system.Txn;
import org.apache.jena.system.progress.MonitorOutput;
import org.apache.jena.system.progress.MonitorOutputs;
import org.apache.jena.tdb2.loader.DataLoader;
import org.apache.jena.tdb2.loader.LoaderFactory;
import org.apache.jena.tdb2.loader.base.LoaderOps;
import org.apache.jena.tdb2.loader.main.LoaderPlans;
import org.apache.jena.util.FileUtils;
import tdb2.cmdline.CmdTDB;
import tdb2.cmdline.CmdTDBGraph;

public class tdbloader
extends CmdTDBGraph {
    private static final ArgDecl argStats = new ArgDecl(true, "stats");
    private static final ArgDecl argLoader = new ArgDecl(true, "loader");
    private static final ArgDecl argSyntax = new ArgDecl(true, "syntax");
    private boolean showProgress = true;
    private boolean generateStats = false;
    private LoaderEnum loader = null;
    private Lang lang = Lang.NQUADS;

    public static void main(String ... args) {
        CmdTDB.init();
        new tdbloader(args).mainRun();
    }

    protected tdbloader(String[] argv) {
        super(argv);
        super.add(argLoader, "--loader=", "Loader to use: 'basic', 'phased' (default), 'sequential', 'parallel' or 'light'");
        super.add(argSyntax, "--syntax=LANG", "Syntax of data from stdin");
    }

    @Override
    protected void processModulesAndArgs() {
        super.processModulesAndArgs();
        if (this.contains(argLoader)) {
            String loadername = this.getValue(argLoader).toLowerCase();
            if (loadername.matches("basic.*")) {
                this.loader = LoaderEnum.Basic;
            } else if (loadername.matches("phas.*")) {
                this.loader = LoaderEnum.Phased;
            } else if (loadername.matches("seq.*")) {
                this.loader = LoaderEnum.Sequential;
            } else if (loadername.matches("para.*")) {
                this.loader = LoaderEnum.Parallel;
            } else if (loadername.matches("light")) {
                this.loader = LoaderEnum.Light;
            } else {
                throw new CmdException("Unrecognized value for --loader: " + loadername);
            }
        }
        if (super.contains(argStats)) {
            if (!this.hasValueOfTrue(argStats) && !this.hasValueOfFalse(argStats)) {
                throw new CmdException("Not a boolean value: " + this.getValue(argStats));
            }
            this.generateStats = super.hasValueOfTrue(argStats);
        }
        if (this.graphName != null) {
            this.lang = Lang.NTRIPLES;
        }
        if (super.contains(argSyntax)) {
            String syntax = super.getValue(argSyntax);
            Lang lang$ = RDFLanguages.nameToLang(syntax);
            if (lang$ == null) {
                throw new CmdException("Can not detemine the syntax from '" + syntax + "'");
            }
            this.lang = lang$;
        }
    }

    @Override
    protected String getSummary() {
        return this.getCommandName() + "--loader= [--desc DATASET | --loc DIR] FILE ...";
    }

    @Override
    protected void exec() {
        List<String> urls;
        if (this.isVerbose()) {
            System.out.println("Java maximum memory: " + Runtime.getRuntime().maxMemory());
            System.out.println(ARQ.getContext());
        }
        if (this.isVerbose()) {
            this.showProgress = true;
        }
        if (this.isQuiet()) {
            this.showProgress = false;
        }
        if ((urls = this.getPositional()).size() != 0) {
            this.checkFiles(urls);
        }
        if (this.graphName == null) {
            if (urls.size() == 0) {
                this.loadQuadsStdin();
            } else {
                this.loadQuads(urls);
            }
            return;
        }
        for (String url : urls) {
            Lang lang = RDFLanguages.filenameToLang(url);
            if (lang == null || Lang.JSONLD.equals(lang) || !RDFLanguages.isQuads(lang) || !RDFLanguages.isQuads(lang)) continue;
            System.err.println("Warning: Quads format given - only the default graph from the data is loaded into the graph for --graph");
        }
        if (urls.size() == 0) {
            this.loadTriplesStdin();
        } else {
            this.loadTriples(this.graphName, urls);
        }
    }

    private void checkFiles(List<String> urls) {
        List<String> problemFiles = ListUtils.toList(urls.stream().filter(u -> FileUtils.isFile(u)).map(x$0 -> Paths.get(x$0, new String[0])).filter(p -> !Files.exists(p, new LinkOption[0]) || !Files.isRegularFile(p, new LinkOption[0]) || !Files.isReadable(p)).map(Path::toString));
        if (!problemFiles.isEmpty()) {
            if (problemFiles.size() == 1) {
                throw new CmdException("Can't read file : " + problemFiles.get(0));
            }
            String str2 = String.join((CharSequence)", ", problemFiles);
            throw new CmdException("Can't read files : " + str2);
        }
    }

    private void loadQuads(List<String> urls) {
        this.execBulkLoad(super.getDatasetGraph(), null, urls, this.showProgress);
    }

    private void loadTriples(String graphName, List<String> urls) {
        this.execBulkLoad(super.getDatasetGraph(), graphName, urls, this.showProgress);
    }

    private long execBulkLoad(DatasetGraph dsg, String graphName, List<String> urls, boolean showProgress) {
        DataLoader loader = this.chooseLoader(dsg, graphName);
        long elapsed = Timer.time(() -> {
            loader.startBulk();
            loader.load(urls);
            loader.finishBulk();
        });
        return elapsed;
    }

    private long loadQuadsStdin() {
        Lang parseLang = this.lang != null ? this.lang : Lang.NQUADS;
        long elapsed = this.execBulkLoadStdin(super.getDatasetGraph(), null, parseLang, this.showProgress);
        return elapsed;
    }

    private long loadTriplesStdin() {
        Lang parseLang = this.lang != null ? this.lang : Lang.NTRIPLES;
        long elapsed = this.execBulkLoadStdin(super.getDatasetGraph(), this.graphName, parseLang, this.showProgress);
        return elapsed;
    }

    private long execBulkLoadStdin(DatasetGraph dsg, String graphName, Lang syntax, boolean showProgress) {
        DataLoader loader = this.chooseLoader(dsg, graphName);
        long elapsed = Timer.time(() -> {
            loader.startBulk();
            loader.loadFromInputStream("(stdin)", System.in, syntax);
            loader.finishBulk();
        });
        return elapsed;
    }

    private DataLoader chooseLoader(DatasetGraph dsg, String graphName) {
        LoaderEnum useLoader;
        Objects.requireNonNull(dsg);
        Node gn = null;
        if (graphName != null) {
            gn = NodeFactory.createURI(graphName);
        }
        if ((useLoader = this.loader) == null) {
            boolean isEmpty = Txn.calculateRead(dsg, () -> dsg.isEmpty());
            useLoader = isEmpty ? LoaderEnum.Phased : LoaderEnum.Basic;
        }
        MonitorOutput output = this.isQuiet() ? MonitorOutputs.nullOutput() : LoaderOps.outputToLog();
        DataLoader loader = this.createLoader(useLoader, dsg, gn, output);
        if (output != null) {
            output.print("Loader = %s", loader.getClass().getSimpleName());
        }
        return loader;
    }

    private DataLoader createLoader(LoaderEnum useLoader, DatasetGraph dsg, Node gn, MonitorOutput output) {
        switch (useLoader) {
            case Phased: {
                return LoaderFactory.phasedLoader(dsg, gn, output);
            }
            case Parallel: {
                return LoaderFactory.parallelLoader(dsg, gn, output);
            }
            case Sequential: {
                return LoaderFactory.sequentialLoader(dsg, gn, output);
            }
            case Light: {
                return LoaderFactory.createLoader(LoaderPlans.loaderPlanLight, dsg, output);
            }
            case Basic: {
                return LoaderFactory.basicLoader(dsg, gn, output);
            }
        }
        throw new InternalErrorException("Unrecognized loader: " + useLoader);
    }

    private static enum LoaderEnum {
        Basic,
        Parallel,
        Sequential,
        Light,
        Phased;

    }
}

