/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util.copier;

import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omnifaces.util.copier.CloneCopier;
import org.omnifaces.util.copier.Copier;
import org.omnifaces.util.copier.CopyCtorCopier;
import org.omnifaces.util.copier.NewInstanceCopier;
import org.omnifaces.util.copier.SerializationCopier;

public class MultiStrategyCopier
implements Copier {
    private static final Logger logger = Logger.getLogger(MultiStrategyCopier.class.getName());
    private static final List<Copier> COPIERS = Arrays.asList(new CloneCopier(), new SerializationCopier(), new CopyCtorCopier(), new NewInstanceCopier());

    @Override
    public Object copy(Object object) {
        for (Copier copier : COPIERS) {
            try {
                return copier.copy(object);
            }
            catch (Exception ignore) {
                logger.log(Level.FINEST, "Ignoring thrown exception; next copier will be tried and there is a fallback to IllegalStateException.", ignore);
            }
        }
        throw new IllegalStateException("Can't copy object of type " + object.getClass() + ". No copier appeared to be capable of copying it.");
    }
}

