/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.util.Set;
import java.util.stream.Collectors;

public final class ResourcePaths {
    public static final String PATH_SEPARATOR = "/";
    public static final String EXTENSION_SEPARATOR = ".";

    private ResourcePaths() {
    }

    public static boolean isDirectory(String resourcePath) {
        return resourcePath.endsWith(PATH_SEPARATOR);
    }

    public static String stripPrefixPath(String prefix, String resourcePath) {
        return resourcePath.startsWith(prefix) ? resourcePath.substring(prefix.length() - 1) : resourcePath;
    }

    public static String stripTrailingSlash(String resourcePath) {
        return resourcePath.endsWith(PATH_SEPARATOR) ? ResourcePaths.stripTrailingSlash(resourcePath.substring(0, resourcePath.length() - 1)) : resourcePath;
    }

    public static String stripExtension(String resourcePath) {
        return ResourcePaths.isExtensionless(resourcePath) ? resourcePath : resourcePath.substring(0, resourcePath.lastIndexOf(EXTENSION_SEPARATOR));
    }

    public static String getExtension(String resourcePath) {
        return ResourcePaths.isExtensionless(resourcePath) ? null : resourcePath.substring(resourcePath.lastIndexOf(EXTENSION_SEPARATOR));
    }

    public static boolean isExtensionless(String resourcePath) {
        return !resourcePath.substring(resourcePath.lastIndexOf(PATH_SEPARATOR) + 1).contains(EXTENSION_SEPARATOR);
    }

    public static Set<String> filterExtension(Set<String> resourcePaths) {
        return resourcePaths.stream().filter(ResourcePaths::isExtensionless).collect(Collectors.toSet());
    }

    public static boolean isRoot(String resourcePath) {
        return resourcePath.equals(PATH_SEPARATOR);
    }

    public static String addLeadingSlashIfNecessary(String resourcePath) {
        return resourcePath.startsWith(PATH_SEPARATOR) ? resourcePath : PATH_SEPARATOR + resourcePath;
    }

    public static String addTrailingSlashIfNecessary(String resourcePath) {
        return resourcePath.endsWith(PATH_SEPARATOR) ? resourcePath : resourcePath + PATH_SEPARATOR;
    }

    public static String concat(String ... resourcePaths) {
        return String.join((CharSequence)PATH_SEPARATOR, resourcePaths);
    }
}

