/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.omnifaces.util.Exceptions;
import org.omnifaces.util.JNDI;
import org.omnifaces.util.Lazy;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;

public class JNDIObjectLocator
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final Map<String, String> environment;
    private final String namespace;
    private final boolean noCaching;
    private final boolean cacheRemote;
    private final Lazy<InitialContext> initialContext;
    private final Lock initialContextLock;
    private final Lazy<Map<String, Object>> jndiObjectCache;
    private final Lazy<Class<? extends Annotation>> remoteAnnotation;

    public static JNDIObjectLocatorBuilder builder() {
        return new JNDIObjectLocatorBuilder();
    }

    private JNDIObjectLocator(Map<String, String> environment, String namespace2, boolean noCaching, boolean cacheRemote) {
        this.environment = environment;
        this.namespace = namespace2;
        this.noCaching = noCaching;
        this.cacheRemote = cacheRemote;
        this.initialContext = new Lazy(this::createInitialContext);
        this.initialContextLock = new ReentrantLock();
        this.jndiObjectCache = new Lazy(() -> noCaching ? Collections.emptyMap() : new ConcurrentHashMap());
        this.remoteAnnotation = new Lazy(() -> Reflection.toClassOrNull("javax.ejb.Remote"));
    }

    public <T> T getEnvEntry(String name) {
        return this.getObject("java:comp/env/" + name);
    }

    public <T> T getObject(Class<T> beanClass) {
        String jndiName = this.namespace + "/" + JNDI.guessJNDIName(beanClass);
        boolean remote = this.remoteAnnotation.get() != null && beanClass.isAnnotationPresent(this.remoteAnnotation.get());
        return this.getJNDIObject(jndiName, remote && !this.cacheRemote);
    }

    public <T> T getObject(String jndiName) {
        return this.getJNDIObject(jndiName, false);
    }

    public <T> T getObjectNoCache(String jndiName) {
        return this.getJNDIObject(jndiName, true);
    }

    public void clearCache() {
        this.jndiObjectCache.get().clear();
    }

    public String prependNamespaceIfNecessary(String fieldName) {
        return fieldName.startsWith("java:") ? fieldName : this.namespace + "/" + fieldName;
    }

    Map<String, Object> getJNDIObjectCache() {
        return this.jndiObjectCache.get();
    }

    private InitialContext createInitialContext() {
        try {
            if (this.environment.isEmpty()) {
                return new InitialContext();
            }
            return new InitialContext(new Hashtable<String, String>(this.environment));
        }
        catch (NamingException e2) {
            throw new IllegalStateException(e2);
        }
    }

    private <T> T getJNDIObject(String jndiName, boolean noCaching) {
        if (noCaching || this.noCaching) {
            return this.lookup(jndiName, true);
        }
        try {
            return (T)this.jndiObjectCache.get().computeIfAbsent(jndiName, name -> this.lookup((String)name, false));
        }
        catch (IllegalStateException e2) {
            this.clearCache();
            throw e2;
        }
    }

    private <T> T lookup(String name, boolean clearCache) {
        this.initialContextLock.lock();
        boolean shouldClearCache = false;
        try {
            Object object = this.initialContext.get().lookup(name);
            return (T)object;
        }
        catch (NamingException e2) {
            if (Exceptions.is(e2, NameNotFoundException.class)) {
                T t2 = null;
                return t2;
            }
            shouldClearCache = clearCache;
            throw new IllegalStateException(e2);
        }
        finally {
            this.initialContextLock.unlock();
            if (shouldClearCache) {
                this.clearCache();
            }
        }
    }

    public static class JNDIObjectLocatorBuilder {
        private Map<String, String> environment;
        private String namespace;
        private Boolean noCaching;
        private Boolean cacheRemote;
        private boolean build;

        public JNDIObjectLocatorBuilder environment(Map<String, String> environment) {
            Objects.requireNonNull(environment, "environment");
            if (this.build || this.environment != null) {
                throw new IllegalStateException();
            }
            this.environment = environment;
            return this;
        }

        public JNDIObjectLocatorBuilder environment(String key, String value) {
            Objects.requireNonNull(key, "key");
            Objects.requireNonNull(value, "value");
            if (this.environment == null) {
                this.environment = new Hashtable<String, String>();
            }
            if (this.build || this.environment.put(key, value) != null) {
                throw new IllegalStateException();
            }
            return this;
        }

        public JNDIObjectLocatorBuilder initialHost(String initialHost) {
            return this.environment("org.omg.CORBA.ORBInitialHost", initialHost);
        }

        public JNDIObjectLocatorBuilder initialPort(int initialPort) {
            return this.environment("org.omg.CORBA.ORBInitialPort", Integer.toString(initialPort));
        }

        public JNDIObjectLocatorBuilder namespace(String namespace2) {
            Objects.requireNonNull(namespace2, "namespace");
            if (this.build || this.namespace != null) {
                throw new IllegalStateException();
            }
            this.namespace = namespace2;
            return this;
        }

        public JNDIObjectLocatorBuilder global() {
            return this.namespace("java:global");
        }

        public JNDIObjectLocatorBuilder app() {
            return this.namespace("java:app");
        }

        public JNDIObjectLocatorBuilder noCaching() {
            if (this.build || this.noCaching != null) {
                throw new IllegalStateException();
            }
            this.noCaching = true;
            return this;
        }

        public JNDIObjectLocatorBuilder cacheRemote() {
            if (this.build || this.cacheRemote != null) {
                throw new IllegalStateException();
            }
            this.cacheRemote = true;
            return this;
        }

        public JNDIObjectLocator build() {
            if (this.build) {
                throw new IllegalStateException();
            }
            this.environment = Collections.unmodifiableMap(Utils.coalesce(this.environment, Collections.emptyMap()));
            this.namespace = Utils.coalesce(this.namespace, "java:module");
            this.noCaching = Utils.coalesce(this.noCaching, Boolean.FALSE);
            this.cacheRemote = Utils.coalesce(this.cacheRemote, Boolean.FALSE);
            this.build = true;
            return new JNDIObjectLocator(this.environment, this.namespace, this.noCaching, this.cacheRemote);
        }
    }
}

