/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.omnifaces.util.Exceptions;

public final class JNDI {
    public static final String JNDI_NAMESPACE_PREFIX = "java:";
    public static final String JNDI_NAMESPACE_COMPONENT = "java:comp";
    public static final String JNDI_NAMESPACE_GLOBAL = "java:global";
    public static final String JNDI_NAMESPACE_MODULE = "java:module";
    public static final String JNDI_NAMESPACE_APPLICATION = "java:app";
    public static final String JNDI_NAME_PREFIX_ENV_ENTRY = "java:comp/env";
    public static final Pattern PATTERN_EJB_INTERFACE_SUFFIX = Pattern.compile("(LOCAL|REMOTE)$", 2);

    private JNDI() {
    }

    public static <T> T getEnvEntry(String name) {
        return JNDI.lookup("java:comp/env/" + name);
    }

    public static <T> T lookup(String name) {
        InitialContext context2 = null;
        try {
            context2 = new InitialContext();
            Object object = context2.lookup(name);
            return (T)object;
        }
        catch (NamingException e2) {
            if (Exceptions.is(e2, NameNotFoundException.class)) {
                T t2 = null;
                return t2;
            }
            throw new IllegalStateException(e2);
        }
        finally {
            JNDI.close(context2);
        }
    }

    private static void close(InitialContext context2) {
        try {
            if (context2 != null) {
                context2.close();
            }
        }
        catch (NamingException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static String guessJNDIName(Class<?> beanClass) {
        return JNDI.guessJNDIName(beanClass.getName());
    }

    public static String guessJNDIName(String className) {
        String lookupname = className.substring(className.lastIndexOf(".") + 1);
        return PATTERN_EJB_INTERFACE_SUFFIX.matcher(lookupname).replaceFirst("") + "!" + className;
    }
}

