/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.el.VariableMapper;
import javax.faces.FacesWrapper;
import javax.faces.component.StateHelper;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.behavior.ClientBehaviorHolder;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.websocket.Session;
import org.omnifaces.util.Components;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;

public final class Hacks {
    private static final Class<?> PRIMEFACES_AJAX_SOURCE_CLASS = Reflection.toClassOrNull("org.primefaces.component.api.AjaxSource");
    private static final Class<UIComponent> PRIMEFACES_DIALOG_CLASS = Reflection.toClassOrNull("org.primefaces.component.dialog.Dialog");
    private static final String MOJARRA_PACKAGE_PREFIX = "com.sun.faces.";
    private static final String MYFACES_PACKAGE_PREFIX = "org.apache.myfaces.";
    private static final Set<String> MYFACES_RESOURCE_DEPENDENCY_KEYS = Utils.unmodifiableSet("org.apache.myfaces.RENDERED_SCRIPT_RESOURCES_SET", "org.apache.myfaces.RENDERED_STYLESHEET_RESOURCES_SET");
    private static final String MOJARRA_DEFAULT_RESOURCE_MAX_AGE = "com.sun.faces.defaultResourceMaxAge";
    private static final String MYFACES_DEFAULT_RESOURCE_MAX_AGE = "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES";
    private static final long DEFAULT_RESOURCE_MAX_AGE = 604800000L;
    private static final String[] PARAM_NAMES_RESOURCE_MAX_AGE = new String[]{"com.sun.faces.defaultResourceMaxAge", "org.apache.myfaces.RESOURCE_MAX_TIME_EXPIRES"};
    private static final String MYFACES_RESOURCE_DEPENDENCY_UNIQUE_ID = "oam.view.resourceDependencyUniqueId";
    private static final String MOJARRA_SERIALIZED_VIEWS = "com.sun.faces.renderkit.ServerSideStateHelper.LogicalViewMap";
    private static final String MOJARRA_SERIALIZED_VIEW_KEY = "com.sun.faces.logicalViewMap";
    private static final String MOJARRA_ACTIVE_VIEW_MAPS = "com.sun.faces.application.view.activeViewMaps";
    private static final String MOJARRA_VIEW_MAP_ID = "com.sun.faces.application.view.viewMapId";
    private static final Set<String> MYFACES_SERIALIZED_VIEWS = Utils.unmodifiableSet("org.apache.myfaces.application.viewstate.ServerSideStateCacheImpl.SERIALIZED_VIEW", "org.apache.myfaces.application.viewstate.StateCacheServerSide.SERIALIZED_VIEW");
    private static final String MYFACES_VIEW_SCOPE_PROVIDER = "org.apache.myfaces.spi.ViewScopeProvider.INSTANCE";
    private static final String MOJARRA_CACHED_SERVLET_MAPPING_KEY = "com.sun.faces.INVOCATION_PATH";
    private static final String MYFACES_CACHED_SERVLET_MAPPING_KEY = "org.apache.myfaces.shared.application.DefaultViewHandlerSupport.CACHED_SERVLET_MAPPING";
    private static final String ERROR_MAX_AGE = "The '%s' init param must be a number. Encountered an invalid value of '%s'.";
    private static Boolean mojarraUsed;
    private static Boolean myFacesUsed;
    private static Long defaultResourceMaxAge;

    private Hacks() {
    }

    public static boolean isMojarraUsed() {
        if (mojarraUsed == null) {
            FacesContext context2 = FacesContext.getCurrentInstance();
            if (context2 != null) {
                mojarraUsed = FacesLocal.getPackage(context2).getName().startsWith(MOJARRA_PACKAGE_PREFIX);
            } else {
                return false;
            }
        }
        return mojarraUsed;
    }

    public static boolean isMyFacesUsed() {
        if (myFacesUsed == null) {
            FacesContext context2 = FacesContext.getCurrentInstance();
            if (context2 != null) {
                myFacesUsed = FacesLocal.getPackage(context2).getName().startsWith(MYFACES_PACKAGE_PREFIX);
            } else {
                return false;
            }
        }
        return myFacesUsed;
    }

    public static long getDefaultResourceMaxAge() {
        if (defaultResourceMaxAge == null) {
            Long resourceMaxAge = 604800000L;
            FacesContext context2 = FacesContext.getCurrentInstance();
            if (context2 == null) {
                return resourceMaxAge;
            }
            for (String name : PARAM_NAMES_RESOURCE_MAX_AGE) {
                String value = FacesLocal.getInitParameter(context2, name);
                if (value == null) continue;
                try {
                    resourceMaxAge = Long.valueOf(value);
                    break;
                }
                catch (NumberFormatException e2) {
                    throw new IllegalArgumentException(String.format(ERROR_MAX_AGE, name, value), e2);
                }
            }
            defaultResourceMaxAge = resourceMaxAge;
        }
        return defaultResourceMaxAge;
    }

    public static void removeResourceDependencyState(FacesContext context2) {
        context2.getAttributes().keySet().removeAll(MYFACES_RESOURCE_DEPENDENCY_KEYS);
        if (FacesLocal.isRenderResponse(context2) || Hacks.isPrimeFacesAjaxRequest(context2)) {
            context2.getAttributes().keySet().remove("/javax.faces.resource");
        }
        context2.getAttributes().values().removeAll(Collections.singleton(true));
    }

    public static void setComponentResourceUniqueId(FacesContext context2, UIComponent resource) {
        UIViewRoot view = context2.getViewRoot();
        if (Hacks.isMyFacesUsed()) {
            view.getAttributes().put(MYFACES_RESOURCE_DEPENDENCY_UNIQUE_ID, Boolean.TRUE);
        }
        try {
            resource.setId(view.createUniqueId(context2, null));
        }
        finally {
            if (Hacks.isMyFacesUsed()) {
                view.getAttributes().put(MYFACES_RESOURCE_DEPENDENCY_UNIQUE_ID, Boolean.FALSE);
            }
        }
    }

    public static void clearCachedFacesServletMapping(FacesContext context2) {
        context2.getAttributes().remove(Hacks.isMyFacesUsed() ? MYFACES_CACHED_SERVLET_MAPPING_KEY : MOJARRA_CACHED_SERVLET_MAPPING_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeViewState(FacesContext context2, ResponseStateManager manager, String viewId) {
        if (Hacks.isMyFacesUsed()) {
            Object state = Reflection.invokeMethod((Object)manager, "getSavedState", context2);
            if (!(state instanceof String)) {
                return;
            }
            Object viewCollection = MYFACES_SERIALIZED_VIEWS.stream().map(k -> FacesLocal.getSessionAttribute(context2, k)).filter(Objects::nonNull).findFirst().orElse(null);
            if (viewCollection == null) {
                return;
            }
            Object stateCache = Reflection.invokeMethod((Object)manager, "getStateCache", context2);
            Object stateId = Reflection.invokeMethod(stateCache, "getServerStateId", context2, state);
            Serializable key = (Serializable)Reflection.invokeMethod(Reflection.invokeMethod(stateCache, "getSessionViewStorageFactory", new Object[0]), "createSerializedViewKey", context2, FacesLocal.normalizeViewId(context2, viewId), stateId);
            List keys = (List)Reflection.accessField(viewCollection, "_keys");
            Map serializedViews = (Map)Reflection.accessField(viewCollection, "_serializedViews");
            Map precedence = (Map)Reflection.accessField(viewCollection, "_precedence");
            Object var11_13 = viewCollection;
            synchronized (var11_13) {
                keys.remove(key);
                serializedViews.remove(key);
                Serializable previousKey = (Serializable)precedence.remove(key);
                if (previousKey != null) {
                    for (Map.Entry entry : precedence.entrySet()) {
                        if (!((Serializable)entry.getValue()).equals(key)) continue;
                        entry.setValue(previousKey);
                    }
                }
                Map viewScopeIds = (Map)Reflection.accessField(viewCollection, "_viewScopeIds");
                Map map = (Map)Reflection.accessField(viewCollection, "_viewScopeIdCounts");
                if (viewScopeIds == null || map == null || viewScopeIds.get(key) == null) {
                    return;
                }
                String viewScopeId = (String)viewScopeIds.remove(key);
                int count = Utils.coalesce((Integer)map.get(viewScopeId), 1) - 1;
                if (count < 1) {
                    map.remove(viewScopeId);
                    Reflection.invokeMethod(FacesLocal.getApplicationAttribute(context2, MYFACES_VIEW_SCOPE_PROVIDER), "destroyViewScopeMap", context2, viewScopeId);
                } else {
                    map.put(viewScopeId, count);
                }
            }
        } else {
            Map activeViewMaps;
            Map serializedViews = (Map)FacesLocal.getSessionAttribute(context2, MOJARRA_SERIALIZED_VIEWS);
            if (serializedViews != null) {
                serializedViews.remove(context2.getAttributes().get(MOJARRA_SERIALIZED_VIEW_KEY));
            }
            if ((activeViewMaps = (Map)FacesLocal.getSessionAttribute(context2, MOJARRA_ACTIVE_VIEW_MAPS)) != null) {
                activeViewMaps.remove(context2.getViewRoot().getTransientStateHelper().getTransient((Object)MOJARRA_VIEW_MAP_ID));
            }
        }
    }

    public static StateHelper getStateHelper(UIComponent component) {
        return (StateHelper)Reflection.invokeMethod((Object)component, "getStateHelper", new Object[0]);
    }

    public static VariableMapper findWrappedVariableMapper(VariableMapper mapper) {
        if (mapper instanceof FacesWrapper) {
            return (VariableMapper)((FacesWrapper)mapper).getWrapped();
        }
        for (Class<?> type = mapper.getClass(); type != Object.class; type = type.getSuperclass()) {
            for (Field field : type.getDeclaredFields()) {
                if (!VariableMapper.class.isAssignableFrom(field.getType())) continue;
                try {
                    field.setAccessible(true);
                    return (VariableMapper)field.get(mapper);
                }
                catch (IllegalAccessException e2) {
                    throw new IllegalStateException(e2);
                }
            }
        }
        return null;
    }

    public static boolean isPrimeFacesDynamicResourceRequest(FacesContext context2) {
        Map params = context2.getExternalContext().getRequestParameterMap();
        return "primefaces".equals(params.get("ln")) && params.get("pfdrid") != null;
    }

    public static boolean isPrimeFacesAjaxRequest(FacesContext context2) {
        if (!FacesLocal.isAjaxRequest(context2)) {
            return false;
        }
        UIComponent actionSource = Components.getCurrentActionSource(context2, (UIComponent)context2.getViewRoot());
        if (actionSource == null) {
            return false;
        }
        if (Hacks.isPrimeFacesAjaxSource(actionSource)) {
            return true;
        }
        if (!(actionSource instanceof ClientBehaviorHolder)) {
            return false;
        }
        String ajaxEvent = FacesLocal.getRequestParameter(context2, "javax.faces.behavior.event");
        if (ajaxEvent == null) {
            return false;
        }
        ClientBehaviorHolder ajaxSource = (ClientBehaviorHolder)actionSource;
        return ((List)ajaxSource.getClientBehaviors().get(ajaxEvent)).stream().anyMatch(Hacks::isPrimeFacesAjaxSource);
    }

    private static boolean isPrimeFacesAjaxSource(Object object) {
        return PRIMEFACES_AJAX_SOURCE_CLASS != null && PRIMEFACES_AJAX_SOURCE_CLASS.isInstance(object);
    }

    public static boolean isNestedInPrimeFacesDialog(UIComponent ... components) {
        if (PRIMEFACES_DIALOG_CLASS == null) {
            return false;
        }
        HashSet<UIComponent> dialogs = new HashSet<UIComponent>();
        for (UIComponent component : components) {
            dialogs.add(Components.getClosestParent(component, PRIMEFACES_DIALOG_CLASS));
        }
        return dialogs.size() == 1 && dialogs.iterator().next() != null;
    }

    public static boolean isTomcatWebSocketBombed(Session session, IllegalStateException illegalStateException) {
        return session.getClass().getName().startsWith("org.apache.tomcat.websocket.") && illegalStateException.getMessage().contains("[TEXT_FULL_WRITING]");
    }
}

