/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import javax.el.ELException;
import javax.faces.FacesException;
import org.omnifaces.util.Utils;

public final class Exceptions {
    private Exceptions() {
    }

    @SafeVarargs
    public static Throwable unwrap(Throwable exception, Class<? extends Throwable> ... types) {
        Throwable unwrappedException = exception;
        while (Utils.isOneInstanceOf(unwrappedException.getClass(), types) && unwrappedException.getCause() != null) {
            unwrappedException = unwrappedException.getCause();
        }
        return unwrappedException;
    }

    public static Throwable unwrap(Throwable exception) {
        return Exceptions.unwrap(exception, FacesException.class, ELException.class);
    }

    public static <T extends Throwable> boolean is(Throwable exception, Class<T> type) {
        return Exceptions.extract(exception, type) != null;
    }

    public static <T extends Throwable> T extract(Throwable exception, Class<T> type) {
        for (Throwable unwrappedException = exception; unwrappedException != null; unwrappedException = unwrappedException.getCause()) {
            if (!type.isInstance(unwrappedException)) continue;
            return (T)unwrappedException;
        }
        return null;
    }
}

