/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.util;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Typed;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import org.omnifaces.cdi.beans.InjectionPointGenerator;
import org.omnifaces.util.Beans;

@Typed
public final class BeansLocal {
    private static final Logger logger = Logger.getLogger(BeansLocal.class.getName());

    private BeansLocal() {
    }

    public static <T> Bean<T> resolve(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Set beans = beanManager.getBeans(beanClass, qualifiers);
        for (Bean bean : beans) {
            if (bean.getBeanClass() != beanClass) continue;
            return beanManager.resolve(Collections.singleton(bean));
        }
        return beanManager.resolve(beans);
    }

    public static <T> Bean<T> resolveExact(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass, qualifiers);
        return bean != null && bean.getBeanClass() == beanClass ? bean : null;
    }

    public static <T> T getReference(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass, qualifiers);
        return bean != null ? (T)BeansLocal.getReference(beanManager, bean, beanClass) : null;
    }

    public static <T> T getReference(BeanManager beanManager, Bean<T> bean) {
        return BeansLocal.getReference(beanManager, bean, bean.getBeanClass());
    }

    private static <T> T getReference(BeanManager beanManager, Bean<T> bean, Class<?> beanClass) {
        return (T)beanManager.getReference(bean, beanClass, beanManager.createCreationalContext(bean));
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        return BeansLocal.getInstance(beanManager, beanClass, true, qualifiers);
    }

    public static <T> T getInstance(BeanManager beanManager, Class<T> beanClass, boolean create, Annotation ... qualifiers) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass, qualifiers);
        return bean != null ? (T)BeansLocal.getInstance(beanManager, bean, create) : null;
    }

    public static <T> T getInstance(BeanManager beanManager, Bean<T> bean, boolean create) {
        Context context2 = beanManager.getContext(bean.getScope());
        if (create) {
            return (T)context2.get(bean, beanManager.createCreationalContext(bean));
        }
        return (T)context2.get(bean);
    }

    public static <T> T getInstance(BeanManager beanManager, String name, boolean create) {
        Set beans = beanManager.getBeans(name);
        Bean bean = beanManager.resolve(beans);
        return bean != null ? (T)BeansLocal.getInstance(beanManager, bean, create) : null;
    }

    public static <T> T getInstance(BeanManager beanManager, String name) {
        return BeansLocal.getInstance(beanManager, name, true);
    }

    public static <T> T unwrapIfNecessary(BeanManager beanManager, T object) {
        if (object == null) {
            return null;
        }
        if (!Beans.isProxy(object)) {
            return object;
        }
        if (object instanceof Class) {
            return (T)((Class)object).getSuperclass();
        }
        return (T)BeansLocal.getInstance(beanManager, object.getClass().getSuperclass(), new Annotation[0]);
    }

    public static <S extends Annotation> boolean isActive(BeanManager beanManager, Class<S> scope) {
        try {
            return beanManager.getContext(scope).isActive();
        }
        catch (Exception ignore) {
            logger.log(Level.FINEST, "Ignoring thrown exception; given scope is very unlikely active anyway.", ignore);
            return false;
        }
    }

    public static <S extends Annotation> Map<Object, String> getActiveInstances(BeanManager beanManager, Class<S> scope) {
        HashMap<Object, String> activeInstances = new HashMap<Object, String>();
        Set beans = beanManager.getBeans(Object.class, new Annotation[0]);
        Context context2 = beanManager.getContext(scope);
        for (Bean bean : beans) {
            Object instance = context2.get((Contextual)bean);
            if (instance == null) continue;
            activeInstances.put(instance, bean.getName());
        }
        return Collections.unmodifiableMap(activeInstances);
    }

    public static <T> void destroy(BeanManager beanManager, Class<T> beanClass, Annotation ... qualifiers) {
        Bean<T> bean = BeansLocal.resolve(beanManager, beanClass, qualifiers);
        if (bean != null) {
            BeansLocal.destroy(beanManager, bean);
        }
    }

    public static <T> void destroy(BeanManager beanManager, Bean<T> bean) {
        Context context2 = beanManager.getContext(bean.getScope());
        if (context2 instanceof AlterableContext) {
            ((AlterableContext)context2).destroy(bean);
        } else {
            Object instance = context2.get(bean);
            if (instance != null) {
                BeansLocal.destroy(beanManager, bean, instance);
            }
        }
    }

    public static <T> void destroy(BeanManager beanManager, T instance) {
        if (instance instanceof Class) {
            BeansLocal.destroy(beanManager, (Class)instance, new Annotation[0]);
        } else {
            for (Class<?> beanClass = instance.getClass(); beanClass != Object.class; beanClass = beanClass.getSuperclass()) {
                Bean<?> bean = BeansLocal.resolve(beanManager, beanClass, new Annotation[0]);
                if (bean == null) continue;
                BeansLocal.destroy(beanManager, bean, instance);
                return;
            }
        }
    }

    private static <T> void destroy(BeanManager beanManager, Bean<T> bean, T instance) {
        bean.destroy(instance, beanManager.createCreationalContext(bean));
    }

    public static <A extends Annotation> A getAnnotation(BeanManager beanManager, Annotated annotated, Class<A> annotationType) {
        annotated.getAnnotation(annotationType);
        if (annotated.getAnnotations().isEmpty()) {
            return null;
        }
        if (annotated.isAnnotationPresent(annotationType)) {
            return (A)annotated.getAnnotation(annotationType);
        }
        LinkedList annotations = new LinkedList(annotated.getAnnotations());
        while (!annotations.isEmpty()) {
            Annotation annotation = (Annotation)annotations.remove();
            if (annotation.annotationType().equals(annotationType)) {
                return (A)((Annotation)annotationType.cast(annotation));
            }
            if (!beanManager.isStereotype(annotation.annotationType())) continue;
            annotations.addAll(beanManager.getStereotypeDefinition(annotation.annotationType()));
        }
        return null;
    }

    public static InjectionPoint getCurrentInjectionPoint(BeanManager beanManager, CreationalContext<?> creationalContext) {
        Bean<InjectionPointGenerator> bean = BeansLocal.resolve(beanManager, InjectionPointGenerator.class, new Annotation[0]);
        return bean != null ? (InjectionPoint)beanManager.getInjectableReference((InjectionPoint)bean.getInjectionPoints().iterator().next(), creationalContext) : null;
    }

    public static void fireEvent(BeanManager beanManager, Object event, Annotation ... qualifiers) {
        beanManager.fireEvent(event, qualifiers);
    }
}

