/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewParameter;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.PostValidateEvent;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.util.Events;
import org.omnifaces.util.Facelets;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Utils;

public class ViewParamValidationFailed
extends TagHandler {
    private static final Pattern HTTP_STATUS_CODE = Pattern.compile("[1-9][0-9][0-9]");
    private static final String ERROR_INVALID_PARENT = "%s This must be a child of UIViewRoot or UIViewParameter. Encountered parent of type '%s'. You need to enclose it in f:metadata or f|o:viewParam.";
    private static final String ERROR_MISSING_ATTRIBUTE = "%s You need to specify either 'sendRedirect' or 'sendError' attribute.";
    private static final String ERROR_DOUBLE_ATTRIBUTE = "%s You cannot specify both 'sendRedirect' and 'sendError' attributes. You can specify only one of them.";
    private static final String ERROR_REQUIRED_ATTRIBUTE = "%s This attribute is required, it cannot be set to null.";
    private static final String ERROR_INVALID_SENDERROR = "%s This attribute must represent a 3-digit HTTP status code. Encountered an invalid value '%s'.";
    private ValueExpression sendRedirect;
    private ValueExpression sendError;
    private ValueExpression message;

    public ViewParamValidationFailed(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context2, UIComponent parent) throws IOException {
        if (!(parent instanceof UIViewRoot) && !(parent instanceof UIViewParameter)) {
            throw new IllegalStateException(String.format(ERROR_INVALID_PARENT, new Object[]{this, parent.getClass().getName()}));
        }
        FacesContext facesContext = context2.getFacesContext();
        if (!ComponentHandler.isNew((UIComponent)parent) || facesContext.isPostback() || facesContext.getRenderResponse()) {
            return;
        }
        this.sendRedirect = Facelets.getValueExpression(context2, this.getAttribute("sendRedirect"), String.class);
        this.sendError = Facelets.getValueExpression(context2, this.getAttribute("sendError"), String.class);
        this.message = Facelets.getValueExpression(context2, this.getAttribute("message"), String.class);
        if (this.sendRedirect == null && this.sendError == null) {
            throw new IllegalArgumentException(String.format(ERROR_MISSING_ATTRIBUTE, new Object[]{this}));
        }
        if (this.sendRedirect != null && this.sendError != null) {
            throw new IllegalArgumentException(String.format(ERROR_DOUBLE_ATTRIBUTE, new Object[]{this}));
        }
        Events.subscribeToRequestComponentEvent(parent, PostValidateEvent.class, this::processViewParamValidationFailed);
    }

    protected void processViewParamValidationFailed(ComponentSystemEvent event) {
        FacesContext context2 = Faces.getContext();
        UIComponent component = event.getComponent();
        if (component instanceof UIViewParameter ? ((UIViewParameter)component).isValid() : !context2.isValidationFailed()) {
            return;
        }
        if (Boolean.TRUE.equals(context2.getAttributes().put(((Object)((Object)this)).getClass().getName(), Boolean.TRUE))) {
            return;
        }
        String firstFacesMessage = Utils.coalesce(this.cleanupFacesMessagesAndGetFirst(context2.getMessages(component.getClientId(context2))), this.cleanupFacesMessagesAndGetFirst(context2.getMessages(null)), this.cleanupFacesMessagesAndGetFirst(context2.getMessages()));
        this.evaluateAttributesAndHandleSendRedirectOrError(context2, firstFacesMessage);
    }

    private String cleanupFacesMessagesAndGetFirst(Iterator<FacesMessage> facesMessages) {
        String firstFacesMessage = null;
        while (facesMessages.hasNext()) {
            FacesMessage facesMessage = facesMessages.next();
            if (firstFacesMessage == null) {
                firstFacesMessage = facesMessage.getSummary();
            }
            facesMessages.remove();
        }
        return firstFacesMessage;
    }

    private void evaluateAttributesAndHandleSendRedirectOrError(FacesContext context2, String defaultMessage) {
        ELContext elContext = context2.getELContext();
        String evaluatedMessage = ViewParamValidationFailed.evaluate(elContext, this.message, false);
        if (evaluatedMessage == null) {
            evaluatedMessage = defaultMessage;
        }
        if (this.sendRedirect != null) {
            String evaluatedSendRedirect = ViewParamValidationFailed.evaluate(elContext, this.sendRedirect, true);
            if (!Utils.isEmpty(evaluatedMessage)) {
                Messages.addFlashGlobalError(evaluatedMessage, new Object[0]);
            }
            FacesLocal.redirect(context2, evaluatedSendRedirect, new Object[0]);
        } else {
            String evaluatedSendError = ViewParamValidationFailed.evaluate(elContext, this.sendError, true);
            if (!HTTP_STATUS_CODE.matcher(evaluatedSendError).matches()) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_SENDERROR, this.sendError, evaluatedSendError));
            }
            FacesLocal.responseSendError(context2, Integer.valueOf(evaluatedSendError), evaluatedMessage);
        }
    }

    private static String evaluate(ELContext context2, ValueExpression expression, boolean required) {
        Object value;
        Object object = value = expression != null ? expression.getValue(context2) : null;
        if (required && Utils.isEmpty(value)) {
            throw new IllegalArgumentException(String.format(ERROR_REQUIRED_ATTRIBUTE, expression));
        }
        return value != null ? value.toString() : null;
    }
}

