/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.io.IOException;
import javax.el.ValueExpression;
import javax.faces.component.UIComponent;
import javax.faces.component.UIData;
import javax.faces.component.UIInput;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.event.ValueChangeEvent;
import javax.faces.event.ValueChangeListener;
import javax.faces.view.facelets.ComponentHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import javax.faces.view.facelets.TagHandler;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Messages;

public class ValidateUniqueColumn
extends TagHandler
implements ValueChangeListener {
    private static final String DEFAULT_MESSAGE = "{0}: Please fill out an unique value for the entire column. Duplicate found in row {1}";
    private static final String ERROR_INVALID_PARENT = "Parent component of o:validateUniqueColumn must be an instance of UIInput. Encountered invalid type '%s'.";
    private static final String ERROR_INVALID_PARENT_PARENT = "Parent component of o:validateUniqueColumn must be enclosed in an UIData component.";
    private ValueExpression message;
    private ValueExpression disabled;

    public ValidateUniqueColumn(TagConfig config) {
        super(config);
    }

    public void apply(FaceletContext context2, UIComponent parent) throws IOException {
        if (!ComponentHandler.isNew((UIComponent)parent)) {
            if (Components.getClosestParent(parent, UIData.class) == null) {
                throw new IllegalArgumentException(ERROR_INVALID_PARENT_PARENT);
            }
            return;
        }
        if (!(parent instanceof UIInput)) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_PARENT, parent.getClass().getName()));
        }
        this.message = this.getValueExpression("message", context2);
        this.disabled = this.getValueExpression("disabled", context2);
        ((UIInput)parent).addValueChangeListener((ValueChangeListener)this);
    }

    private ValueExpression getValueExpression(String attributeName, FaceletContext context2) {
        TagAttribute attribute = this.getAttribute(attributeName);
        if (attribute != null) {
            return attribute.getValueExpression(context2, Object.class);
        }
        return null;
    }

    public void processValueChange(ValueChangeEvent event) {
        if (this.isDisabled()) {
            return;
        }
        UIInput input = (UIInput)event.getComponent();
        if (!input.isValid() || input.getLocalValue() == null) {
            return;
        }
        UIData table = Components.getClosestParent((UIComponent)input, UIData.class);
        int originalRows = table.getRows();
        table.setRows(0);
        FacesContext context2 = FacesContext.getCurrentInstance();
        UniqueColumnValueChecker checker = new UniqueColumnValueChecker(table, input);
        table.visitTree(VisitContext.createVisitContext((FacesContext)context2), (VisitCallback)checker);
        table.setRows(originalRows);
        if (checker.isDuplicate()) {
            input.setValid(false);
            context2.validationFailed();
            Messages.addError(input.getClientId(context2), this.getMessage(), Components.getLabel((UIComponent)input), checker.getDuplicateIndex() + 1);
        }
    }

    public String getMessage() {
        return ValidateUniqueColumn.getValue(this.message, DEFAULT_MESSAGE);
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            return false;
        }
        if (this.disabled.isLiteralText()) {
            return Boolean.parseBoolean(this.disabled.getExpressionString());
        }
        return ValidateUniqueColumn.getValue(this.disabled, false);
    }

    private static <T> T getValue(ValueExpression expression, T defaultValue) {
        Object value;
        if (expression != null && (value = expression.getValue(Faces.getELContext())) != null) {
            return (T)value;
        }
        return defaultValue;
    }

    private static class UniqueColumnValueChecker
    implements VisitCallback {
        private UIData table;
        private int rowIndex;
        private UIInput input;
        private Object value;
        private boolean duplicate;
        private int duplicateIndex;

        public UniqueColumnValueChecker(UIData table, UIInput input) {
            this.table = table;
            this.rowIndex = table.getRowIndex();
            this.input = input;
            this.value = input.getLocalValue();
        }

        public VisitResult visit(VisitContext context2, UIComponent target) {
            if (target == this.input && this.rowIndex != this.table.getRowIndex() && this.input.isValid() && this.value.equals(this.input.getLocalValue())) {
                this.duplicate = true;
                this.duplicateIndex = this.table.getRowIndex();
                return VisitResult.COMPLETE;
            }
            return VisitResult.ACCEPT;
        }

        public boolean isDuplicate() {
            return this.duplicate;
        }

        public int getDuplicateIndex() {
            return this.duplicateIndex;
        }
    }
}

