/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.taghandler;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.el.ELContext;
import javax.el.ValueExpression;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.view.AttachedObjectHandler;
import javax.faces.view.facelets.DelegatingMetaTagHandler;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.MetaRuleset;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagHandlerDelegate;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Reflection;

final class DeferredTagHandlerHelper {
    private static final String ERROR_MISSING_ID = "o:%1$s '%1$sId' or 'binding' attribute must be specified.";
    private static final String ERROR_INVALID_ID = "o:%1$s '%1$sId' attribute must refer an valid %1$s ID. The %1$s ID '%2$s' cannot be found.";

    private DeferredTagHandlerHelper() {
    }

    static <T> T createInstance(ELContext context2, ValueExpression binding, ValueExpression id, Function<String, T> factory, String name) {
        Object instance = null;
        if (binding != null) {
            instance = binding.getValue(context2);
        }
        if (id != null) {
            try {
                instance = factory.apply((String)id.getValue(context2));
            }
            catch (FacesException e2) {
                throw new IllegalArgumentException(String.format(ERROR_INVALID_ID, name, id), e2);
            }
            if (binding != null) {
                binding.setValue(context2, instance);
            }
        } else if (instance == null) {
            throw new IllegalArgumentException(String.format(ERROR_MISSING_ID, name));
        }
        return (T)instance;
    }

    static <T> DeferredAttributes collectDeferredAttributes(FaceletContext context2, DeferredTagHandler tag, T instance) {
        DeferredAttributes attributes = new DeferredAttributes();
        try {
            for (PropertyDescriptor property : Introspector.getBeanInfo(instance.getClass()).getPropertyDescriptors()) {
                Method setter = property.getWriteMethod();
                ValueExpression valueExpression = DeferredTagHandlerHelper.getValueExpression(context2, tag, property.getName(), property.getPropertyType());
                if (setter == null || valueExpression == null) continue;
                if (valueExpression.isLiteralText()) {
                    setter.invoke(instance, valueExpression.getValue((ELContext)context2));
                    continue;
                }
                attributes.add(setter, valueExpression);
            }
        }
        catch (Exception e2) {
            throw new FacesException((Throwable)e2);
        }
        return attributes;
    }

    static <T> ValueExpression getValueExpression(FaceletContext context2, DeferredTagHandler tag, String name, Class<T> type) {
        TagAttribute attribute = tag.getTagAttribute(name);
        return attribute != null ? attribute.getValueExpression(context2, type) : null;
    }

    static class DeferredTagHandlerDelegate
    extends TagHandlerDelegate
    implements AttachedObjectHandler {
        private DelegatingMetaTagHandler tag;
        private TagHandlerDelegate delegate;

        public DeferredTagHandlerDelegate(DelegatingMetaTagHandler tag, TagHandlerDelegate delegate) {
            this.tag = tag;
            this.delegate = delegate;
        }

        public void apply(FaceletContext context2, UIComponent component) throws IOException {
            this.delegate.apply(context2, component);
        }

        public String getFor() {
            return ((AttachedObjectHandler)this.delegate).getFor();
        }

        public void applyAttachedObject(FacesContext context2, UIComponent parent) {
            try {
                this.tag.apply(FacesLocal.getFaceletContext(context2), parent);
            }
            catch (IOException e2) {
                throw new FacesException((Throwable)e2);
            }
        }

        public MetaRuleset createMetaRuleset(Class type) {
            return this.delegate.createMetaRuleset(type);
        }
    }

    static final class DeferredAttributes
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Map<String, ValueExpression> attributes = new HashMap<String, ValueExpression>();

        private DeferredAttributes() {
        }

        private void add(Method setter, ValueExpression valueExpression) {
            this.attributes.put(setter.getName(), valueExpression);
        }

        public void invokeSetters(ELContext elContext, Object object) {
            for (Map.Entry<String, ValueExpression> entry : this.attributes.entrySet()) {
                try {
                    Reflection.invokeMethod(object, entry.getKey(), entry.getValue().getValue(elContext));
                }
                catch (Exception e2) {
                    throw new FacesException((Throwable)e2);
                }
            }
        }
    }

    static interface DeferredTagHandler {
        public TagAttribute getTagAttribute(String var1);
    }
}

