/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.faces.application.Resource;
import javax.faces.application.ViewHandler;
import javax.faces.application.ViewVisitOption;
import javax.faces.context.FacesContext;
import org.omnifaces.config.WebXml;
import org.omnifaces.resourcehandler.ResourceIdentifier;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Utils;

public abstract class WebAppManifest {
    private Collection<String> cacheableViewIds;

    public abstract String getName();

    public abstract Collection<ImageResource> getIcons();

    public String getLang() {
        return Utils.coalesce(Faces.getDefaultLocale(), Locale.getDefault()).toLanguageTag();
    }

    public Dir getDir() {
        return Dir.AUTO;
    }

    public Display getDisplay() {
        return Display.BROWSER;
    }

    public Orientation getOrientation() {
        return Orientation.ANY;
    }

    public String getStartUrl() {
        return Faces.getRequestBaseURL();
    }

    protected Collection<String> getCacheableViewIds() {
        if (this.cacheableViewIds == null) {
            FacesContext context2 = Faces.getContext();
            String contextPath = FacesLocal.getRequestContextPath(context2);
            Set welcomeFileURLs = WebXml.instance().getWelcomeFiles().stream().map(welcomeFile -> contextPath + ResourcePaths.addLeadingSlashIfNecessary(welcomeFile)).collect(Collectors.toSet());
            welcomeFileURLs.add(contextPath + "/");
            ViewHandler viewHandler = context2.getApplication().getViewHandler();
            this.cacheableViewIds = viewHandler.getViews(context2, "/", new ViewVisitOption[0]).filter(viewId -> welcomeFileURLs.contains(viewHandler.getActionURL(context2, viewId))).collect(Collectors.toSet());
        }
        return this.cacheableViewIds;
    }

    protected String getOfflineViewId() {
        return null;
    }

    public String getScope() {
        return null;
    }

    public String getShortName() {
        return null;
    }

    public String getDescription() {
        return null;
    }

    public String getThemeColor() {
        return null;
    }

    public String getBackgroundColor() {
        return null;
    }

    public Collection<Category> getCategories() {
        return Collections.emptySet();
    }

    public String getIarcRatingId() {
        return null;
    }

    public Collection<RelatedApplication> getRelatedApplications() {
        return Collections.emptySet();
    }

    public boolean isPreferRelatedApplications() {
        return false;
    }

    protected static final class RelatedApplication {
        private Platform platform;
        private String url;
        private String id;

        private RelatedApplication(Platform platform, String url, String id) {
            Objects.requireNonNull(platform, "platform");
            Objects.requireNonNull(url, "url");
            this.platform = platform;
            this.url = url;
            this.id = id;
        }

        public static RelatedApplication of(Platform platform, String url) {
            return RelatedApplication.of(platform, url, null);
        }

        public static RelatedApplication of(Platform platform, String url, String id) {
            return new RelatedApplication(platform, url, id);
        }

        public Platform getPlatform() {
            return this.platform;
        }

        public String getUrl() {
            return this.url;
        }

        public String getId() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            RelatedApplication other = (RelatedApplication)object;
            return Objects.equals((Object)this.platform, (Object)other.platform) && Objects.equals(this.url, other.url) && Objects.equals(this.id, other.id);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.platform, this.url, this.id});
        }
    }

    protected static final class Size {
        public static final Size SIZE_16 = Size.of(16);
        public static final Size SIZE_32 = Size.of(32);
        public static final Size SIZE_48 = Size.of(48);
        public static final Size SIZE_64 = Size.of(64);
        public static final Size SIZE_72 = Size.of(72);
        public static final Size SIZE_96 = Size.of(96);
        public static final Size SIZE_120 = Size.of(120);
        public static final Size SIZE_128 = Size.of(128);
        public static final Size SIZE_144 = Size.of(144);
        public static final Size SIZE_152 = Size.of(152);
        public static final Size SIZE_168 = Size.of(168);
        public static final Size SIZE_180 = Size.of(180);
        public static final Size SIZE_192 = Size.of(192);
        public static final Size SIZE_256 = Size.of(256);
        public static final Size SIZE_384 = Size.of(384);
        public static final Size SIZE_512 = Size.of(512);
        private String value;

        private Size(int width, int height) {
            this.value = width + "x" + height;
        }

        public static Size of(int value) {
            if (value <= 0) {
                throw new IllegalArgumentException("size");
            }
            return new Size(value, value);
        }

        public static Size of(int width, int height) {
            if (width <= 0) {
                throw new IllegalArgumentException("width");
            }
            if (height <= 0) {
                throw new IllegalArgumentException("height");
            }
            return new Size(width, height);
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            Size other = (Size)object;
            return Objects.equals(this.value, other.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }

    protected static final class ImageResource {
        private String src;
        private String sizes;
        private String type;

        private ImageResource(String resourceIdentifier, Size ... sizes) {
            Objects.requireNonNull(resourceIdentifier, "resourceIdentifier");
            FacesContext context2 = Faces.getContext();
            Resource resource = FacesLocal.createResource(context2, new ResourceIdentifier(resourceIdentifier));
            if (resource == null) {
                throw new IllegalArgumentException("Cannot find resource '" + resourceIdentifier + "'");
            }
            String requestPath = resource.getRequestPath();
            URLConnection connection = Utils.openConnection(context2, resource);
            if (connection != null) {
                requestPath = Utils.formatURLWithQueryString(requestPath, "v=" + connection.getLastModified());
            }
            this.src = requestPath;
            this.sizes = Arrays.stream(sizes).map(Size::getValue).distinct().collect(Collectors.joining(" "));
            this.type = resource.getContentType();
        }

        public static ImageResource of(String resourceIdentifier, Size ... sizes) {
            return new ImageResource(resourceIdentifier, sizes);
        }

        public String getSrc() {
            return this.src;
        }

        public String getSizes() {
            return this.sizes;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object == null || object.getClass() != this.getClass()) {
                return false;
            }
            ImageResource other = (ImageResource)object;
            return Objects.equals(this.src, other.src) && Objects.equals(this.sizes, other.sizes) && Objects.equals(this.type, other.type);
        }

        public int hashCode() {
            return Objects.hash(this.src, this.sizes, this.type);
        }
    }

    protected static enum Platform {
        CHROME_WEB_STORE,
        PLAY,
        ITUNES,
        WINDOWS;

        private final String value = this.name().toLowerCase().replace('_', '-');

        public String toString() {
            return this.value;
        }
    }

    protected static enum Category {
        BOOKS,
        BUSINESS,
        EDUCATION,
        ENTERTAINMENT,
        FINANCE,
        FITNESS,
        FOOD,
        GAMES,
        GOVERNMENT,
        HEALTH,
        KIDS,
        LIFESTYLE,
        MAGAZINES,
        MEDICAL,
        MUSIC,
        NAVIGATION,
        NEWS,
        PERSONALIZATION,
        PHOTO,
        POLITICS,
        PRODUCTIVITY,
        SECURITY,
        SHOPPING,
        SOCIAL,
        SPORTS,
        TRAVEL,
        UTILITIES,
        WEATHER;

        private final String value = this.name().toLowerCase();

        public String toString() {
            return this.value;
        }
    }

    protected static enum Orientation {
        ANY,
        NATURAL,
        LANDSCAPE,
        LANDSCAPE_PRIMARY,
        LANDSCAPE_SECONDARY,
        PORTRAIT,
        PORTRAIT_PRIMARY,
        PORTRAIT_SECONDARY;

        private final String value = this.name().toLowerCase().replace('_', '-');

        public String toString() {
            return this.value;
        }
    }

    protected static enum Display {
        FULLSCREEN,
        STANDALONE,
        MINIMAL_UI,
        BROWSER;

        private final String value = this.name().toLowerCase().replace('_', '-');

        public String toString() {
            return this.value;
        }
    }

    protected static enum Dir {
        LTR,
        RTL,
        AUTO;

        private final String value = this.name().toLowerCase();

        public String toString() {
            return this.value;
        }
    }
}

