/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.faces.FacesException;
import javax.faces.application.Resource;
import javax.faces.application.ResourceWrapper;
import javax.faces.context.FacesContext;

public class RemappedResource
extends ResourceWrapper
implements Externalizable {
    private Serializable serializableResource;
    private transient Resource resource;
    private String resourceName;
    private String libraryName;
    private String requestPath;

    public RemappedResource() {
    }

    public RemappedResource(Resource resource, String requestPath) {
        super(resource);
        if (resource instanceof Serializable) {
            this.serializableResource = (Serializable)resource;
        }
        this.resource = resource;
        this.requestPath = requestPath;
    }

    public RemappedResource(String resourceName, String libraryName, String requestPath) {
        super(null);
        this.resourceName = resourceName;
        this.libraryName = libraryName;
        this.requestPath = requestPath;
    }

    public Resource getWrapped() {
        return this.resource;
    }

    public String getResourceName() {
        Resource wrapped = this.getWrapped();
        return wrapped != null ? wrapped.getResourceName() : this.resourceName;
    }

    public void setResourceName(String resourceName) {
        String previousResourceName = this.getResourceName();
        Resource wrapped = this.getWrapped();
        if (wrapped != null) {
            wrapped.setResourceName(resourceName);
        } else {
            this.resourceName = resourceName;
        }
        this.requestPath = this.requestPath.replaceFirst(Pattern.quote("/" + previousResourceName), "/" + resourceName);
    }

    public String getLibraryName() {
        Resource wrapped = this.getWrapped();
        return wrapped != null ? wrapped.getLibraryName() : this.libraryName;
    }

    public void setLibraryName(String libraryName) {
        String previousLibraryName = this.getLibraryName();
        Resource wrapped = this.getWrapped();
        if (wrapped != null) {
            wrapped.setLibraryName(libraryName);
        } else {
            this.libraryName = libraryName;
        }
        String queryParam = (this.requestPath.contains("?ln=") ? "?" : "&") + "ln=";
        this.requestPath = this.requestPath.replaceFirst(Pattern.quote(queryParam + previousLibraryName), queryParam + libraryName);
    }

    public String getContentType() {
        Resource wrapped = this.getWrapped();
        return wrapped != null ? wrapped.getContentType() : null;
    }

    public String getRequestPath() {
        return this.requestPath;
    }

    public InputStream getInputStream() throws IOException {
        Resource wrapped = this.getWrapped();
        return wrapped != null ? wrapped.getInputStream() : this.getURL().openStream();
    }

    public Map<String, String> getResponseHeaders() {
        Resource wrapped = this.getWrapped();
        return wrapped != null ? wrapped.getResponseHeaders() : Collections.emptyMap();
    }

    public URL getURL() {
        try {
            Resource wrapped = this.getWrapped();
            return wrapped != null ? wrapped.getURL() : new URL(this.requestPath);
        }
        catch (MalformedURLException e2) {
            throw new FacesException((Throwable)e2);
        }
    }

    public boolean userAgentNeedsUpdate(FacesContext context2) {
        Resource wrapped = this.getWrapped();
        return wrapped != null && wrapped.userAgentNeedsUpdate(context2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        RemappedResource other = (RemappedResource)object;
        Resource wrapped = this.getWrapped();
        return Objects.equals(wrapped, other.getWrapped()) && this.requestPath.equals(other.requestPath);
    }

    public int hashCode() {
        Resource wrapped = this.getWrapped();
        return Objects.hash(wrapped, this.requestPath);
    }

    @Override
    public void readExternal(ObjectInput input) throws IOException, ClassNotFoundException {
        this.serializableResource = (Serializable)input.readObject();
        this.resource = (Resource)this.serializableResource;
        this.resourceName = (String)input.readObject();
        this.libraryName = (String)input.readObject();
        this.requestPath = (String)input.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput output) throws IOException {
        output.writeObject(this.serializableResource);
        output.writeObject(this.resourceName);
        output.writeObject(this.libraryName);
        output.writeObject(this.requestPath);
    }
}

