/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.faces.application.Resource;
import javax.faces.context.FacesContext;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Hacks;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Utils;

public abstract class DynamicResource
extends Resource {
    private static final int RESPONSE_HEADERS_SIZE = 4;
    private long lastModified;

    protected DynamicResource(String resourceName, String libraryName, String contentType) {
        this.setResourceName(resourceName);
        this.setLibraryName(libraryName);
        this.setContentType(contentType);
    }

    public String getRequestPath() {
        String mapping = Faces.getMapping();
        String path = ResourcePaths.concat("/javax.faces.resource", this.getResourceName());
        return Faces.getRequestContextPath() + (Faces.isPrefixMapping(mapping) ? mapping + path : path + mapping) + "?ln=" + this.getLibraryName() + "&v=" + this.getLastModified();
    }

    public URL getURL() {
        try {
            return new URL(Faces.getRequestDomainURL() + this.getRequestPath());
        }
        catch (MalformedURLException e2) {
            throw new UnsupportedOperationException(e2);
        }
    }

    public Map<String, String> getResponseHeaders() {
        HashMap<String, String> responseHeaders = new HashMap<String, String>(4);
        responseHeaders.put("Last-Modified", Utils.formatRFC1123(new Date(this.getLastModified())));
        responseHeaders.put("Expires", Utils.formatRFC1123(new Date(System.currentTimeMillis() + Hacks.getDefaultResourceMaxAge())));
        responseHeaders.put("Etag", String.format("W/\"%d-%d\"", this.getResourceName().hashCode(), this.getLastModified()));
        responseHeaders.put("Pragma", "");
        return responseHeaders;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public boolean userAgentNeedsUpdate(FacesContext context2) {
        String ifModifiedSince = (String)context2.getExternalContext().getRequestHeaderMap().get("If-Modified-Since");
        if (ifModifiedSince != null) {
            try {
                return this.getLastModified() > Utils.parseRFC1123(ifModifiedSince).getTime() + TimeUnit.SECONDS.toMillis(1L);
            }
            catch (ParseException ignore) {
                return true;
            }
        }
        return true;
    }
}

