/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.resourcehandler;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.Resource;
import org.omnifaces.util.Faces;
import org.omnifaces.util.Utils;

public final class CombinedResourceInputStream
extends InputStream {
    private static final Logger logger = Logger.getLogger(CombinedResourceInputStream.class.getName());
    private static final byte[] CRLF = new byte[]{13, 10};
    private List<InputStream> streams = new ArrayList<InputStream>();
    private Iterator<InputStream> streamIterator;
    private InputStream currentStream;

    public CombinedResourceInputStream(Set<Resource> resources) throws IOException {
        String domainURL = Faces.getRequestDomainURL();
        for (Resource resource : resources) {
            InputStream stream;
            try {
                stream = resource.getInputStream();
            }
            catch (Exception richFacesDoesNotSupportThis) {
                logger.log(Level.FINEST, "Ignoring thrown exception; this can only be caused by a buggy component library.", richFacesDoesNotSupportThis);
                stream = new URL(domainURL + resource.getRequestPath()).openStream();
            }
            this.streams.add(stream);
            this.streams.add(new ByteArrayInputStream(CRLF));
        }
        this.streamIterator = this.streams.iterator();
        if (this.streamIterator.hasNext()) {
            this.currentStream = this.streamIterator.next();
        }
    }

    @Override
    public int read() throws IOException {
        int read;
        while ((read = this.currentStream.read()) == -1 && this.streamIterator.hasNext()) {
            this.currentStream = this.streamIterator.next();
        }
        return read;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int read;
        while ((read = this.currentStream.read(b, offset, length)) == -1 && this.streamIterator.hasNext()) {
            this.currentStream = this.streamIterator.next();
        }
        return read;
    }

    @Override
    public void close() throws IOException {
        IOException caught = null;
        for (InputStream stream : this.streams) {
            IOException e2 = Utils.close(stream);
            if (caught != null) continue;
            caught = e2;
        }
        if (caught != null) {
            throw caught;
        }
    }
}

