/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.facesviews;

import java.io.IOException;
import java.util.Map;
import javax.faces.application.ProjectStage;
import javax.servlet.FilterChain;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.omnifaces.facesviews.ExtensionAction;
import org.omnifaces.facesviews.FacesViews;
import org.omnifaces.facesviews.PathAction;
import org.omnifaces.facesviews.UriExtensionRequestWrapper;
import org.omnifaces.filter.HttpFilter;
import org.omnifaces.util.Faces;
import org.omnifaces.util.ResourcePaths;
import org.omnifaces.util.Servlets;

public class FacesViewsForwardingFilter
extends HttpFilter {
    private ExtensionAction extensionAction;
    private PathAction pathAction;

    @Override
    public void init() throws ServletException {
        ServletContext servletContext = this.getServletContext();
        try {
            this.extensionAction = FacesViews.getExtensionAction(servletContext);
            this.pathAction = FacesViews.getPathAction(servletContext);
        }
        catch (IllegalStateException e2) {
            throw new ServletException((Throwable)e2);
        }
    }

    @Override
    public void doFilter(HttpServletRequest request, HttpServletResponse response, HttpSession session, FilterChain chain) throws ServletException, IOException {
        if (!(this.filterExtensionLess(request, response, chain) || this.filterExtension(request, response) || this.filterPublicPath(request, response))) {
            chain.doFilter((ServletRequest)request, (ServletResponse)response);
        }
    }

    private boolean filterExtensionLess(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        String servletPath = request.getServletPath();
        if (!ResourcePaths.isExtensionless(servletPath)) {
            return false;
        }
        ServletContext servletContext = this.getServletContext();
        boolean multiViews = FacesViews.isMultiViewsEnabled(request);
        Map<String, String> resources = FacesViews.getMappedResources(servletContext);
        String normalizedServletPath = ResourcePaths.stripTrailingSlash(servletPath);
        String resource = normalizedServletPath + (multiViews ? "/*" : "");
        if (Faces.getApplicationFromFactory().getProjectStage() == ProjectStage.Development && !resources.containsKey(resource)) {
            resources = FacesViews.scanAndStoreViews(servletContext, false);
        }
        if (multiViews && !resources.containsKey(resource)) {
            if (request.getPathInfo() != null) {
                servletPath = servletPath + request.getPathInfo();
            }
            if ((resource = FacesViews.getMultiViewsWelcomeFile(servletContext, resources, servletPath)) != null) {
                String pathInfo = servletPath.substring(resource.substring(0, resource.lastIndexOf(47)).length());
                request.setAttribute("org.omnifaces.facesviews.original.path_info", (Object)(pathInfo.isEmpty() ? "/" : pathInfo));
                request.getRequestDispatcher(resource).forward((ServletRequest)request, (ServletResponse)response);
                return true;
            }
        }
        return this.filterExtensionLess(request, response, chain, resources, resource, normalizedServletPath);
    }

    private boolean filterExtensionLess(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Map<String, String> resources, String resource, String path) throws IOException, ServletException {
        if (resources.containsKey(resource)) {
            if (this.redirectExtensionLessWelcomeFileToFolderIfNecessary(request, response, path)) {
                return true;
            }
            String servletPathWithExtension = path + ResourcePaths.getExtension(resources.get(resource));
            if (resources.containsKey(servletPathWithExtension)) {
                this.filterExtensionLessToExtension(request, response, chain, servletPathWithExtension);
                return true;
            }
            if (this.forwardExtensionLessToExtensionIfNecessary(request, response, servletPathWithExtension)) {
                return true;
            }
        }
        return false;
    }

    private boolean redirectExtensionLessWelcomeFileToFolderIfNecessary(HttpServletRequest request, HttpServletResponse response, String normalizedServletPath) {
        String normalizedResource;
        String servletPath;
        if ((Servlets.getRequestRelativeURI(request) + "/").startsWith(normalizedServletPath + "/") && !(servletPath = request.getServletPath()).equals(normalizedResource = FacesViews.stripWelcomeFilePrefix(request.getServletContext(), servletPath))) {
            String uri = request.getContextPath() + normalizedResource;
            String queryString = request.getQueryString();
            Servlets.redirectPermanent(response, uri + (queryString != null ? "?" + queryString : ""));
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void filterExtensionLessToExtension(HttpServletRequest request, HttpServletResponse response, FilterChain chain, String mappedServletPath) throws IOException, ServletException {
        try {
            request.setAttribute("org.omnifaces.facesviews.original.servlet_path", (Object)request.getServletPath());
            String pathInfo = request.getPathInfo();
            if (pathInfo != null) {
                request.setAttribute("org.omnifaces.facesviews.original.path_info", (Object)pathInfo);
            }
            chain.doFilter((ServletRequest)new UriExtensionRequestWrapper(request, mappedServletPath), (ServletResponse)response);
        }
        finally {
            request.removeAttribute("org.omnifaces.facesviews.original.servlet_path");
            request.removeAttribute("org.omnifaces.facesviews.original.path_info");
        }
    }

    private boolean forwardExtensionLessToExtensionIfNecessary(HttpServletRequest request, HttpServletResponse response, String servletPathWithExtension) throws ServletException, IOException {
        RequestDispatcher requestDispatcher = request.getServletContext().getRequestDispatcher(servletPathWithExtension);
        if (requestDispatcher != null) {
            requestDispatcher.forward((ServletRequest)request, (ServletResponse)response);
            return true;
        }
        return false;
    }

    private boolean filterExtension(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resource = request.getServletPath();
        Map<String, String> resources = FacesViews.getMappedResources(this.getServletContext());
        if (resources.containsKey(resource)) {
            if (resources.get(resource) != null) {
                if (this.extensionAction == ExtensionAction.REDIRECT_TO_EXTENSIONLESS) {
                    Servlets.redirectPermanent(response, FacesViews.getExtensionlessURLWithQuery(request, resource));
                    return true;
                }
                if (this.extensionAction == ExtensionAction.PROCEED) {
                    return false;
                }
            }
            response.sendError(404);
            return true;
        }
        return false;
    }

    private boolean filterPublicPath(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String resource = request.getServletPath();
        if (!FacesViews.isResourceInPublicPath(this.getServletContext(), resource)) {
            return false;
        }
        Map<String, String> reverseResources = FacesViews.getReverseMappedResources(this.getServletContext());
        if (reverseResources.containsKey(resource)) {
            switch (this.pathAction) {
                case REDIRECT_TO_SCANNED_EXTENSIONLESS: {
                    Servlets.redirectPermanent(response, FacesViews.getExtensionlessURLWithQuery(request, reverseResources.get(resource)));
                    return true;
                }
                case SEND_404: {
                    response.sendError(404);
                    return true;
                }
            }
        }
        return false;
    }
}

