/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.exceptionhandler;

import java.util.Iterator;
import java.util.Optional;
import javax.faces.context.ExceptionHandler;
import javax.faces.context.ExceptionHandlerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.event.ExceptionQueuedEvent;
import javax.servlet.ServletContext;
import org.omnifaces.exceptionhandler.FullAjaxExceptionHandler;
import org.omnifaces.util.Exceptions;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;

public class ExceptionSuppressor
extends ExceptionHandlerWrapper {
    public static final String PARAM_NAME_EXCEPTION_TYPES_TO_SUPPRESS = "org.omnifaces.EXCEPTION_TYPES_TO_SUPPRESS";
    private Class<? extends Throwable>[] exceptionTypesToSuppress;

    public ExceptionSuppressor(ExceptionHandler wrapped) {
        this(wrapped, ExceptionSuppressor.getExceptionTypesToSuppress(Faces.getServletContext()));
    }

    @SafeVarargs
    protected ExceptionSuppressor(ExceptionHandler wrapped, Class<? extends Throwable> ... exceptionTypesToSuppress) {
        super(wrapped);
        this.exceptionTypesToSuppress = exceptionTypesToSuppress;
    }

    public static Class<? extends Throwable>[] getExceptionTypesToSuppress(ServletContext context2) {
        return FullAjaxExceptionHandler.parseExceptionTypesParam(context2, PARAM_NAME_EXCEPTION_TYPES_TO_SUPPRESS, null);
    }

    public void handle() {
        this.handleSuppressedException(Faces.getContext());
        this.getWrapped().handle();
    }

    private void handleSuppressedException(FacesContext context2) {
        if (context2 == null) {
            return;
        }
        Optional<Throwable> suppressedException = this.findSuppressedException();
        if (!suppressedException.isPresent()) {
            return;
        }
        this.handleSuppressedException(context2, suppressedException.get());
        if (!Faces.isResponseComplete() && !FacesLocal.isResponseCommitted(context2)) {
            Faces.refreshWithQueryString();
        }
        Iterator iter = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    protected void handleSuppressedException(FacesContext context2, Throwable suppressedException) {
    }

    private Optional<Throwable> findSuppressedException() {
        Iterator iter = this.getUnhandledExceptionQueuedEvents().iterator();
        while (iter.hasNext()) {
            Throwable unhandledException = ((ExceptionQueuedEvent)iter.next()).getContext().getException();
            for (Class<? extends Throwable> exceptionTypeToSuppress : this.exceptionTypesToSuppress) {
                if (!Exceptions.is(unhandledException, exceptionTypeToSuppress)) continue;
                return Optional.of(unhandledException);
            }
        }
        return Optional.empty();
    }
}

