/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.el;

import java.beans.Introspector;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.MethodExpression;
import javax.el.MethodNotFoundException;
import javax.el.ValueExpression;
import javax.el.ValueReference;
import javax.faces.el.CompositeComponentExpressionHolder;
import org.omnifaces.el.ELContextWrapper;
import org.omnifaces.el.ELResolverWrapper;
import org.omnifaces.el.MethodExpressionValueExpressionAdapter;
import org.omnifaces.el.MethodReference;
import org.omnifaces.el.functions.Strings;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Components;
import org.omnifaces.util.Reflection;

public final class ExpressionInspector {
    private ExpressionInspector() {
    }

    public static ValueReference getValueReference(ELContext context2, ValueExpression valueExpression) {
        InspectorElContext inspectorElContext = new InspectorElContext(context2);
        Class type = valueExpression.getType((ELContext)inspectorElContext);
        if (type != null && MethodExpression.class.isAssignableFrom(type)) {
            MethodReference methodReference = ExpressionInspector.getMethodReference((ELContext)inspectorElContext, valueExpression);
            Object base = methodReference.getBase();
            String property = Introspector.decapitalize(methodReference.getName().replaceFirst("(get|is)", ""));
            return new ValueReference(base, (Object)property);
        }
        inspectorElContext.setPass(InspectorPass.PASS2_FIND_FINAL_NODE);
        valueExpression.getValue((ELContext)inspectorElContext);
        Object base = Beans.unwrapIfNecessary(inspectorElContext.getBase());
        Object property = inspectorElContext.getProperty();
        if (base instanceof CompositeComponentExpressionHolder) {
            return ExpressionInspector.getValueReference(context2, ((CompositeComponentExpressionHolder)base).getExpression(property.toString()));
        }
        return new ValueReference(base, property);
    }

    public static MethodReference getMethodReference(ELContext context2, ValueExpression valueExpression) {
        InspectorElContext inspectorElContext = new InspectorElContext(context2);
        Class type = valueExpression.getType((ELContext)inspectorElContext);
        if (type != null && MethodExpression.class.isAssignableFrom(type)) {
            return ExpressionInspector.getMethodReference((ELContext)inspectorElContext, (MethodExpression)valueExpression.getValue((ELContext)inspectorElContext));
        }
        inspectorElContext.setPass(InspectorPass.PASS2_FIND_FINAL_NODE);
        ValueExpressionType valueExpressionType = (ValueExpressionType)((Object)valueExpression.getValue((ELContext)inspectorElContext));
        Object base = Beans.unwrapIfNecessary(inspectorElContext.getBase());
        String property = inspectorElContext.getProperty().toString();
        boolean fromMethod = valueExpressionType == ValueExpressionType.METHOD;
        Object[] params = fromMethod ? inspectorElContext.getParams() : MethodReference.NO_PARAMS;
        String methodName = fromMethod ? property : "get" + Strings.capitalize(property);
        Method method = Reflection.findMethod(base, methodName, params);
        if (method == null && !fromMethod && (method = Reflection.findMethod(base, "is" + Strings.capitalize(property), params)) == null && (method = Reflection.findMethod(base, property, MethodReference.NO_PARAMS)) != null) {
            fromMethod = true;
        }
        if (method == null) {
            throw new MethodNotFoundException(base + "." + methodName + " " + valueExpression);
        }
        return new MethodReference(base, method, params, fromMethod);
    }

    public static MethodReference getMethodReference(ELContext context2, MethodExpression methodExpression) {
        MethodExpressionValueExpressionAdapter adapter = null;
        adapter = methodExpression instanceof MethodExpressionValueExpressionAdapter ? (MethodExpressionValueExpressionAdapter)methodExpression : new MethodExpressionValueExpressionAdapter(Components.createValueExpression(methodExpression.getExpressionString(), Object.class));
        return (MethodReference)adapter.getMethodInfo(context2);
    }

    static class InspectorElResolver
    extends ELResolverWrapper {
        private int passOneCallCount;
        private int passTwoCallCount;
        private Object lastBase;
        private Object lastProperty;
        private Object[] lastParams;
        private Object lastOutcome;
        private boolean subchainResolving;
        private FinalBaseHolder finalBaseHolder;
        private InspectorPass pass = InspectorPass.PASS1_FIND_NEXT_TO_LAST_NODE;

        public InspectorElResolver(ELResolver elResolver) {
            super(elResolver);
        }

        @Override
        public Object getValue(ELContext context2, Object base, Object property) {
            if (base instanceof FinalBaseHolder || property instanceof FinalBaseHolder) {
                this.lastBase = base instanceof FinalBaseHolder ? ((FinalBaseHolder)base).getBase() : base;
                this.lastProperty = property instanceof FinalBaseHolder ? ((FinalBaseHolder)property).getBase() : property;
                context2.setPropertyResolved(true);
                return ValueExpressionType.PROPERTY;
            }
            this.checkSubchainStarted(base);
            this.lastOutcome = super.getValue(context2, base, property);
            if (this.subchainResolving) {
                return this.lastOutcome;
            }
            this.recordCall(base, property);
            return this.wrapOutcomeIfNeeded(this.lastOutcome);
        }

        @Override
        public Object invoke(ELContext context2, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
            if (base instanceof FinalBaseHolder) {
                this.lastBase = ((FinalBaseHolder)base).getBase();
                this.lastProperty = method;
                this.lastParams = params;
                context2.setPropertyResolved(true);
                return ValueExpressionType.METHOD;
            }
            this.checkSubchainStarted(base);
            this.lastOutcome = super.invoke(context2, base, method, paramTypes, params);
            if (this.subchainResolving) {
                return this.lastOutcome;
            }
            this.recordCall(base, method);
            return this.wrapOutcomeIfNeeded(this.lastOutcome);
        }

        @Override
        public Class<?> getType(ELContext context2, Object base, Object property) {
            context2.setPropertyResolved(true);
            return InspectorElContext.class;
        }

        private boolean isAtNextToLastNode() {
            return this.passTwoCallCount == this.passOneCallCount;
        }

        private void checkSubchainStarted(Object base) {
            if (this.pass == InspectorPass.PASS2_FIND_FINAL_NODE && base == null && this.isAtNextToLastNode()) {
                this.subchainResolving = true;
            }
        }

        private void recordCall(Object base, Object property) {
            if (this.pass == InspectorPass.PASS1_FIND_NEXT_TO_LAST_NODE) {
                ++this.passOneCallCount;
                this.lastBase = base;
                this.lastProperty = property;
            } else if (this.pass == InspectorPass.PASS2_FIND_FINAL_NODE) {
                ++this.passTwoCallCount;
                if (!(this.passTwoCallCount != this.passOneCallCount || base == this.lastBase && Objects.equals(property, this.lastProperty))) {
                    throw new IllegalStateException("First and second pass of resolver at call #" + this.passTwoCallCount + " resolved to different base or property.");
                }
            }
        }

        private Object wrapOutcomeIfNeeded(Object outcome) {
            if (this.pass == InspectorPass.PASS2_FIND_FINAL_NODE && this.finalBaseHolder == null && this.isAtNextToLastNode()) {
                this.finalBaseHolder = new FinalBaseHolder(outcome);
                return this.finalBaseHolder;
            }
            return outcome;
        }

        public InspectorPass getPass() {
            return this.pass;
        }

        public void setPass(InspectorPass pass) {
            this.pass = pass;
        }

        public Object getBase() {
            return this.lastBase;
        }

        public Object getProperty() {
            return this.lastProperty;
        }

        public Object[] getParams() {
            return this.lastParams;
        }

        public Object getOutcome() {
            return this.lastOutcome;
        }
    }

    static class FinalBaseHolder {
        private Object base;

        public FinalBaseHolder(Object base) {
            this.base = base;
        }

        public Object getBase() {
            return this.base;
        }
    }

    static class InspectorElContext
    extends ELContextWrapper {
        private final InspectorElResolver inspectorElResolver;

        public InspectorElContext(ELContext elContext) {
            super(elContext);
            this.inspectorElResolver = new InspectorElResolver(elContext.getELResolver());
        }

        @Override
        public ELResolver getELResolver() {
            return this.inspectorElResolver;
        }

        public Object convertToType(Object value, Class<?> type) {
            return value;
        }

        public InspectorPass getPass() {
            return this.inspectorElResolver.getPass();
        }

        public void setPass(InspectorPass pass) {
            this.inspectorElResolver.setPass(pass);
        }

        public Object getBase() {
            return this.inspectorElResolver.getBase();
        }

        public Object getProperty() {
            return this.inspectorElResolver.getProperty();
        }

        public Object[] getParams() {
            return this.inspectorElResolver.getParams();
        }

        public Object getOutcome() {
            return this.inspectorElResolver.getOutcome();
        }
    }

    private static enum InspectorPass {
        PASS1_FIND_NEXT_TO_LAST_NODE,
        PASS2_FIND_FINAL_NODE;

    }

    private static enum ValueExpressionType {
        METHOD,
        PROPERTY;

    }
}

