/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.validator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import org.omnifaces.component.validator.ValidateMultipleFields;
import org.omnifaces.util.Callback;
import org.omnifaces.util.State;

@FacesComponent(value="org.omnifaces.component.validator.ValidateOrder")
public class ValidateOrder
extends ValidateMultipleFields {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.validator.ValidateOrder";
    private static final String DEFAULT_TYPE = Type.LT.name();
    private static final String ERROR_INVALID_TYPE = "Invalid type '%s'. Only 'lt', 'lte', 'gt' and 'gte' are allowed.";
    private static final String ERROR_VALUES_NOT_COMPARABLE = "All values must implement java.lang.Comparable.";
    private final State state = new State(this.getStateHelper());

    @Override
    public boolean validateValues(FacesContext context2, List<UIInput> components, List<Object> values) {
        try {
            List<Object> tmp = values;
            ArrayList<Object> comparableValues = new ArrayList<Object>(tmp);
            comparableValues.removeAll(Arrays.asList(null, ""));
            return Type.valueOf(this.getType().toUpperCase()).validateOrder(comparableValues);
        }
        catch (ClassCastException e2) {
            throw new IllegalArgumentException(ERROR_VALUES_NOT_COMPARABLE, e2);
        }
    }

    public String getType() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.type), DEFAULT_TYPE);
    }

    public void setType(String type) {
        try {
            Type.valueOf(type.toUpperCase());
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException(String.format(ERROR_INVALID_TYPE, type), e2);
        }
        this.state.put((Serializable)((Object)PropertyKeys.type), type);
    }

    private static enum PropertyKeys {
        type;

    }

    private static enum Type {
        LT(values -> new ArrayList(new TreeSet(values)).equals(values)),
        LTE(values -> {
            ArrayList sortedValues = new ArrayList(values);
            Collections.sort(sortedValues);
            return sortedValues.equals(values);
        }),
        GT(values -> {
            ArrayList sortedValues = new ArrayList(new TreeSet(values));
            Collections.reverse(sortedValues);
            return sortedValues.equals(values);
        }),
        GTE(values -> {
            ArrayList sortedValues = new ArrayList(values);
            Collections.sort(sortedValues, Collections.reverseOrder());
            return sortedValues.equals(values);
        });

        private Callback.ReturningWithArgument<Boolean, List<Comparable>> callback;

        private Type(Callback.ReturningWithArgument<Boolean, List<Comparable>> callback) {
            this.callback = callback;
        }

        public boolean validateOrder(List<Comparable> values) {
            return this.callback.invoke(values);
        }
    }
}

