/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.Serializable;
import java.util.HashSet;
import javax.el.ValueExpression;
import javax.faces.component.FacesComponent;
import javax.faces.context.FacesContext;
import org.omnifaces.cdi.PostScriptParam;
import org.omnifaces.component.input.OnloadParam;
import org.omnifaces.el.ExpressionInspector;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Reflection;

@FacesComponent(value="org.omnifaces.component.input.ScriptParam")
public class ScriptParam
extends OnloadParam {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.input.ScriptParam";
    public static final String EVENT_VALUE = "setScriptParamValues";
    private static final String SCRIPT_INIT = "OmniFaces.ScriptParam.run('%s', %s)";

    @Override
    protected String getInitScript(FacesContext context2) {
        StringBuilder scripts = new StringBuilder("{");
        for (ScriptParam scriptParam : FacesLocal.getScriptParameters(context2)) {
            scripts.append("'").append(scriptParam.getClientId()).append("':").append(scriptParam.getScript()).append(',');
        }
        scripts.append("}");
        return String.format(SCRIPT_INIT, this.getClientId(), scripts);
    }

    @Override
    protected String getEventValue(FacesContext context2) {
        return EVENT_VALUE;
    }

    @Override
    protected void decodeAll(FacesContext context2) {
        HashSet<Object> beans = new HashSet<Object>();
        for (ScriptParam scriptParam : FacesLocal.getScriptParameters(context2)) {
            String value = FacesLocal.getRequestParameter(context2, scriptParam.getClientId());
            scriptParam.decodeImmediately(context2, value);
            ValueExpression valueExpression = scriptParam.getValueExpression("value");
            if (valueExpression == null) continue;
            beans.add(ExpressionInspector.getValueReference(context2.getELContext(), valueExpression).getBase());
        }
        for (ScriptParam scriptParam : beans) {
            Reflection.invokeMethods((Object)scriptParam, PostScriptParam.class);
        }
    }

    public String getScript() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.SCRIPT));
    }

    public void setScript(String script) {
        this.state.put((Serializable)((Object)PropertyKeys.SCRIPT), script);
    }

    public static boolean isScriptParamRequest(FacesContext context2) {
        return ScriptParam.isOnloadParamRequest(context2, EVENT_VALUE);
    }

    private static enum PropertyKeys {
        SCRIPT;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

