/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.faces.application.ResourceDependencies;
import javax.faces.application.ResourceDependency;
import javax.faces.component.FacesComponent;
import javax.faces.component.UIComponent;
import javax.faces.component.UIForm;
import javax.faces.component.UIInput;
import javax.faces.component.UIMessage;
import javax.faces.component.html.HtmlInputFile;
import javax.faces.context.FacesContext;
import javax.servlet.http.Part;
import org.omnifaces.config.OmniFaces;
import org.omnifaces.el.functions.Numbers;
import org.omnifaces.util.Ajax;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Servlets;
import org.omnifaces.util.State;
import org.omnifaces.util.Utils;

@FacesComponent(value="org.omnifaces.component.input.InputFile")
@ResourceDependencies(value={@ResourceDependency(library="javax.faces", name="jsf.js", target="head"), @ResourceDependency(library="omnifaces", name="omnifaces.js", target="head")})
public class InputFile
extends HtmlInputFile {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.input.InputFile";
    private static final String SCRIPT_ONCHANGE = "if(!OmniFaces.InputFile.validate(event,this,'%s',%s))return false;%s";
    private static final String ERROR_MISSING_MESSAGE_COMPONENT = "o:inputFile client side validation of maxsize requires a message(s) component with a fixed ID.";
    private final State state = new State(this.getStateHelper());
    private transient Object transientSubmittedValue;
    private String messageComponentClientId;

    public void decode(FacesContext context2) {
        if ("validationFailed".equals(FacesLocal.getRequestParameter(context2, "omnifaces.event")) && this.getClientId(context2).equals(FacesLocal.getRequestParameter(context2, "javax.faces.source"))) {
            String fileName = FacesLocal.getRequestParameter(context2, "fileName");
            Messages.addError(this.getClientId(context2), this.getMaxsizeMessage(), Components.getLabel((UIComponent)this), fileName, Numbers.formatBytes(this.getMaxsize()));
            this.setValid(false);
            context2.validationFailed();
            Ajax.update(this.getMessageComponentClientId());
            context2.renderResponse();
        } else {
            super.decode(context2);
            Object submittedValue = this.getSubmittedValue();
            if (submittedValue instanceof Part && this.isMultiple()) {
                this.setSubmittedValue(FacesLocal.getRequestParts(context2, ((Part)submittedValue).getName()));
            }
        }
    }

    protected Object getConvertedValue(FacesContext context2, Object submittedValue) {
        if (submittedValue == null) {
            return null;
        }
        if (this.isMultiple()) {
            ArrayList<Part> convertedParts = new ArrayList<Part>();
            for (Part submittedPart : (List)submittedValue) {
                Object convertedPart = super.getConvertedValue(context2, (Object)submittedPart);
                if (!(convertedPart instanceof Part) || Utils.isEmpty(convertedPart)) continue;
                convertedParts.add((Part)convertedPart);
            }
            return Collections.unmodifiableList(convertedParts);
        }
        Object convertedPart = super.getConvertedValue(context2, submittedValue);
        return Utils.isEmpty(convertedPart) ? null : convertedPart;
    }

    protected void validateValue(FacesContext context2, Object convertedValue) {
        Collection<Object> convertedParts = null;
        if (convertedValue instanceof Part) {
            convertedParts = Collections.singleton((Part)convertedValue);
        } else if (convertedValue instanceof List) {
            convertedParts = (List)convertedValue;
        }
        if (convertedParts != null) {
            this.validateParts(context2, convertedParts);
        }
        if (this.isValid()) {
            super.validateValue(context2, convertedValue);
        } else if (FacesLocal.isAjaxRequest(context2)) {
            Ajax.update(this.getMessageComponentClientId());
        }
    }

    public Object getValue() {
        return Faces.isRenderResponse() ? null : super.getValue();
    }

    public void encodeEnd(FacesContext context2) throws IOException {
        Long maxsize;
        String accept;
        Map passThroughAttributes = this.getPassThroughAttributes();
        if (this.isMultiple()) {
            passThroughAttributes.put("multiple", true);
        }
        if (this.isDirectory()) {
            passThroughAttributes.put("directory", true);
            passThroughAttributes.put("webkitdirectory", true);
        }
        if ((accept = this.getAccept()) != null) {
            passThroughAttributes.put("accept", accept);
        }
        if ((maxsize = this.getMaxsize()) != null) {
            this.validateHierarchy();
            this.setOnchange(String.format(SCRIPT_ONCHANGE, this.getMessageComponentClientId(), maxsize, Utils.coalesce(this.getOnchange(), "")));
        }
        super.encodeEnd(context2);
    }

    protected void validateHierarchy() {
        Components.validateHasParent((UIComponent)this, UIForm.class);
        if (Faces.isDevelopment() && this.getMessageComponentClientId() == null) {
            throw new IllegalStateException(ERROR_MISSING_MESSAGE_COMPONENT);
        }
    }

    public Object getSubmittedValue() {
        return this.transientSubmittedValue;
    }

    public void setSubmittedValue(Object submittedValue) {
        this.transientSubmittedValue = submittedValue;
    }

    public boolean isMultiple() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.multiple), this.isDirectory());
    }

    public void setMultiple(boolean multiple) {
        this.state.put((Serializable)((Object)PropertyKeys.multiple), multiple);
    }

    public boolean isDirectory() {
        return (Boolean)this.state.get((Serializable)((Object)PropertyKeys.directory), Boolean.FALSE);
    }

    public void setDirectory(boolean directory) {
        this.state.put((Serializable)((Object)PropertyKeys.directory), directory);
    }

    public String getAccept() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.accept));
    }

    public void setAccept(String accept) {
        this.state.put((Serializable)((Object)PropertyKeys.accept), accept);
    }

    public String getAcceptMessage() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.acceptMessage), OmniFaces.getMessage("org.omnifaces.component.input.InputFile.accept"));
    }

    public void setAcceptMessage(String acceptMessage) {
        this.state.put((Serializable)((Object)PropertyKeys.acceptMessage), acceptMessage);
    }

    public Long getMaxsize() {
        return (Long)this.state.get((Serializable)((Object)PropertyKeys.maxsize));
    }

    public void setMaxsize(Long maxsize) {
        this.state.put((Serializable)((Object)PropertyKeys.maxsize), maxsize);
    }

    public String getMaxsizeMessage() {
        return (String)this.state.get((Serializable)((Object)PropertyKeys.maxsizeMessage), OmniFaces.getMessage("org.omnifaces.component.input.InputFile.maxsize"));
    }

    public void setMaxsizeMessage(String maxsizeMessage) {
        this.state.put((Serializable)((Object)PropertyKeys.maxsizeMessage), maxsizeMessage);
    }

    private void validateParts(FacesContext context2, Collection<Part> parts) {
        String accept = this.getAccept();
        Long maxsize = this.getMaxsize();
        if (accept == null && maxsize == null) {
            return;
        }
        for (Part part : parts) {
            this.validatePart(context2, part, accept, maxsize);
        }
    }

    private void validatePart(FacesContext context2, Part part, String accept, Long maxsize) {
        String fileName = Servlets.getSubmittedFileName(part);
        String message = null;
        String param = null;
        if (accept != null) {
            String contentType;
            String string = contentType = InputFile.isEmpty((Object)fileName) ? part.getContentType() : FacesLocal.getMimeType(context2, fileName.toLowerCase(Faces.getLocale()));
            if (contentType == null || !contentType.matches(this.convertAcceptToRegex(accept))) {
                message = this.getAcceptMessage();
                param = accept;
            }
        }
        if (message == null && maxsize != null && part.getSize() > maxsize) {
            message = this.getMaxsizeMessage();
            param = Numbers.formatBytes(maxsize);
        }
        if (message != null) {
            Messages.addError(this.getClientId(context2), message, Components.getLabel((UIComponent)this), fileName, param);
            this.setValid(false);
        }
    }

    private String convertAcceptToRegex(String accept) {
        String[] parts = accept.replaceAll("\\s*", "").split("(?<=[*,])|(?=[*,])");
        StringBuilder regex = new StringBuilder();
        String[] stringArray = parts;
        int n = stringArray.length;
        block8: for (int i = 0; i < n; ++i) {
            String part;
            switch (part = stringArray[i]) {
                case "*": {
                    regex.append(".*");
                    continue block8;
                }
                case ",": {
                    regex.append("|");
                    continue block8;
                }
                default: {
                    regex.append(Pattern.quote(part));
                }
            }
        }
        return regex.toString();
    }

    private String getMessageComponentClientId() {
        if (this.messageComponentClientId != null) {
            return this.messageComponentClientId;
        }
        UIMessage component = Components.getMessageComponent((UIInput)this);
        if (component == null || component.getId() == null) {
            component = Components.getMessagesComponent();
        }
        this.messageComponentClientId = component != null && component.getId() != null ? component.getClientId() : null;
        return this.messageComponentClientId;
    }

    private static enum PropertyKeys {
        multiple,
        directory,
        accept,
        acceptMessage,
        maxsize,
        maxsizeMessage;

    }
}

