/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.component.input;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.faces.component.FacesComponent;
import javax.faces.context.FacesContext;
import javax.faces.event.PhaseListener;
import org.omnifaces.component.input.ViewParam;
import org.omnifaces.component.input.componentidparam.ConditionalWriterListener;

@FacesComponent(value="org.omnifaces.component.input.ComponentIdParam")
public class ComponentIdParam
extends ViewParam {
    public static final String COMPONENT_TYPE = "org.omnifaces.component.input.ComponentIdParam";

    public void decode(FacesContext context2) {
        List<String> componentIds = this.getRequestValues(context2, PropertyKeys.componentIdName);
        List<String> clientIds = this.getRequestValues(context2, PropertyKeys.clientIdName);
        boolean renderChildren = this.getBooleanAttribute(PropertyKeys.renderChildren);
        if (!componentIds.isEmpty() || !clientIds.isEmpty()) {
            context2.getViewRoot().addPhaseListener((PhaseListener)new ConditionalWriterListener(componentIds, clientIds, renderChildren));
        }
    }

    @Override
    public void processValidators(FacesContext context2) {
    }

    public void processUpdates(FacesContext context2) {
    }

    private List<String> getRequestValues(FacesContext context2, PropertyKeys propertyKey) {
        String[] values;
        String componentIdName = (String)this.getAttributes().get(propertyKey.name());
        if (componentIdName != null && (values = (String[])context2.getExternalContext().getRequestParameterValuesMap().get(componentIdName)) != null) {
            return Arrays.asList(values);
        }
        return Collections.emptyList();
    }

    private boolean getBooleanAttribute(PropertyKeys propertyKey) {
        String attribute = (String)this.getAttributes().get(propertyKey.name());
        return attribute == null || Boolean.parseBoolean(attribute);
    }

    private static enum PropertyKeys {
        componentIdName,
        clientIdName,
        renderChildren;

    }
}

