/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.push;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.ApplicationScoped;

@ApplicationScoped
public class SocketUserManager {
    private static final int ESTIMATED_USER_CHANNELS_PER_APPLICATION = 1;
    private static final int ESTIMATED_USER_CHANNELS_PER_SESSION = 1;
    private static final int ESTIMATED_SESSIONS_PER_USER = 2;
    private static final int ESTIMATED_CHANNELS_IDS_PER_USER = 2;
    private final ConcurrentHashMap<String, ConcurrentHashMap<String, Set<String>>> userChannels = new ConcurrentHashMap();
    private final ConcurrentHashMap<Serializable, Set<String>> applicationUsers = new ConcurrentHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void register(Serializable user, String userId) {
        ConcurrentHashMap<Serializable, Set<String>> concurrentHashMap = this.applicationUsers;
        synchronized (concurrentHashMap) {
            if (!this.applicationUsers.containsKey(user)) {
                this.applicationUsers.putIfAbsent(user, Collections.synchronizedSet(new HashSet(2)));
            }
            this.applicationUsers.get(user).add(userId);
        }
    }

    protected void addChannelId(String userId, String channel, String channelId) {
        ConcurrentHashMap<String, Set<String>> channelIds;
        if (!this.userChannels.containsKey(userId)) {
            this.userChannels.putIfAbsent(userId, new ConcurrentHashMap(1));
        }
        if (!(channelIds = this.userChannels.get(userId)).containsKey(channel)) {
            channelIds.putIfAbsent(channel, Collections.synchronizedSet(new HashSet(1)));
        }
        channelIds.get(channel).add(channelId);
    }

    protected Serializable getUser(String channel, String channelId) {
        for (Map.Entry<Serializable, Set<String>> applicationUser : this.applicationUsers.entrySet()) {
            for (String userId : applicationUser.getValue()) {
                if (!this.getApplicationUserChannelIds(userId, channel).contains(channelId)) continue;
                return applicationUser.getKey();
            }
        }
        return null;
    }

    protected Set<String> getChannelIds(Serializable user, String channel) {
        HashSet<String> channelIds = new HashSet<String>(2);
        Set<String> userIds = this.applicationUsers.get(user);
        if (userIds != null) {
            for (String userId : userIds) {
                channelIds.addAll(this.getApplicationUserChannelIds(userId, channel));
            }
        }
        return channelIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deregister(Serializable user, String userId) {
        this.userChannels.remove(userId);
        ConcurrentHashMap<Serializable, Set<String>> concurrentHashMap = this.applicationUsers;
        synchronized (concurrentHashMap) {
            Set<String> userIds = this.applicationUsers.get(user);
            userIds.remove(userId);
            if (userIds.isEmpty()) {
                this.applicationUsers.remove(user);
            }
        }
    }

    protected ConcurrentHashMap<String, ConcurrentHashMap<String, Set<String>>> getUserChannels() {
        return this.userChannels;
    }

    private Set<String> getApplicationUserChannelIds(String userId, String channel) {
        Set channelIds;
        Map channels = this.userChannels.get(userId);
        if (channels != null && (channelIds = (Set)channels.get(channel)) != null) {
            return channelIds;
        }
        return Collections.emptySet();
    }
}

