/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.param;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.el.ValueExpression;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.faces.application.Application;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.convert.Converter;
import javax.faces.convert.ConverterException;
import javax.faces.validator.RequiredValidator;
import javax.faces.validator.Validator;
import javax.faces.validator.ValidatorException;
import javax.inject.Inject;
import javax.validation.ConstraintViolation;
import org.omnifaces.cdi.Param;
import org.omnifaces.cdi.param.Attribute;
import org.omnifaces.cdi.param.ParamValue;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Components;
import org.omnifaces.util.Faces;
import org.omnifaces.util.FacesLocal;
import org.omnifaces.util.Messages;
import org.omnifaces.util.Reflection;
import org.omnifaces.util.Utils;
import org.omnifaces.util.Validators;

@Dependent
public class ParamProducer {
    private static final String DEFAULT_REQUIRED_MESSAGE = "{0}: Value is required";
    private static Boolean interpretEmptyStringSubmittedValuesAsNull;
    @Inject
    private InjectionPoint injectionPoint;

    @Produces
    @Param
    public <V> ParamValue<V> produce(InjectionPoint injectionPoint) {
        Param param = Beans.getQualifier(injectionPoint, Param.class);
        String name = ParamProducer.getName(param, injectionPoint);
        String label = ParamProducer.getLabel(param, injectionPoint);
        Type type = ParamProducer.getType(injectionPoint);
        FacesContext context2 = FacesContext.getCurrentInstance();
        String[] submittedValues = param.pathIndex() > -1 ? ParamProducer.getPathParameter(context2, param.pathIndex()) : ParamProducer.getSubmittedValues(context2, name);
        Class<?> sourceType = ParamProducer.getSourceType(type);
        Class<V> targetType = ParamProducer.getTargetType(type);
        ParamValue<V> paramValue = new ParamValue<V>(param, name, label, sourceType, submittedValues, targetType);
        Object[] convertedValues = ParamProducer.getConvertedValues(context2, paramValue);
        V value = ParamProducer.coerceValues(sourceType, convertedValues);
        paramValue.setValue(ParamProducer.validateValues(context2, paramValue, convertedValues, value, injectionPoint) ? value : null);
        return paramValue;
    }

    private static String getName(Param requestParameter, InjectionPoint injectionPoint) {
        String name = requestParameter.name();
        if (Utils.isEmpty(name)) {
            AnnotatedParameter annotatedParameter;
            Parameter javaParameter;
            if (injectionPoint.getAnnotated() instanceof AnnotatedParameter && (javaParameter = (annotatedParameter = (AnnotatedParameter)injectionPoint.getAnnotated()).getJavaParameter()).isNamePresent()) {
                return javaParameter.getName();
            }
            name = injectionPoint.getMember().getName();
        } else {
            name = ParamProducer.evaluateExpressionAsString(name);
        }
        return name;
    }

    private static String getLabel(Param requestParameter, InjectionPoint injectionPoint) {
        String label = requestParameter.label();
        label = Utils.isEmpty(label) ? ParamProducer.getName(requestParameter, injectionPoint) : ParamProducer.evaluateExpressionAsString(label);
        return label;
    }

    private static Type getType(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (type instanceof ParameterizedType && ParamValue.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
            type = ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return type;
    }

    private static String[] getPathParameter(FacesContext context2, int pathIndex) {
        String pathInfo = FacesLocal.getRequestPathInfo(context2);
        if (!Utils.isEmpty(pathInfo)) {
            String[] pathParts;
            if (pathInfo.charAt(0) == '/') {
                pathInfo = pathInfo.substring(1);
            }
            if (pathIndex < (pathParts = pathInfo.split("/")).length) {
                return new String[]{pathParts[pathIndex]};
            }
        }
        return null;
    }

    private static String[] getSubmittedValues(FacesContext context2, String name) {
        String[] requestParameterValues = FacesLocal.getRequestParameterValues(context2, name);
        if (requestParameterValues == null) {
            return null;
        }
        String[] submittedValues = new String[requestParameterValues.length];
        for (int i = 0; i < requestParameterValues.length; ++i) {
            String requestParameterValue = requestParameterValues[i];
            submittedValues[i] = requestParameterValue != null && requestParameterValue.isEmpty() && ParamProducer.interpretEmptyStringSubmittedValuesAsNull(context2) ? null : requestParameterValue;
        }
        return submittedValues;
    }

    private static boolean interpretEmptyStringSubmittedValuesAsNull(FacesContext context2) {
        if (interpretEmptyStringSubmittedValuesAsNull != null) {
            return interpretEmptyStringSubmittedValuesAsNull;
        }
        interpretEmptyStringSubmittedValuesAsNull = Boolean.parseBoolean(context2.getExternalContext().getInitParameter("javax.faces.INTERPRET_EMPTY_STRING_SUBMITTED_VALUES_AS_NULL"));
        return interpretEmptyStringSubmittedValuesAsNull;
    }

    static Object[] getConvertedValues(FacesContext context2, ParamValue paramValue) {
        if (paramValue.submittedValues == null) {
            return null;
        }
        Object[] convertedValues = new Object[paramValue.submittedValues.length];
        boolean valid = ParamProducer.runWithSimulatedLabelAndValueOnViewRoot(context2, paramValue, () -> ParamProducer.invokeConverter(context2, paramValue, convertedValues));
        if (!valid) {
            context2.validationFailed();
            return null;
        }
        return convertedValues;
    }

    private static boolean invokeConverter(FacesContext context2, ParamValue paramValue, Object[] convertedValues) {
        boolean valid = true;
        Converter converter = ParamProducer.getConverter(paramValue);
        for (int i = 0; i < paramValue.submittedValues.length; ++i) {
            String submittedValue = paramValue.submittedValues[i];
            try {
                convertedValues[i] = converter != null ? converter.getAsObject(context2, (UIComponent)context2.getViewRoot(), submittedValue) : submittedValue;
                continue;
            }
            catch (ConverterException e2) {
                valid = false;
                ParamProducer.addConverterMessage(context2, (UIComponent)context2.getViewRoot(), paramValue.label, submittedValue, e2, ParamProducer.getConverterMessage(paramValue.param));
            }
        }
        return valid;
    }

    private static Converter getConverter(ParamValue paramValue) {
        Class<Object> classIdentifier = paramValue.param.converterClass() == Converter.class ? paramValue.targetType : paramValue.param.converterClass();
        Converter converter = Faces.createConverter(Utils.coalesce(Faces.evaluateExpressionGet(paramValue.param.converter()), classIdentifier));
        if (converter != null) {
            Reflection.setPropertiesWithCoercion(converter, ParamProducer.getConverterAttributes(paramValue.param));
        }
        return converter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean runWithSimulatedLabelAndValueOnViewRoot(FacesContext context2, ParamValue paramValue, BooleanSupplier callback) {
        UIViewRoot component = context2.getViewRoot();
        Object originalLabel = ParamProducer.getAttribute((UIComponent)component, "label");
        Object originalValue = ParamProducer.getAttribute((UIComponent)component, "value");
        try {
            ParamProducer.setAttribute((UIComponent)component, "label", paramValue.label);
            ParamProducer.setAttribute((UIComponent)component, "value", Components.createValueExpression("#{param['" + paramValue.name + "']}", paramValue.targetType));
            boolean bl = callback.getAsBoolean();
            return bl;
        }
        finally {
            ParamProducer.setAttribute((UIComponent)component, "label", originalLabel);
            ParamProducer.setAttribute((UIComponent)component, "value", originalValue);
        }
    }

    private static Object getAttribute(UIComponent component, String name) {
        ValueExpression valueExpression = component.getValueExpression(name);
        if (valueExpression != null) {
            return valueExpression;
        }
        return component.getAttributes().get(name);
    }

    private static void setAttribute(UIComponent component, String name, Object value) {
        if (value instanceof ValueExpression) {
            component.setValueExpression(name, (ValueExpression)value);
        } else if (value != null) {
            component.getAttributes().put(name, value);
        } else {
            component.getAttributes().remove(name);
        }
    }

    static <V> V coerceValues(Class<?> sourceType, Object ... values) {
        List<Object> coercedValue = null;
        if (values != null) {
            if (sourceType.isArray()) {
                coercedValue = Array.newInstance(sourceType.getComponentType(), values.length);
                for (int i = 0; i < values.length; ++i) {
                    Array.set(coercedValue, i, ParamProducer.coerceValues(sourceType.getComponentType(), values[i]));
                }
            } else if (List.class.isAssignableFrom(sourceType)) {
                coercedValue = Arrays.asList(values);
            } else {
                List<Object> list = coercedValue = values.length == 0 ? null : values[0];
            }
        }
        if (coercedValue == null) {
            coercedValue = Utils.getDefaultValue(sourceType);
        }
        return (V)coercedValue;
    }

    private static <V> boolean validateValues(FacesContext context2, ParamValue paramValue, Object[] convertedValues, V value, InjectionPoint injectionPoint) {
        boolean valid = ParamProducer.runWithSimulatedLabelAndValueOnViewRoot(context2, paramValue, () -> ParamProducer.invokeValidators(context2, paramValue, convertedValues, value, injectionPoint));
        if (!valid) {
            context2.validationFailed();
        }
        return valid;
    }

    private static <V> boolean invokeValidators(FacesContext context2, ParamValue paramValue, Object[] convertedValues, V value, InjectionPoint injectionPoint) {
        boolean valid = ParamProducer.validateRequired(context2, paramValue, convertedValues);
        if (valid) {
            valid = ParamProducer.validateBean(context2, paramValue, value, injectionPoint);
        }
        if (valid && convertedValues != null) {
            valid = ParamProducer.validateFaces(context2, paramValue, convertedValues);
        }
        return valid;
    }

    private static boolean validateRequired(FacesContext context2, ParamValue paramValue, Object[] convertedValues) {
        if (paramValue.param.required() && (Utils.isEmpty(convertedValues) || Arrays.asList(convertedValues).contains(null))) {
            ParamProducer.addRequiredMessage(context2, (UIComponent)context2.getViewRoot(), paramValue.label, ParamProducer.getRequiredMessage(paramValue.param));
            return false;
        }
        return true;
    }

    private static <V> boolean validateBean(FacesContext context2, ParamValue paramValue, V value, InjectionPoint injectionPoint) {
        Set<ConstraintViolation<?>> violations;
        if (ParamProducer.shouldDoBeanValidation(paramValue.param, injectionPoint) && !(violations = ParamProducer.doBeanValidation(value, injectionPoint)).isEmpty()) {
            for (ConstraintViolation<?> violation : violations) {
                context2.addMessage(context2.getViewRoot().getClientId(context2), Messages.createError(violation.getMessage(), paramValue.label));
            }
            return false;
        }
        return true;
    }

    private static boolean validateFaces(FacesContext context2, ParamValue paramValue, Object[] convertedValues) {
        boolean valid = true;
        for (Validator validator : ParamProducer.getValidators(paramValue.param)) {
            int i = 0;
            for (Object convertedValue : convertedValues) {
                try {
                    validator.validate(context2, (UIComponent)context2.getViewRoot(), convertedValue);
                }
                catch (ValidatorException e2) {
                    ParamProducer.addValidatorMessages(context2, (UIComponent)context2.getViewRoot(), paramValue.label, paramValue.submittedValues[i], e2, ParamProducer.getValidatorMessage(paramValue.param));
                    valid = false;
                }
                ++i;
            }
        }
        return valid;
    }

    static Class<?> getSourceType(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    static <V> Class<V> getTargetType(Type type) {
        if (type instanceof Class && ((Class)type).isArray()) {
            return ((Class)type).getComponentType();
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return (Class)type;
    }

    private static String getValidatorMessage(Param requestParameter) {
        return ParamProducer.evaluateExpressionAsString(requestParameter.validatorMessage());
    }

    private static String getConverterMessage(Param requestParameter) {
        return ParamProducer.evaluateExpressionAsString(requestParameter.converterMessage());
    }

    private static String getRequiredMessage(Param requestParameter) {
        return ParamProducer.evaluateExpressionAsString(requestParameter.requiredMessage());
    }

    private static String evaluateExpressionAsString(String expression) {
        if (Utils.isEmpty(expression)) {
            return expression;
        }
        Object expressionResult = Faces.evaluateExpressionGet(expression);
        if (expressionResult == null) {
            return null;
        }
        return expressionResult.toString();
    }

    private static boolean shouldDoBeanValidation(Param requestParameter, InjectionPoint injectionPoint) {
        if (requestParameter.disableBeanValidation()) {
            return false;
        }
        if (!requestParameter.overrideGlobalBeanValidationDisabled() && Boolean.parseBoolean(Faces.getInitParameter("javax.faces.validator.DISABLE_DEFAULT_BEAN_VALIDATOR"))) {
            return false;
        }
        if (!(injectionPoint.getMember() instanceof Field)) {
            return false;
        }
        return Validators.isBeanValidationAvailable();
    }

    private static <V> Set<ConstraintViolation<?>> doBeanValidation(V value, InjectionPoint injectionPoint) {
        Type propertyRawType;
        Class base = injectionPoint.getBean().getBeanClass();
        String property = injectionPoint.getMember().getName();
        Type type = injectionPoint.getType();
        Object valueToValidate = value;
        if (type instanceof ParameterizedType && (propertyRawType = ((ParameterizedType)type).getRawType()).equals(ParamValue.class)) {
            valueToValidate = new ParamValue<V>(value);
        }
        return Validators.validateBeanProperty(base, property, valueToValidate, new Class[0]);
    }

    private static List<Validator> getValidators(Param requestParameter) {
        ArrayList<Validator> validators = new ArrayList<Validator>();
        for (String validatorIdentifier : requestParameter.validators()) {
            Object evaluatedValidatorIdentifier = Faces.evaluateExpressionGet(validatorIdentifier);
            Validator validator = Faces.createValidator(evaluatedValidatorIdentifier);
            if (validator == null) continue;
            validators.add(validator);
        }
        for (Class<? extends Validator> validatorClass : requestParameter.validatorClasses()) {
            Validator validator = Faces.createValidator(validatorClass);
            if (validator == null) continue;
            validators.add(validator);
        }
        Application application = Faces.getApplication();
        for (Map.Entry validatorEntry : application.getDefaultValidatorInfo().entrySet()) {
            String validatorID = (String)validatorEntry.getKey();
            String validatorClassName = (String)validatorEntry.getValue();
            if (validatorID.equals("javax.faces.Bean") || Utils.containsByClassName(validators, validatorClassName)) continue;
            validators.add(application.createValidator(validatorID));
        }
        Map<String, Object> validatorAttributes = ParamProducer.getValidatorAttributes(requestParameter);
        for (Validator validator : validators) {
            Reflection.setPropertiesWithCoercion(validator, validatorAttributes);
        }
        return validators;
    }

    private static Map<String, Object> getConverterAttributes(Param requestParameter) {
        Attribute[] attributes;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (Attribute attribute : attributes = requestParameter.converterAttributes()) {
            attributeMap.put(attribute.name(), Faces.evaluateExpressionGet(attribute.value()));
        }
        return attributeMap;
    }

    private static Map<String, Object> getValidatorAttributes(Param requestParameter) {
        Attribute[] attributes;
        HashMap<String, Object> attributeMap = new HashMap<String, Object>();
        for (Attribute attribute : attributes = requestParameter.validatorAttributes()) {
            attributeMap.put(attribute.name(), Faces.evaluateExpressionGet(attribute.value()));
        }
        return attributeMap;
    }

    private static void addConverterMessage(FacesContext context2, UIComponent component, String label, String submittedValue, ConverterException ce, String converterMessage) {
        FacesMessage message;
        if (!Utils.isEmpty(converterMessage)) {
            message = Messages.createError(converterMessage, submittedValue, label);
        } else {
            message = ce.getFacesMessage();
            if (message == null) {
                message = Messages.createError("Conversion failed for {0} because: {1}", submittedValue, ce.getMessage());
            }
        }
        context2.addMessage(component.getClientId(context2), message);
    }

    private static void addRequiredMessage(FacesContext context2, UIComponent component, String label, String requiredMessage) {
        FacesMessage message = null;
        if (!Utils.isEmpty(requiredMessage)) {
            message = Messages.createError(requiredMessage, null, label);
        } else {
            try {
                new RequiredValidator().validate(context2, component, null);
            }
            catch (ValidatorException ve) {
                message = ve.getFacesMessage();
            }
            if (message == null) {
                ResourceBundle messageBundle = FacesLocal.getMessageBundle(context2);
                String defaultRequiredMessage = messageBundle != null ? messageBundle.getString("javax.faces.component.UIInput.REQUIRED") : null;
                message = Messages.createError(Utils.coalesce(defaultRequiredMessage, requiredMessage, DEFAULT_REQUIRED_MESSAGE), label);
            }
        }
        context2.addMessage(component.getClientId(context2), message);
    }

    private static void addValidatorMessages(FacesContext context2, UIComponent component, String label, String submittedValue, ValidatorException ve, String validatorMessage) {
        String clientId = component.getClientId(context2);
        if (!Utils.isEmpty(validatorMessage)) {
            context2.addMessage(clientId, Messages.createError(validatorMessage, submittedValue, label));
        } else {
            for (FacesMessage facesMessage : ParamProducer.getFacesMessages(ve)) {
                context2.addMessage(clientId, facesMessage);
            }
        }
    }

    private static List<FacesMessage> getFacesMessages(ValidatorException ve) {
        ArrayList<FacesMessage> facesMessages = new ArrayList<FacesMessage>();
        if (ve.getFacesMessages() != null) {
            facesMessages.addAll(ve.getFacesMessages());
        } else if (ve.getFacesMessage() != null) {
            facesMessages.add(ve.getFacesMessage());
        }
        return facesMessages;
    }
}

