/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.param;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.Annotated;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.ProcessInjectionTarget;
import javax.inject.Inject;
import javax.inject.Qualifier;
import org.omnifaces.cdi.InjectionTargetWrapper;
import org.omnifaces.cdi.Param;
import org.omnifaces.cdi.param.DynamicParamValueProducer;
import org.omnifaces.cdi.param.ParamProducer;
import org.omnifaces.cdi.param.ParamValue;
import org.omnifaces.util.Beans;
import org.omnifaces.util.Reflection;

public class ParamExtension
implements Extension {
    private Set<Type> paramsWithInject = new HashSet<Type>();

    public <T> void collectParams(@Observes ProcessInjectionTarget<T> event) {
        HashSet paramsWithoutInject = new HashSet();
        for (AnnotatedField field : event.getAnnotatedType().getFields()) {
            ParamExtension.collectParams((Annotated)field, this.paramsWithInject, paramsWithoutInject);
        }
        for (AnnotatedConstructor constructor : event.getAnnotatedType().getConstructors()) {
            for (AnnotatedParameter parameter : constructor.getParameters()) {
                ParamExtension.collectParams((Annotated)parameter, this.paramsWithInject, null);
            }
        }
        ParamExtension.processParamsWithoutInject(event, paramsWithoutInject);
    }

    private static void collectParams(Annotated annotated, Set<Type> paramsWithInject, Set<AnnotatedField<?>> paramsWithoutInject) {
        if (annotated.isAnnotationPresent(Param.class)) {
            Type type = annotated.getBaseType();
            if (type instanceof ParameterizedType && ParamValue.class.isAssignableFrom((Class)((ParameterizedType)type).getRawType())) {
                return;
            }
            if (annotated.isAnnotationPresent(Inject.class) || annotated instanceof AnnotatedParameter && ((AnnotatedParameter)annotated).getDeclaringCallable().isAnnotationPresent(Inject.class)) {
                paramsWithInject.add(type);
            } else if (annotated instanceof AnnotatedField) {
                paramsWithoutInject.add((AnnotatedField)annotated);
            }
        }
    }

    public void processParamsWithInject(@Observes AfterBeanDiscovery event) {
        for (Type paramWithInject : this.paramsWithInject) {
            event.addBean((Bean)new DynamicParamValueProducer(paramWithInject));
        }
    }

    public static <T> void processParamsWithoutInject(ProcessInjectionTarget<T> event, Set<AnnotatedField<?>> paramsWithoutInject) {
        if (!paramsWithoutInject.isEmpty()) {
            event.setInjectionTarget(new ParamInjectionTarget(event.getInjectionTarget(), paramsWithoutInject));
        }
    }

    private static final class ParamInjectionTarget<T>
    extends InjectionTargetWrapper<T> {
        private Set<AnnotatedField<?>> paramsWithoutInject = new HashSet();

        public ParamInjectionTarget(InjectionTarget<T> wrapped, Set<AnnotatedField<?>> paramsWithoutInject) {
            super(wrapped);
            this.paramsWithoutInject = paramsWithoutInject;
        }

        @Override
        public void inject(T instance, CreationalContext<T> ctx) {
            Class<?> beanClass = Beans.unwrapIfNecessary(instance.getClass());
            for (AnnotatedField<?> paramWithoutInject : this.paramsWithoutInject) {
                ParamValue paramValue = new ParamProducer().produce(new ParamInjectionPoint(beanClass, paramWithoutInject));
                Field field = paramWithoutInject.getJavaMember();
                Reflection.modifyField(instance, field, paramValue.getValue());
            }
            super.inject(instance, ctx);
        }

        private static final class ParamInjectionPoint
        implements InjectionPoint {
            private Bean<?> bean;
            private AnnotatedField<?> paramWithoutInject;

            public ParamInjectionPoint(Class<?> beanClass, AnnotatedField<?> paramWithoutInject) {
                this.bean = Beans.resolve(beanClass, new Annotation[0]);
                this.paramWithoutInject = paramWithoutInject;
            }

            public Type getType() {
                return this.paramWithoutInject.getBaseType();
            }

            public Set<Annotation> getQualifiers() {
                return Arrays.stream(this.paramWithoutInject.getJavaMember().getAnnotations()).filter(annotation -> annotation.annotationType().isAnnotationPresent(Qualifier.class)).collect(Collectors.toSet());
            }

            public Bean<?> getBean() {
                return this.bean;
            }

            public Member getMember() {
                return this.paramWithoutInject.getJavaMember();
            }

            public Annotated getAnnotated() {
                return this.paramWithoutInject;
            }

            public boolean isDelegate() {
                return true;
            }

            public boolean isTransient() {
                return true;
            }
        }
    }
}

