/*
 * Decompiled with CFR 0.152.
 */
package org.omnifaces.cdi.eager;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.servlet.ServletContext;
import org.omnifaces.cdi.eager.EagerBeansWebListener;
import org.omnifaces.util.Beans;
import org.omnifaces.util.BeansLocal;
import org.omnifaces.util.Utils;

@ApplicationScoped
public class EagerBeansRepository {
    private static final Logger logger = Logger.getLogger(EagerBeansRepository.class.getName());
    private static final String MISSING_REQUEST_URI_OR_VIEW_ID = "Bean '%s' was annotated with @Eager, but required attribute 'requestURI' or 'viewId' is missing. Bean will not be eagerly instantiated.";
    private static final String MISSING_VIEW_ID = "Bean '%s' was annotated with @Eager, but required attribute 'viewId' is missing. Bean will not be eagerly instantiated.";
    private static final String WARNING_POSSIBLY_APPLICATION_SCOPE_NOT_ACTIVE = "Could not instantiate eager application scoped beans. Possibly the CDI application scope is not active. This is known to be the case in certain Tomcat and Jetty based configurations.";
    private static EagerBeansRepository instance;
    @Inject
    private BeanManager beanManager;
    private EagerBeans eagerBeans;

    public static EagerBeansRepository getInstance() {
        if (instance == null) {
            instance = Beans.getReference(EagerBeansRepository.class, new Annotation[0]);
        }
        return instance;
    }

    protected void setEagerBeans(EagerBeans eagerBeans) {
        this.eagerBeans = eagerBeans;
    }

    public static void instantiateApplicationScopedAndRegisterListenerIfNecessary(ServletContext servletContext) {
        try {
            if (EagerBeansRepository.getInstance() != null && instance.hasAnyApplicationScopedBeans()) {
                instance.instantiateApplicationScoped();
            }
        }
        catch (Exception e2) {
            logger.log(Level.WARNING, String.format(WARNING_POSSIBLY_APPLICATION_SCOPE_NOT_ACTIVE, new Object[0]), e2);
            instance = null;
        }
        if (instance == null || instance.hasAnySessionOrRequestURIBeans()) {
            servletContext.addListener(EagerBeansWebListener.class);
        }
    }

    protected boolean hasAnyApplicationScopedBeans() {
        return this.eagerBeans != null && !Utils.isEmpty(this.eagerBeans.applicationScoped);
    }

    protected boolean hasAnySessionOrRequestURIBeans() {
        return this.eagerBeans != null && (!Utils.isEmpty(this.eagerBeans.sessionScoped) || !Utils.isEmpty(this.eagerBeans.byRequestURI));
    }

    protected boolean hasAnyViewIdBeans() {
        return this.eagerBeans != null && !Utils.isEmpty(this.eagerBeans.byViewId);
    }

    public void instantiateApplicationScoped() {
        this.instantiateBeans(this.eagerBeans.applicationScoped);
    }

    public boolean instantiateSessionScoped() {
        return this.eagerBeans != null && this.instantiateBeans(this.eagerBeans.sessionScoped);
    }

    public boolean instantiateByRequestURI(String relativeRequestURI) {
        return this.eagerBeans != null && this.instantiateBeans(this.eagerBeans.byRequestURI, relativeRequestURI);
    }

    public void instantiateByViewID(String viewId) {
        this.instantiateBeans(this.eagerBeans.byViewId, viewId);
    }

    private boolean instantiateBeans(Map<String, List<Bean<?>>> beansByKey, String key) {
        if (Utils.isAnyEmpty(beansByKey, key)) {
            return false;
        }
        this.instantiateBeans(beansByKey.get(key));
        return true;
    }

    private boolean instantiateBeans(List<Bean<?>> beans) {
        if (Utils.isAnyEmpty(beans, this.beanManager)) {
            return false;
        }
        for (Bean<?> bean : beans) {
            BeansLocal.getInstance(this.beanManager, bean, true).toString();
        }
        return true;
    }

    protected static class EagerBeans {
        private List<Bean<?>> applicationScoped = new ArrayList();
        private List<Bean<?>> sessionScoped = new ArrayList();
        private Map<String, List<Bean<?>>> byViewId = new ConcurrentHashMap();
        private Map<String, List<Bean<?>>> byRequestURI = new ConcurrentHashMap();

        protected EagerBeans() {
        }

        void addApplicationScoped(Bean<?> bean) {
            this.applicationScoped.add(bean);
        }

        void addSessionScoped(Bean<?> bean) {
            this.sessionScoped.add(bean);
        }

        void addByViewId(Bean<?> bean, String viewId) {
            if (!Utils.isEmpty(viewId)) {
                this.getByViewId(viewId).add(bean);
            } else if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, String.format(EagerBeansRepository.MISSING_VIEW_ID, bean.getBeanClass().getName()));
            }
        }

        void addByRequestURIOrViewId(Bean<?> bean, String requestURI, String viewId) {
            if (!Utils.isEmpty(requestURI)) {
                this.getByRequestURI(requestURI).add(bean);
            } else if (!Utils.isEmpty(viewId)) {
                this.getByViewId(viewId).add(bean);
            } else if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, String.format(EagerBeansRepository.MISSING_REQUEST_URI_OR_VIEW_ID, bean.getBeanClass().getName()));
            }
        }

        private List<Bean<?>> getByViewId(String viewId) {
            return this.byViewId.computeIfAbsent(viewId, k -> new ArrayList());
        }

        private List<Bean<?>> getByRequestURI(String requestURI) {
            return this.byRequestURI.computeIfAbsent(requestURI, k -> new ArrayList());
        }

        public boolean isEmpty() {
            return this.applicationScoped.isEmpty() && this.sessionScoped.isEmpty() && this.byViewId.isEmpty() && this.byRequestURI.isEmpty();
        }
    }
}

